"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .airlineleg import AirlineLeg, AirlineLegTypedDict
from .airlinepassenger import AirlinePassenger, AirlinePassengerTypedDict
from datetime import datetime
from gr4vy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


TicketDeliveryMethod = Union[Literal["electronic", "other"], UnrecognizedStr]


class AirlineTypedDict(TypedDict):
    r"""Information about an airline travel."""

    booking_code: NotRequired[Nullable[str]]
    r"""The unique identifier of the reservation in the global distribution system."""
    is_cardholder_traveling: NotRequired[Nullable[bool]]
    r"""Indicates whether the cardholder is traveling."""
    issued_address: NotRequired[Nullable[str]]
    r"""The address of the place/agency that issued the ticket."""
    issued_at: NotRequired[Nullable[datetime]]
    r"""The date that the ticket was last issued in the airline reservation system."""
    issuing_carrier_code: NotRequired[Nullable[str]]
    r"""For airline aggregators, three-character IATA code of the airline issuing the ticket."""
    issuing_carrier_name: NotRequired[Nullable[str]]
    r"""For airline aggregators, name of the airline issuing the ticket."""
    issuing_iata_designator: NotRequired[Nullable[str]]
    r"""For airline aggregators, two-character IATA code of the airline issuing the ticket."""
    issuing_icao_code: NotRequired[Nullable[str]]
    r"""For airline aggregators, three-character ICAO code of the airline issuing the ticket."""
    legs: NotRequired[Nullable[List[AirlineLegTypedDict]]]
    r"""An array of separate trip segments. Each leg contains detailed itinerary information."""
    passenger_name_record: NotRequired[Nullable[str]]
    r"""The Passenger Name Record (PNR) in the airline reservation system."""
    passengers: NotRequired[Nullable[List[AirlinePassengerTypedDict]]]
    r"""An array of the travelling passengers."""
    reservation_system: NotRequired[Nullable[str]]
    r"""The name of the reservation system."""
    restricted_ticket: NotRequired[Nullable[bool]]
    r"""Indicates whether the ticket is restricted (refundable)."""
    ticket_delivery_method: NotRequired[Nullable[TicketDeliveryMethod]]
    r"""The delivery method of the ticket."""
    ticket_number: NotRequired[Nullable[str]]
    r"""The airline's unique ticket number."""
    travel_agency_code: NotRequired[Nullable[str]]
    r"""The IATA travel agency code."""
    travel_agency_invoice_number: NotRequired[Nullable[str]]
    r"""The reference number of the invoice that was issued by the travel agency."""
    travel_agency_name: NotRequired[Nullable[str]]
    r"""The name of the travel agency."""
    travel_agency_plan_name: NotRequired[Nullable[str]]
    r"""The name of the travel agency plan."""


class Airline(BaseModel):
    r"""Information about an airline travel."""

    booking_code: OptionalNullable[str] = UNSET
    r"""The unique identifier of the reservation in the global distribution system."""

    is_cardholder_traveling: OptionalNullable[bool] = UNSET
    r"""Indicates whether the cardholder is traveling."""

    issued_address: OptionalNullable[str] = UNSET
    r"""The address of the place/agency that issued the ticket."""

    issued_at: OptionalNullable[datetime] = UNSET
    r"""The date that the ticket was last issued in the airline reservation system."""

    issuing_carrier_code: OptionalNullable[str] = UNSET
    r"""For airline aggregators, three-character IATA code of the airline issuing the ticket."""

    issuing_carrier_name: OptionalNullable[str] = UNSET
    r"""For airline aggregators, name of the airline issuing the ticket."""

    issuing_iata_designator: OptionalNullable[str] = UNSET
    r"""For airline aggregators, two-character IATA code of the airline issuing the ticket."""

    issuing_icao_code: OptionalNullable[str] = UNSET
    r"""For airline aggregators, three-character ICAO code of the airline issuing the ticket."""

    legs: OptionalNullable[List[AirlineLeg]] = UNSET
    r"""An array of separate trip segments. Each leg contains detailed itinerary information."""

    passenger_name_record: OptionalNullable[str] = UNSET
    r"""The Passenger Name Record (PNR) in the airline reservation system."""

    passengers: OptionalNullable[List[AirlinePassenger]] = UNSET
    r"""An array of the travelling passengers."""

    reservation_system: OptionalNullable[str] = UNSET
    r"""The name of the reservation system."""

    restricted_ticket: OptionalNullable[bool] = UNSET
    r"""Indicates whether the ticket is restricted (refundable)."""

    ticket_delivery_method: Annotated[
        OptionalNullable[TicketDeliveryMethod],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The delivery method of the ticket."""

    ticket_number: OptionalNullable[str] = UNSET
    r"""The airline's unique ticket number."""

    travel_agency_code: OptionalNullable[str] = UNSET
    r"""The IATA travel agency code."""

    travel_agency_invoice_number: OptionalNullable[str] = UNSET
    r"""The reference number of the invoice that was issued by the travel agency."""

    travel_agency_name: OptionalNullable[str] = UNSET
    r"""The name of the travel agency."""

    travel_agency_plan_name: OptionalNullable[str] = UNSET
    r"""The name of the travel agency plan."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "booking_code",
            "is_cardholder_traveling",
            "issued_address",
            "issued_at",
            "issuing_carrier_code",
            "issuing_carrier_name",
            "issuing_iata_designator",
            "issuing_icao_code",
            "legs",
            "passenger_name_record",
            "passengers",
            "reservation_system",
            "restricted_ticket",
            "ticket_delivery_method",
            "ticket_number",
            "travel_agency_code",
            "travel_agency_invoice_number",
            "travel_agency_name",
            "travel_agency_plan_name",
        ]
        nullable_fields = [
            "booking_code",
            "is_cardholder_traveling",
            "issued_address",
            "issued_at",
            "issuing_carrier_code",
            "issuing_carrier_name",
            "issuing_iata_designator",
            "issuing_icao_code",
            "legs",
            "passenger_name_record",
            "passengers",
            "reservation_system",
            "restricted_ticket",
            "ticket_delivery_method",
            "ticket_number",
            "travel_agency_code",
            "travel_agency_invoice_number",
            "travel_agency_name",
            "travel_agency_plan_name",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
