"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardscheme import CardScheme
from .checkoutsessionpaymentmethoddetails import (
    CheckoutSessionPaymentMethodDetails,
    CheckoutSessionPaymentMethodDetailsTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CheckoutSessionPaymentMethodTypedDict(TypedDict):
    type: Literal["payment-method"]
    r"""Always `payment-method`"""
    id: NotRequired[Nullable[str]]
    r"""The ID of the payment method."""
    details: NotRequired[Nullable[CheckoutSessionPaymentMethodDetailsTypedDict]]
    r"""Details for credit or debit card payment method."""
    label: NotRequired[Nullable[str]]
    r"""The last 4 digits of the the card."""
    method: Literal["card"]
    r"""Always `card`"""
    scheme: NotRequired[Nullable[CardScheme]]
    r"""The scheme of the card."""
    fingerprint: NotRequired[Nullable[str]]
    r"""The unique hash derived from the card number."""


class CheckoutSessionPaymentMethod(BaseModel):
    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-method"]],
            AfterValidator(validate_const("payment-method")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-method"
    r"""Always `payment-method`"""

    id: OptionalNullable[str] = UNSET
    r"""The ID of the payment method."""

    details: OptionalNullable[CheckoutSessionPaymentMethodDetails] = UNSET
    r"""Details for credit or debit card payment method."""

    label: OptionalNullable[str] = UNSET
    r"""The last 4 digits of the the card."""

    METHOD: Annotated[
        Annotated[Optional[Literal["card"]], AfterValidator(validate_const("card"))],
        pydantic.Field(alias="method"),
    ] = "card"
    r"""Always `card`"""

    scheme: Annotated[
        OptionalNullable[CardScheme], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The scheme of the card."""

    fingerprint: OptionalNullable[str] = UNSET
    r"""The unique hash derived from the card number."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "id",
            "details",
            "label",
            "method",
            "scheme",
            "fingerprint",
        ]
        nullable_fields = ["id", "details", "label", "scheme", "fingerprint"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
