"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardtype import CardType
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class CheckoutSessionPaymentMethodDetailsTypedDict(TypedDict):
    bin: NotRequired[Nullable[str]]
    r"""The first 6 digit of the card."""
    card_country: NotRequired[Nullable[str]]
    r"""The country of the card issuer."""
    card_type: NotRequired[Nullable[CardType]]
    r"""The payment scheme of the card."""
    card_issuer_name: NotRequired[Nullable[str]]
    r"""The card issuer."""


class CheckoutSessionPaymentMethodDetails(BaseModel):
    bin: OptionalNullable[str] = UNSET
    r"""The first 6 digit of the card."""

    card_country: OptionalNullable[str] = UNSET
    r"""The country of the card issuer."""

    card_type: Annotated[
        OptionalNullable[CardType], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The payment scheme of the card."""

    card_issuer_name: OptionalNullable[str] = UNSET
    r"""The card issuer."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["bin", "card_country", "card_type", "card_issuer_name"]
        nullable_fields = ["bin", "card_country", "card_type", "card_issuer_name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
