"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class ClickToPayPaymentMethodCreateTypedDict(TypedDict):
    r"""Create a Click to Pay payment with a decrypted token and cryptogram. This
    is mainly used internally but can be used by anyone with their own C2P
    integration.
    """

    token: str
    r"""The device token."""
    cryptogram: str
    r"""The payment cryptogram for the device token."""
    expiration_date: str
    r"""The expiration date of the device token."""
    method: Literal["click-to-pay"]
    r"""Aways `click-to-pay`."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The ID of the buyer to associate this transaction to."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The external identifier of the buyer to create a transaction for."""
    external_identifier: NotRequired[Nullable[str]]
    r"""The external identifier of the payment method to filter by."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL to redirect a user back to after the complete 3DS in browser."""


class ClickToPayPaymentMethodCreate(BaseModel):
    r"""Create a Click to Pay payment with a decrypted token and cryptogram. This
    is mainly used internally but can be used by anyone with their own C2P
    integration.
    """

    token: str
    r"""The device token."""

    cryptogram: str
    r"""The payment cryptogram for the device token."""

    expiration_date: str
    r"""The expiration date of the device token."""

    METHOD: Annotated[
        Annotated[
            Literal["click-to-pay"], AfterValidator(validate_const("click-to-pay"))
        ],
        pydantic.Field(alias="method"),
    ] = "click-to-pay"
    r"""Aways `click-to-pay`."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The ID of the buyer to associate this transaction to."""

    buyer_external_identifier: OptionalNullable[str] = UNSET
    r"""The external identifier of the buyer to create a transaction for."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The external identifier of the payment method to filter by."""

    redirect_url: OptionalNullable[str] = UNSET
    r"""The URL to redirect a user back to after the complete 3DS in browser."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "buyer_id",
            "buyer_external_identifier",
            "external_identifier",
            "redirect_url",
        ]
        nullable_fields = [
            "buyer_id",
            "buyer_external_identifier",
            "external_identifier",
            "redirect_url",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
