"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .digitalwalletprovider import DigitalWalletProvider
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DigitalWalletCreateTypedDict(TypedDict):
    r"""Request body for registering a new digital wallet"""

    provider: DigitalWalletProvider
    merchant_name: str
    accept_terms_and_conditions: bool
    merchant_display_name: NotRequired[Nullable[str]]
    merchant_url: NotRequired[Nullable[str]]
    merchant_country_code: NotRequired[Nullable[str]]
    domain_names: NotRequired[List[str]]


class DigitalWalletCreate(BaseModel):
    r"""Request body for registering a new digital wallet"""

    provider: Annotated[
        DigitalWalletProvider, PlainValidator(validate_open_enum(False))
    ]

    merchant_name: str

    accept_terms_and_conditions: bool

    merchant_display_name: OptionalNullable[str] = UNSET

    merchant_url: OptionalNullable[str] = UNSET

    merchant_country_code: OptionalNullable[str] = UNSET

    domain_names: Optional[List[str]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "merchant_display_name",
            "merchant_url",
            "merchant_country_code",
            "domain_names",
        ]
        nullable_fields = [
            "merchant_display_name",
            "merchant_url",
            "merchant_country_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
