"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .forterantifraudoptionscartitem import (
    ForterAntiFraudOptionsCartItem,
    ForterAntiFraudOptionsCartItemTypedDict,
)
from .forterantifraudoptionsdiscount import (
    ForterAntiFraudOptionsDiscount,
    ForterAntiFraudOptionsDiscountTypedDict,
)
from gr4vy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


ForterAntiFraudOptionsDeliveryType = Union[
    Literal["DIGITAL", "PHYSICAL", "HYBRID"], UnrecognizedStr
]


class ForterAntiFraudOptionsTypedDict(TypedDict):
    delivery_type: NotRequired[Nullable[ForterAntiFraudOptionsDeliveryType]]
    r"""The delivery type"""
    delivery_method: NotRequired[Nullable[str]]
    r"""The delivery method"""
    is_guest_buyer: NotRequired[Nullable[bool]]
    r"""Defines if this payment is made using guest checkout."""
    cart_items: NotRequired[Nullable[List[ForterAntiFraudOptionsCartItemTypedDict]]]
    r"""A list of cart items details to pass to the Forter API."""
    total_discount: NotRequired[Nullable[ForterAntiFraudOptionsDiscountTypedDict]]
    r"""Information about the discount applied to this order."""


class ForterAntiFraudOptions(BaseModel):
    delivery_type: Annotated[
        OptionalNullable[ForterAntiFraudOptionsDeliveryType],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The delivery type"""

    delivery_method: OptionalNullable[str] = UNSET
    r"""The delivery method"""

    is_guest_buyer: OptionalNullable[bool] = UNSET
    r"""Defines if this payment is made using guest checkout."""

    cart_items: OptionalNullable[List[ForterAntiFraudOptionsCartItem]] = UNSET
    r"""A list of cart items details to pass to the Forter API."""

    total_discount: OptionalNullable[ForterAntiFraudOptionsDiscount] = UNSET
    r"""Information about the discount applied to this order."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "delivery_type",
            "delivery_method",
            "is_guest_buyer",
            "cart_items",
            "total_discount",
        ]
        nullable_fields = [
            "delivery_type",
            "delivery_method",
            "is_guest_buyer",
            "cart_items",
            "total_discount",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
