"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardscheme import CardScheme
from .method import Method
from .mode import Mode
from .paymentmethoddetailscard import (
    PaymentMethodDetailsCard,
    PaymentMethodDetailsCardTypedDict,
)
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentMethodSummaryTypedDict(TypedDict):
    r"""Payment Method

    A summary of a payment method.
    """

    method: Method
    id: str
    r"""The ID for the payment method."""
    merchant_account_id: str
    r"""The ID of the merchant account this buyer belongs to."""
    cit_usage_count: int
    r"""The number of times this payment method has been used in transactions for client initiated transactions."""
    has_replacement: bool
    r"""Whether this card has a pending replacement that hasn't been applied yet."""
    usage_count: int
    r"""The number of times this payment method has been used in transactions."""
    type: Literal["payment-method"]
    r"""Always `payment-method`."""
    approval_url: NotRequired[Nullable[str]]
    r"""The optional URL that the buyer needs to be redirected to to further authorize their payment."""
    country: NotRequired[Nullable[str]]
    r"""The 2-letter ISO code of the country this payment method can be used for. If this value is null the payment method may be used in multiple countries."""
    currency: NotRequired[Nullable[str]]
    r"""The ISO-4217 currency code that this payment method can be used for. If this value is null the payment method may be used for multiple currencies."""
    details: NotRequired[Nullable[PaymentMethodDetailsCardTypedDict]]
    r"""Details for credit or debit card payment method."""
    expiration_date: NotRequired[Nullable[str]]
    r"""The expiration date for the payment method."""
    fingerprint: NotRequired[Nullable[str]]
    r"""The unique hash derived from the payment method identifier (e.g. card number)."""
    label: NotRequired[Nullable[str]]
    r"""A label for the card or the account. For a paypal payment method this is the user's email address. For a card it is the last 4 digits of the card."""
    last_replaced_at: NotRequired[Nullable[datetime]]
    r"""The date and time when this card was last replaced by the account updater."""
    mode: NotRequired[Nullable[Mode]]
    r"""The mode to use with this payment method."""
    scheme: NotRequired[Nullable[CardScheme]]
    r"""The scheme of the card. Only applies to card payments."""
    additional_schemes: NotRequired[Nullable[List[CardScheme]]]
    r"""Additional schemes of the card besides the primary scheme. Only applies to card payment methods."""
    cit_last_used_at: NotRequired[Nullable[datetime]]
    r"""The timestamp when this payment method was last used in a transaction for client initiated transactions."""
    last_used_at: NotRequired[Nullable[datetime]]
    r"""The timestamp when this payment method was last used in a transaction."""


class PaymentMethodSummary(BaseModel):
    r"""Payment Method

    A summary of a payment method.
    """

    method: Annotated[Method, PlainValidator(validate_open_enum(False))]

    id: str
    r"""The ID for the payment method."""

    merchant_account_id: str
    r"""The ID of the merchant account this buyer belongs to."""

    cit_usage_count: int
    r"""The number of times this payment method has been used in transactions for client initiated transactions."""

    has_replacement: bool
    r"""Whether this card has a pending replacement that hasn't been applied yet."""

    usage_count: int
    r"""The number of times this payment method has been used in transactions."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-method"]],
            AfterValidator(validate_const("payment-method")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-method"
    r"""Always `payment-method`."""

    approval_url: OptionalNullable[str] = UNSET
    r"""The optional URL that the buyer needs to be redirected to to further authorize their payment."""

    country: OptionalNullable[str] = UNSET
    r"""The 2-letter ISO code of the country this payment method can be used for. If this value is null the payment method may be used in multiple countries."""

    currency: OptionalNullable[str] = UNSET
    r"""The ISO-4217 currency code that this payment method can be used for. If this value is null the payment method may be used for multiple currencies."""

    details: OptionalNullable[PaymentMethodDetailsCard] = UNSET
    r"""Details for credit or debit card payment method."""

    expiration_date: OptionalNullable[str] = UNSET
    r"""The expiration date for the payment method."""

    fingerprint: OptionalNullable[str] = UNSET
    r"""The unique hash derived from the payment method identifier (e.g. card number)."""

    label: OptionalNullable[str] = UNSET
    r"""A label for the card or the account. For a paypal payment method this is the user's email address. For a card it is the last 4 digits of the card."""

    last_replaced_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when this card was last replaced by the account updater."""

    mode: Annotated[
        OptionalNullable[Mode], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The mode to use with this payment method."""

    scheme: Annotated[
        OptionalNullable[CardScheme], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The scheme of the card. Only applies to card payments."""

    additional_schemes: OptionalNullable[
        List[Annotated[CardScheme, PlainValidator(validate_open_enum(False))]]
    ] = UNSET
    r"""Additional schemes of the card besides the primary scheme. Only applies to card payment methods."""

    cit_last_used_at: OptionalNullable[datetime] = UNSET
    r"""The timestamp when this payment method was last used in a transaction for client initiated transactions."""

    last_used_at: OptionalNullable[datetime] = UNSET
    r"""The timestamp when this payment method was last used in a transaction."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "approval_url",
            "country",
            "currency",
            "details",
            "expiration_date",
            "fingerprint",
            "label",
            "last_replaced_at",
            "mode",
            "scheme",
            "additional_schemes",
            "cit_last_used_at",
            "last_used_at",
        ]
        nullable_fields = [
            "approval_url",
            "country",
            "currency",
            "details",
            "expiration_date",
            "fingerprint",
            "label",
            "last_replaced_at",
            "mode",
            "scheme",
            "additional_schemes",
            "cit_last_used_at",
            "last_used_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
