"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from datetime import date
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class RecipientTypedDict(TypedDict):
    r"""Recipient of an account funding transaction"""

    first_name: str
    r"""The first name of the recipient."""
    last_name: str
    r"""The last name of the recipient."""
    address: NotRequired[Nullable[AddressTypedDict]]
    r"""The recipient of the fund's address."""
    account_number: NotRequired[Nullable[str]]
    r"""The account number of the recipient. Depending on the type of funds transfer, this could be a wallet ID, bank accoutn number, or email address."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the recipient."""


class Recipient(BaseModel):
    r"""Recipient of an account funding transaction"""

    first_name: str
    r"""The first name of the recipient."""

    last_name: str
    r"""The last name of the recipient."""

    address: OptionalNullable[Address] = UNSET
    r"""The recipient of the fund's address."""

    account_number: OptionalNullable[str] = UNSET
    r"""The account number of the recipient. Depending on the type of funds transfer, this could be a wallet ID, bank accoutn number, or email address."""

    date_of_birth: OptionalNullable[date] = UNSET
    r"""The date of birth of the recipient."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["address", "account_number", "date_of_birth"]
        nullable_fields = ["address", "account_number", "date_of_birth"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
