"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountsreceivablesreportspec import (
    AccountsReceivablesReportSpec,
    AccountsReceivablesReportSpecTypedDict,
)
from .detailedsettlementreportspec import (
    DetailedSettlementReportSpec,
    DetailedSettlementReportSpecTypedDict,
)
from .reportschedule import ReportSchedule
from .transactionretriesreportspec import (
    TransactionRetriesReportSpec,
    TransactionRetriesReportSpecTypedDict,
)
from .transactionsreportspec import (
    TransactionsReportSpec,
    TransactionsReportSpecTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import get_discriminator, validate_open_enum
from pydantic import Discriminator, Tag, model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


SpecTypedDict = TypeAliasType(
    "SpecTypedDict",
    Union[
        TransactionsReportSpecTypedDict,
        TransactionRetriesReportSpecTypedDict,
        DetailedSettlementReportSpecTypedDict,
        AccountsReceivablesReportSpecTypedDict,
    ],
)
r"""The report specification."""


Spec = Annotated[
    Union[
        Annotated[AccountsReceivablesReportSpec, Tag("accounts_receivables")],
        Annotated[DetailedSettlementReportSpec, Tag("detailed_settlement")],
        Annotated[TransactionRetriesReportSpec, Tag("transaction_retries")],
        Annotated[TransactionsReportSpec, Tag("transactions")],
    ],
    Discriminator(lambda m: get_discriminator(m, "model", "model")),
]
r"""The report specification."""


class ReportCreateTypedDict(TypedDict):
    name: str
    r"""The name of the report."""
    schedule: ReportSchedule
    schedule_enabled: bool
    r"""Whether the report schedule is enabled."""
    spec: SpecTypedDict
    r"""The report specification."""
    description: NotRequired[Nullable[str]]
    r"""A description of the report."""
    schedule_timezone: NotRequired[str]
    r"""The timezone for the report schedule."""


class ReportCreate(BaseModel):
    name: str
    r"""The name of the report."""

    schedule: Annotated[ReportSchedule, PlainValidator(validate_open_enum(False))]

    schedule_enabled: bool
    r"""Whether the report schedule is enabled."""

    spec: Spec
    r"""The report specification."""

    description: OptionalNullable[str] = UNSET
    r"""A description of the report."""

    schedule_timezone: Optional[str] = "Etc/UTC"
    r"""The timezone for the report schedule."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "schedule_timezone"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
