"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .threedsecuredatav1 import ThreeDSecureDataV1, ThreeDSecureDataV1TypedDict
from .threedsecureerror import ThreeDSecureError, ThreeDSecureErrorTypedDict
from .threedsecuremethod import ThreeDSecureMethod
from .threedsecurestatus import ThreeDSecureStatus
from .threedsecurev2 import ThreeDSecureV2, ThreeDSecureV2TypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


ResponseDataTypedDict = TypeAliasType(
    "ResponseDataTypedDict", Union[ThreeDSecureDataV1TypedDict, ThreeDSecureV2TypedDict]
)
r"""The 3DS data sent to the payment service for this transaction. This will only be populated if external 3DS data was passed in directly as part of the transaction API call, or if our 3DS server returned a status code of `Y` or `A`. In case of a failure to authenticate (status `N`, `R`, or `U`) this field will not be populated. To see full details about the 3DS calls please use our transaction events API."""


ResponseData = TypeAliasType("ResponseData", Union[ThreeDSecureDataV1, ThreeDSecureV2])
r"""The 3DS data sent to the payment service for this transaction. This will only be populated if external 3DS data was passed in directly as part of the transaction API call, or if our 3DS server returned a status code of `Y` or `A`. In case of a failure to authenticate (status `N`, `R`, or `U`) this field will not be populated. To see full details about the 3DS calls please use our transaction events API."""


class TransactionThreeDSecureSummaryTypedDict(TypedDict):
    version: NotRequired[Nullable[str]]
    r"""The version of 3DS used for this transaction."""
    status: NotRequired[Nullable[ThreeDSecureStatus]]
    r"""The status of the 3DS challenge for this transaction."""
    method: NotRequired[Nullable[ThreeDSecureMethod]]
    r"""The method used for 3DS authentication for this transaction."""
    response_data: NotRequired[Nullable[ResponseDataTypedDict]]
    r"""The 3DS data sent to the payment service for this transaction. This will only be populated if external 3DS data was passed in directly as part of the transaction API call, or if our 3DS server returned a status code of `Y` or `A`. In case of a failure to authenticate (status `N`, `R`, or `U`) this field will not be populated. To see full details about the 3DS calls please use our transaction events API."""
    error_data: NotRequired[Nullable[ThreeDSecureErrorTypedDict]]
    r"""The error data received from our 3DS server. This will not be populated if the customer failed the authentication with a status code of `N`, `R`, or `U`.  To see full details about the 3DS calls in those situations please use our transaction events API."""


class TransactionThreeDSecureSummary(BaseModel):
    version: OptionalNullable[str] = UNSET
    r"""The version of 3DS used for this transaction."""

    status: Annotated[
        OptionalNullable[ThreeDSecureStatus], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The status of the 3DS challenge for this transaction."""

    method: Annotated[
        OptionalNullable[ThreeDSecureMethod], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The method used for 3DS authentication for this transaction."""

    response_data: OptionalNullable[ResponseData] = UNSET
    r"""The 3DS data sent to the payment service for this transaction. This will only be populated if external 3DS data was passed in directly as part of the transaction API call, or if our 3DS server returned a status code of `Y` or `A`. In case of a failure to authenticate (status `N`, `R`, or `U`) this field will not be populated. To see full details about the 3DS calls please use our transaction events API."""

    error_data: OptionalNullable[ThreeDSecureError] = UNSET
    r"""The error data received from our 3DS server. This will not be populated if the customer failed the authentication with a status code of `N`, `R`, or `U`.  To see full details about the 3DS calls in those situations please use our transaction events API."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["version", "status", "method", "response_data", "error_data"]
        nullable_fields = ["version", "status", "method", "response_data", "error_data"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
