"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Dict
from typing_extensions import Annotated, NotRequired, TypedDict


class WpayEverdaypayOptionsTypedDict(TypedDict):
    merchant_defined_data: NotRequired[Nullable[Dict[str, str]]]
    r"""A dictionary of merchant defined data, to be passed to Wpay for anti-fraud control."""
    customer_id: NotRequired[Nullable[str]]
    r"""The customer ID for the Everyday Rewards account."""
    rewards_access_token: NotRequired[Nullable[str]]
    r"""The access token for the Everyday Rewards account."""
    device_id: NotRequired[Nullable[str]]
    r"""The ID of the device on which the payment is occuring."""
    post_payment_redirect: NotRequired[Nullable[bool]]
    r"""Whether the transaction should redirect post-payment"""


class WpayEverdaypayOptions(BaseModel):
    merchant_defined_data: OptionalNullable[Dict[str, str]] = UNSET
    r"""A dictionary of merchant defined data, to be passed to Wpay for anti-fraud control."""

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""The customer ID for the Everyday Rewards account."""

    rewards_access_token: Annotated[
        OptionalNullable[str], pydantic.Field(alias="rewardsAccessToken")
    ] = UNSET
    r"""The access token for the Everyday Rewards account."""

    device_id: Annotated[OptionalNullable[str], pydantic.Field(alias="deviceId")] = (
        UNSET
    )
    r"""The ID of the device on which the payment is occuring."""

    post_payment_redirect: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postPaymentRedirect")
    ] = UNSET
    r"""Whether the transaction should redirect post-payment"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "merchant_defined_data",
            "customerId",
            "rewardsAccessToken",
            "deviceId",
            "postPaymentRedirect",
        ]
        nullable_fields = [
            "merchant_defined_data",
            "customerId",
            "rewardsAccessToken",
            "deviceId",
            "postPaymentRedirect",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
