# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.collection import Collection
from ..types.legacy_search_response import LegacySearchResponse
from ..types.response_type import ResponseType
from ..types.source_connection_job import SourceConnectionJob
from .raw_client import AsyncRawCollectionsClient, RawCollectionsClient
from .types.search_collections_readable_id_search_post_request import SearchCollectionsReadableIdSearchPostRequest
from .types.search_collections_readable_id_search_post_response import SearchCollectionsReadableIdSearchPostResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CollectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCollectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCollectionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        skip: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Collection]:
        """
        List all collections that belong to your organization.

        Parameters
        ----------
        skip : typing.Optional[int]
            Number of collections to skip for pagination

        limit : typing.Optional[int]
            Maximum number of collections to return (1-1000)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Collection]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.collections.list(
            skip=1,
            limit=1,
        )
        """
        _response = self._raw_client.list(skip=skip, limit=limit, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        readable_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Create a new collection.

        The newly created collection is initially empty and does not contain any data
        until you explicitly add source connections to it.

        Parameters
        ----------
        name : str
            Human-readable display name for the collection. This appears in the UI and should clearly describe the data contained within (e.g., 'Finance Data').

        readable_id : typing.Optional[str]
            URL-safe unique identifier used in API endpoints. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the collection name with a random suffix for uniqueness (e.g., 'finance-data-ab123').

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.collections.create(
            name="Finance Data",
            readable_id="finance-data-reports",
        )
        """
        _response = self._raw_client.create(name=name, readable_id=readable_id, request_options=request_options)
        return _response.data

    def get(self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        Retrieve a specific collection by its readable ID.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection (e.g., 'finance-data-ab123')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.collections.get(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.get(readable_id, request_options=request_options)
        return _response.data

    def delete(self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        Delete a collection and all associated data.

        Permanently removes a collection from your organization including all synced data
        from the destination systems. All source connections within this collection
        will also be deleted as part of the cleanup process. This action cannot be undone.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.collections.delete(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.delete(readable_id, request_options=request_options)
        return _response.data

    def refresh_all_source_connections(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SourceConnectionJob]:
        """
        Trigger data synchronization for all source connections in the collection.

        The sync jobs run asynchronously in the background, so this endpoint
        returns immediately with job details that you can use to track progress. You can
        monitor the status of individual data synchronization using the source connection
        endpoints.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to refresh

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionJob]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.collections.refresh_all_source_connections(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.refresh_all_source_connections(readable_id, request_options=request_options)
        return _response.data

    def search_get_legacy(
        self,
        readable_id: str,
        *,
        query: str,
        response_type: typing.Optional[ResponseType] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        recency_bias: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LegacySearchResponse:
        """
        Legacy GET search endpoint for backwards compatibility.

        DEPRECATED: This endpoint uses the old schema. Please migrate to POST with the new
        SearchRequest format for access to all features.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text to find relevant documents and data

        response_type : typing.Optional[ResponseType]
            Format of the response: 'raw' returns search results, 'completion' returns AI-generated answers

        limit : typing.Optional[int]
            Maximum number of results to return

        offset : typing.Optional[int]
            Number of results to skip for pagination

        recency_bias : typing.Optional[float]
            How much to weigh recency vs similarity (0..1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LegacySearchResponse
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.collections.search_get_legacy(
            readable_id="readable_id",
            query="query",
            response_type="raw",
            limit=1,
            offset=1,
            recency_bias=1.1,
        )
        """
        _response = self._raw_client.search_get_legacy(
            readable_id,
            query=query,
            response_type=response_type,
            limit=limit,
            offset=offset,
            recency_bias=recency_bias,
            request_options=request_options,
        )
        return _response.data

    def search(
        self,
        readable_id: str,
        *,
        request: SearchCollectionsReadableIdSearchPostRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchCollectionsReadableIdSearchPostResponse:
        """
        Search your collection.

        Accepts both new SearchRequest and legacy LegacySearchRequest formats
        for backwards compatibility.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection

        request : SearchCollectionsReadableIdSearchPostRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchCollectionsReadableIdSearchPostResponse
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK, SearchRequest

        client = AirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.collections.search(
            readable_id="readable_id",
            request=SearchRequest(
                query="query",
            ),
        )
        """
        _response = self._raw_client.search(readable_id, request=request, request_options=request_options)
        return _response.data


class AsyncCollectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCollectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCollectionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        skip: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Collection]:
        """
        List all collections that belong to your organization.

        Parameters
        ----------
        skip : typing.Optional[int]
            Number of collections to skip for pagination

        limit : typing.Optional[int]
            Maximum number of collections to return (1-1000)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Collection]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.list(
                skip=1,
                limit=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(skip=skip, limit=limit, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        readable_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Create a new collection.

        The newly created collection is initially empty and does not contain any data
        until you explicitly add source connections to it.

        Parameters
        ----------
        name : str
            Human-readable display name for the collection. This appears in the UI and should clearly describe the data contained within (e.g., 'Finance Data').

        readable_id : typing.Optional[str]
            URL-safe unique identifier used in API endpoints. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the collection name with a random suffix for uniqueness (e.g., 'finance-data-ab123').

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.create(
                name="Finance Data",
                readable_id="finance-data-reports",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, readable_id=readable_id, request_options=request_options)
        return _response.data

    async def get(self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        Retrieve a specific collection by its readable ID.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection (e.g., 'finance-data-ab123')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.get(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(readable_id, request_options=request_options)
        return _response.data

    async def delete(self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        Delete a collection and all associated data.

        Permanently removes a collection from your organization including all synced data
        from the destination systems. All source connections within this collection
        will also be deleted as part of the cleanup process. This action cannot be undone.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.delete(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(readable_id, request_options=request_options)
        return _response.data

    async def refresh_all_source_connections(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SourceConnectionJob]:
        """
        Trigger data synchronization for all source connections in the collection.

        The sync jobs run asynchronously in the background, so this endpoint
        returns immediately with job details that you can use to track progress. You can
        monitor the status of individual data synchronization using the source connection
        endpoints.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to refresh

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionJob]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.refresh_all_source_connections(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.refresh_all_source_connections(readable_id, request_options=request_options)
        return _response.data

    async def search_get_legacy(
        self,
        readable_id: str,
        *,
        query: str,
        response_type: typing.Optional[ResponseType] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        recency_bias: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LegacySearchResponse:
        """
        Legacy GET search endpoint for backwards compatibility.

        DEPRECATED: This endpoint uses the old schema. Please migrate to POST with the new
        SearchRequest format for access to all features.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text to find relevant documents and data

        response_type : typing.Optional[ResponseType]
            Format of the response: 'raw' returns search results, 'completion' returns AI-generated answers

        limit : typing.Optional[int]
            Maximum number of results to return

        offset : typing.Optional[int]
            Number of results to skip for pagination

        recency_bias : typing.Optional[float]
            How much to weigh recency vs similarity (0..1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LegacySearchResponse
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.search_get_legacy(
                readable_id="readable_id",
                query="query",
                response_type="raw",
                limit=1,
                offset=1,
                recency_bias=1.1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_get_legacy(
            readable_id,
            query=query,
            response_type=response_type,
            limit=limit,
            offset=offset,
            recency_bias=recency_bias,
            request_options=request_options,
        )
        return _response.data

    async def search(
        self,
        readable_id: str,
        *,
        request: SearchCollectionsReadableIdSearchPostRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchCollectionsReadableIdSearchPostResponse:
        """
        Search your collection.

        Accepts both new SearchRequest and legacy LegacySearchRequest formats
        for backwards compatibility.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection

        request : SearchCollectionsReadableIdSearchPostRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchCollectionsReadableIdSearchPostResponse
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK, SearchRequest

        client = AsyncAirweaveSDK(
            framework_name="YOUR_FRAMEWORK_NAME",
            framework_version="YOUR_FRAMEWORK_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.search(
                readable_id="readable_id",
                request=SearchRequest(
                    query="query",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search(readable_id, request=request, request_options=request_options)
        return _response.data
