# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .node_type import NodeType


class DagNode(UniversalBaseModel):
    """
    Schema for a DAG node.
    """

    type: NodeType
    name: str
    config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    connection_id: typing.Optional[str] = None
    entity_definition_id: typing.Optional[str] = None
    transformer_id: typing.Optional[str] = None
    id: str
    dag_id: str
    organization_id: str
    created_by_email: typing.Optional[str] = None
    modified_by_email: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
