# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .feature_flag import FeatureFlag


class OrganizationMetrics(UniversalBaseModel):
    """
    Comprehensive organization metrics for admin dashboard.

    Combines organization info with billing and usage metrics from the Usage model.
    """

    id: str = pydantic.Field()
    """
    Organization ID
    """

    name: str = pydantic.Field()
    """
    Organization name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization description
    """

    created_at: dt.datetime = pydantic.Field()
    """
    When organization was created
    """

    modified_at: dt.datetime = pydantic.Field()
    """
    Last modification time
    """

    auth_0_org_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="auth0_org_id")] = (
        pydantic.Field(default=None)
    )
    """
    Auth0 organization ID
    """

    billing_plan: typing.Optional[str] = pydantic.Field(default=None)
    """
    Current billing plan (trial, starter, pro, enterprise)
    """

    billing_status: typing.Optional[str] = pydantic.Field(default=None)
    """
    Billing status (active, cancelled, past_due, etc.)
    """

    stripe_customer_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Stripe customer ID
    """

    trial_ends_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When trial ends
    """

    user_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of users in organization
    """

    source_connection_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of source connections (from Usage.source_connections)
    """

    entity_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of entities (from Usage.entities)
    """

    query_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of queries (from Usage.queries)
    """

    last_active_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Last active timestamp of any user in this organization
    """

    is_member: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the current admin user is already a member
    """

    member_role: typing.Optional[str] = pydantic.Field(default=None)
    """
    Admin's role in this organization (if member)
    """

    enabled_features: typing.Optional[typing.List[FeatureFlag]] = pydantic.Field(default=None)
    """
    List of enabled feature flags for this organization
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
