# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class S3ConfigRequest(UniversalBaseModel):
    """
    Request to configure S3 destination.
    """

    aws_access_key_id: str = pydantic.Field()
    """
    AWS access key ID
    """

    aws_secret_access_key: str = pydantic.Field()
    """
    AWS secret access key
    """

    bucket_name: str = pydantic.Field()
    """
    S3 bucket name
    """

    bucket_prefix: typing.Optional[str] = pydantic.Field(default=None)
    """
    Prefix for Airweave data
    """

    aws_region: typing.Optional[str] = pydantic.Field(default=None)
    """
    AWS region
    """

    endpoint_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Custom S3 endpoint
    """

    use_ssl: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Use SSL/TLS
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
