# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connection import Connection
from .sync_status import SyncStatus


class SyncWithSourceConnection(UniversalBaseModel):
    """
    Schema for Sync with source connection.
    """

    name: str
    source_connection_id: str
    embedding_model_connection_id: typing.Optional[str] = None
    destination_connection_ids: typing.List[str]
    description: typing.Optional[str] = None
    cron_schedule: typing.Optional[str] = None
    next_scheduled_run: typing.Optional[dt.datetime] = None
    temporal_schedule_id: typing.Optional[str] = None
    sync_type: typing.Optional[str] = None
    sync_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    status: SyncStatus
    id: str
    organization_id: str
    created_at: dt.datetime
    modified_at: dt.datetime
    created_by_email: typing.Optional[str] = None
    modified_by_email: typing.Optional[str] = None
    source_connection: typing.Optional[Connection] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
