# coding: utf-8

"""
AskUI Workspaces API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.30
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from typing import Any, Dict, List, Optional, Tuple, Union

from pydantic import (
    Field,
    StrictBytes,
    StrictFloat,
    StrictInt,
    StrictStr,
    validate_call,
)
from typing_extensions import Annotated

from askui.tools.askui.askui_workspaces.api_client import ApiClient, RequestSerialized
from askui.tools.askui.askui_workspaces.api_response import ApiResponse
from askui.tools.askui.askui_workspaces.models.agent_execution import AgentExecution
from askui.tools.askui.askui_workspaces.models.agent_execution_update_command import (
    AgentExecutionUpdateCommand,
)
from askui.tools.askui.askui_workspaces.models.agent_executions_list_response import (
    AgentExecutionsListResponse,
)
from askui.tools.askui.askui_workspaces.rest import RESTResponseType


class AgentExecutionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_agent_execution_api_v1_agent_executions_post(
        self,
        agent_id: StrictStr,
        input_files: Annotated[
            List[Union[StrictBytes, StrictStr]],
            Field(
                min_length=1,
                description="Files to extract data from. Supported file extensions: {'.gif', '.eml', '.webp', '.png', '.jpeg', '.pdf', '.jpg', '.txt'}. Maximum total size: 100 MiB. We process the .eml files as text files, i.e., we don't process non-textual attachments and content properly. For that, extract them from the .eml files separating them into different files.",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AgentExecution:
        """Create Agent Execution


        :param agent_id: (required)
        :type agent_id: str
        :param input_files: Files to extract data from. Supported file extensions: {'.gif', '.eml', '.webp', '.png', '.jpeg', '.pdf', '.jpg', '.txt'}. Maximum total size: 100 MiB. We process the .eml files as text files, i.e., we don't process non-textual attachments and content properly. For that, extract them from the .eml files separating them into different files. (required)
        :type input_files: List[bytearray]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_agent_execution_api_v1_agent_executions_post_serialize(
            agent_id=agent_id,
            input_files=input_files,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "AgentExecution",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_agent_execution_api_v1_agent_executions_post_with_http_info(
        self,
        agent_id: StrictStr,
        input_files: Annotated[
            List[Union[StrictBytes, StrictStr]],
            Field(
                min_length=1,
                description="Files to extract data from. Supported file extensions: {'.gif', '.eml', '.webp', '.png', '.jpeg', '.pdf', '.jpg', '.txt'}. Maximum total size: 100 MiB. We process the .eml files as text files, i.e., we don't process non-textual attachments and content properly. For that, extract them from the .eml files separating them into different files.",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AgentExecution]:
        """Create Agent Execution


        :param agent_id: (required)
        :type agent_id: str
        :param input_files: Files to extract data from. Supported file extensions: {'.gif', '.eml', '.webp', '.png', '.jpeg', '.pdf', '.jpg', '.txt'}. Maximum total size: 100 MiB. We process the .eml files as text files, i.e., we don't process non-textual attachments and content properly. For that, extract them from the .eml files separating them into different files. (required)
        :type input_files: List[bytearray]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_agent_execution_api_v1_agent_executions_post_serialize(
            agent_id=agent_id,
            input_files=input_files,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "AgentExecution",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_agent_execution_api_v1_agent_executions_post_without_preload_content(
        self,
        agent_id: StrictStr,
        input_files: Annotated[
            List[Union[StrictBytes, StrictStr]],
            Field(
                min_length=1,
                description="Files to extract data from. Supported file extensions: {'.gif', '.eml', '.webp', '.png', '.jpeg', '.pdf', '.jpg', '.txt'}. Maximum total size: 100 MiB. We process the .eml files as text files, i.e., we don't process non-textual attachments and content properly. For that, extract them from the .eml files separating them into different files.",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Agent Execution


        :param agent_id: (required)
        :type agent_id: str
        :param input_files: Files to extract data from. Supported file extensions: {'.gif', '.eml', '.webp', '.png', '.jpeg', '.pdf', '.jpg', '.txt'}. Maximum total size: 100 MiB. We process the .eml files as text files, i.e., we don't process non-textual attachments and content properly. For that, extract them from the .eml files separating them into different files. (required)
        :type input_files: List[bytearray]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_agent_execution_api_v1_agent_executions_post_serialize(
            agent_id=agent_id,
            input_files=input_files,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "AgentExecution",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _create_agent_execution_api_v1_agent_executions_post_serialize(
        self,
        agent_id,
        input_files,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {
            "input_files": "csv",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if agent_id is not None:
            _query_params.append(("agent_id", agent_id))

        # process the header parameters
        # process the form parameters
        if input_files is not None:
            _files["input_files"] = input_files
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["multipart/form-data"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["Basic", "Bearer"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/v1/agent-executions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_agent_executions_api_v1_agent_executions_get(
        self,
        agent_execution_id: Optional[List[StrictStr]] = None,
        agent_id: Optional[List[StrictStr]] = None,
        workspace_id: Optional[List[StrictStr]] = None,
        status: Optional[List[StrictStr]] = None,
        skip: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        expand: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="total_count: Include the total number of agent executions that match the query, only accurate up to 100."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AgentExecutionsListResponse:
        """List Agent Executions

        List all agent executions matching the query parameters sorted anti-chronologically by when they were last updated (`updated_at`).

        :param agent_execution_id:
        :type agent_execution_id: List[str]
        :param agent_id:
        :type agent_id: List[str]
        :param workspace_id:
        :type workspace_id: List[str]
        :param status:
        :type status: List[str]
        :param skip:
        :type skip: int
        :param limit:
        :type limit: int
        :param expand: total_count: Include the total number of agent executions that match the query, only accurate up to 100.
        :type expand: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_agent_executions_api_v1_agent_executions_get_serialize(
            agent_execution_id=agent_execution_id,
            agent_id=agent_id,
            workspace_id=workspace_id,
            status=status,
            skip=skip,
            limit=limit,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "AgentExecutionsListResponse",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_agent_executions_api_v1_agent_executions_get_with_http_info(
        self,
        agent_execution_id: Optional[List[StrictStr]] = None,
        agent_id: Optional[List[StrictStr]] = None,
        workspace_id: Optional[List[StrictStr]] = None,
        status: Optional[List[StrictStr]] = None,
        skip: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        expand: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="total_count: Include the total number of agent executions that match the query, only accurate up to 100."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AgentExecutionsListResponse]:
        """List Agent Executions

        List all agent executions matching the query parameters sorted anti-chronologically by when they were last updated (`updated_at`).

        :param agent_execution_id:
        :type agent_execution_id: List[str]
        :param agent_id:
        :type agent_id: List[str]
        :param workspace_id:
        :type workspace_id: List[str]
        :param status:
        :type status: List[str]
        :param skip:
        :type skip: int
        :param limit:
        :type limit: int
        :param expand: total_count: Include the total number of agent executions that match the query, only accurate up to 100.
        :type expand: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_agent_executions_api_v1_agent_executions_get_serialize(
            agent_execution_id=agent_execution_id,
            agent_id=agent_id,
            workspace_id=workspace_id,
            status=status,
            skip=skip,
            limit=limit,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "AgentExecutionsListResponse",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_agent_executions_api_v1_agent_executions_get_without_preload_content(
        self,
        agent_execution_id: Optional[List[StrictStr]] = None,
        agent_id: Optional[List[StrictStr]] = None,
        workspace_id: Optional[List[StrictStr]] = None,
        status: Optional[List[StrictStr]] = None,
        skip: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        expand: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="total_count: Include the total number of agent executions that match the query, only accurate up to 100."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Agent Executions

        List all agent executions matching the query parameters sorted anti-chronologically by when they were last updated (`updated_at`).

        :param agent_execution_id:
        :type agent_execution_id: List[str]
        :param agent_id:
        :type agent_id: List[str]
        :param workspace_id:
        :type workspace_id: List[str]
        :param status:
        :type status: List[str]
        :param skip:
        :type skip: int
        :param limit:
        :type limit: int
        :param expand: total_count: Include the total number of agent executions that match the query, only accurate up to 100.
        :type expand: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_agent_executions_api_v1_agent_executions_get_serialize(
            agent_execution_id=agent_execution_id,
            agent_id=agent_id,
            workspace_id=workspace_id,
            status=status,
            skip=skip,
            limit=limit,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "AgentExecutionsListResponse",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _list_agent_executions_api_v1_agent_executions_get_serialize(
        self,
        agent_execution_id,
        agent_id,
        workspace_id,
        status,
        skip,
        limit,
        expand,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {
            "agent_execution_id": "multi",
            "agent_id": "multi",
            "workspace_id": "multi",
            "status": "multi",
            "expand": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if agent_execution_id is not None:
            _query_params.append(("agent_execution_id", agent_execution_id))

        if agent_id is not None:
            _query_params.append(("agent_id", agent_id))

        if workspace_id is not None:
            _query_params.append(("workspace_id", workspace_id))

        if status is not None:
            _query_params.append(("status", status))

        if skip is not None:
            _query_params.append(("skip", skip))

        if limit is not None:
            _query_params.append(("limit", limit))

        if expand is not None:
            _query_params.append(("expand", expand))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: List[str] = ["Basic", "Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/v1/agent-executions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_agent_execution_api_v1_agent_executions_agent_execution_id_patch(
        self,
        agent_execution_id: StrictStr,
        agent_execution_update_command: AgentExecutionUpdateCommand,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AgentExecution:
        """Update Agent Execution


        :param agent_execution_id: (required)
        :type agent_execution_id: str
        :param agent_execution_update_command: (required)
        :type agent_execution_update_command: AgentExecutionUpdateCommand
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_agent_execution_api_v1_agent_executions_agent_execution_id_patch_serialize(
            agent_execution_id=agent_execution_id,
            agent_execution_update_command=agent_execution_update_command,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "AgentExecution",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_agent_execution_api_v1_agent_executions_agent_execution_id_patch_with_http_info(
        self,
        agent_execution_id: StrictStr,
        agent_execution_update_command: AgentExecutionUpdateCommand,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AgentExecution]:
        """Update Agent Execution


        :param agent_execution_id: (required)
        :type agent_execution_id: str
        :param agent_execution_update_command: (required)
        :type agent_execution_update_command: AgentExecutionUpdateCommand
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_agent_execution_api_v1_agent_executions_agent_execution_id_patch_serialize(
            agent_execution_id=agent_execution_id,
            agent_execution_update_command=agent_execution_update_command,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "AgentExecution",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_agent_execution_api_v1_agent_executions_agent_execution_id_patch_without_preload_content(
        self,
        agent_execution_id: StrictStr,
        agent_execution_update_command: AgentExecutionUpdateCommand,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Agent Execution


        :param agent_execution_id: (required)
        :type agent_execution_id: str
        :param agent_execution_update_command: (required)
        :type agent_execution_update_command: AgentExecutionUpdateCommand
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_agent_execution_api_v1_agent_executions_agent_execution_id_patch_serialize(
            agent_execution_id=agent_execution_id,
            agent_execution_update_command=agent_execution_update_command,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "AgentExecution",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_agent_execution_api_v1_agent_executions_agent_execution_id_patch_serialize(
        self,
        agent_execution_id,
        agent_execution_update_command,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_execution_id is not None:
            _path_params["agent_execution_id"] = agent_execution_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if agent_execution_update_command is not None:
            _body_params = agent_execution_update_command

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["Basic", "Bearer"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/api/v1/agent-executions/{agent_execution_id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
