# coding: utf-8

"""
AskUI Workspaces API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.30
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from datetime import datetime
from typing import Any, Dict, List, Optional, Tuple, Union

from pydantic import Field, StrictFloat, StrictInt, StrictStr, validate_call
from typing_extensions import Annotated

from askui.tools.askui.askui_workspaces.api_client import ApiClient, RequestSerialized
from askui.tools.askui.askui_workspaces.api_response import ApiResponse
from askui.tools.askui.askui_workspaces.models.usage_events_list_response import (
    UsageEventsListResponse,
)
from askui.tools.askui.askui_workspaces.rest import RESTResponseType


class UsageApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def list_usage_events_api_v1_usage_events_get(
        self,
        workspace_id: Annotated[
            Optional[List[StrictStr]], Field(description="Filter by workspace IDs")
        ] = None,
        user_id: Annotated[
            Optional[List[StrictStr]], Field(description="Filter by user IDs")
        ] = None,
        access_token_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Filter events by access token IDs  **IMPORTANT**: This is not the same as the access token used in the authorization header of the request as this would be insecure but the id of the token. The id can be look up using the access token lookup endpoint."
            ),
        ] = None,
        start_time: Annotated[
            Optional[datetime],
            Field(
                description="Include events starting from this time (inclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`"
            ),
        ] = None,
        end_time: Annotated[
            Optional[datetime],
            Field(
                description="Include events until this time (exclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`"
            ),
        ] = None,
        starting_after: Annotated[
            Optional[StrictStr],
            Field(
                description="Return events after this event ID; to be used for pagination, won't change the `total_count`"
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(
                description="Maximum number of events to return (in the response). The lower the faster the response time (less memory consumption or bandwidth)."
            ),
        ] = None,
        expand: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Include additional fields in the response.  - The total count represents all the number of events that match the query, not only the ones returned in the response, but is only accurate up to 100000 events."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UsageEventsListResponse:
        """List Usage Events

        List usage events sorted chronologically by timestamp. Events can be filtered by workspace, user, or access token.  Filter combinations: - Multiple filters (e.g. workspace_id & user_id) use AND logic - Multiple values for same filter (e.g. workspace_id=123&workspace_id=456) use OR logic  Pagination: - Use starting_after with event IDs for cursor-based navigation - has_more indicates if more events exist beyond limit - total_count (optional) shows total matching events up to 100,000

        :param workspace_id: Filter by workspace IDs
        :type workspace_id: List[str]
        :param user_id: Filter by user IDs
        :type user_id: List[str]
        :param access_token_id: Filter events by access token IDs  **IMPORTANT**: This is not the same as the access token used in the authorization header of the request as this would be insecure but the id of the token. The id can be look up using the access token lookup endpoint.
        :type access_token_id: List[str]
        :param start_time: Include events starting from this time (inclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`
        :type start_time: datetime
        :param end_time: Include events until this time (exclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`
        :type end_time: datetime
        :param starting_after: Return events after this event ID; to be used for pagination, won't change the `total_count`
        :type starting_after: str
        :param limit: Maximum number of events to return (in the response). The lower the faster the response time (less memory consumption or bandwidth).
        :type limit: int
        :param expand: Include additional fields in the response.  - The total count represents all the number of events that match the query, not only the ones returned in the response, but is only accurate up to 100000 events.
        :type expand: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_usage_events_api_v1_usage_events_get_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            access_token_id=access_token_id,
            start_time=start_time,
            end_time=end_time,
            starting_after=starting_after,
            limit=limit,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "UsageEventsListResponse",
            "401": "StringErrorResponse",
            "403": "StringErrorResponse",
            "500": "StringErrorResponse",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_usage_events_api_v1_usage_events_get_with_http_info(
        self,
        workspace_id: Annotated[
            Optional[List[StrictStr]], Field(description="Filter by workspace IDs")
        ] = None,
        user_id: Annotated[
            Optional[List[StrictStr]], Field(description="Filter by user IDs")
        ] = None,
        access_token_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Filter events by access token IDs  **IMPORTANT**: This is not the same as the access token used in the authorization header of the request as this would be insecure but the id of the token. The id can be look up using the access token lookup endpoint."
            ),
        ] = None,
        start_time: Annotated[
            Optional[datetime],
            Field(
                description="Include events starting from this time (inclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`"
            ),
        ] = None,
        end_time: Annotated[
            Optional[datetime],
            Field(
                description="Include events until this time (exclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`"
            ),
        ] = None,
        starting_after: Annotated[
            Optional[StrictStr],
            Field(
                description="Return events after this event ID; to be used for pagination, won't change the `total_count`"
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(
                description="Maximum number of events to return (in the response). The lower the faster the response time (less memory consumption or bandwidth)."
            ),
        ] = None,
        expand: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Include additional fields in the response.  - The total count represents all the number of events that match the query, not only the ones returned in the response, but is only accurate up to 100000 events."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UsageEventsListResponse]:
        """List Usage Events

        List usage events sorted chronologically by timestamp. Events can be filtered by workspace, user, or access token.  Filter combinations: - Multiple filters (e.g. workspace_id & user_id) use AND logic - Multiple values for same filter (e.g. workspace_id=123&workspace_id=456) use OR logic  Pagination: - Use starting_after with event IDs for cursor-based navigation - has_more indicates if more events exist beyond limit - total_count (optional) shows total matching events up to 100,000

        :param workspace_id: Filter by workspace IDs
        :type workspace_id: List[str]
        :param user_id: Filter by user IDs
        :type user_id: List[str]
        :param access_token_id: Filter events by access token IDs  **IMPORTANT**: This is not the same as the access token used in the authorization header of the request as this would be insecure but the id of the token. The id can be look up using the access token lookup endpoint.
        :type access_token_id: List[str]
        :param start_time: Include events starting from this time (inclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`
        :type start_time: datetime
        :param end_time: Include events until this time (exclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`
        :type end_time: datetime
        :param starting_after: Return events after this event ID; to be used for pagination, won't change the `total_count`
        :type starting_after: str
        :param limit: Maximum number of events to return (in the response). The lower the faster the response time (less memory consumption or bandwidth).
        :type limit: int
        :param expand: Include additional fields in the response.  - The total count represents all the number of events that match the query, not only the ones returned in the response, but is only accurate up to 100000 events.
        :type expand: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_usage_events_api_v1_usage_events_get_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            access_token_id=access_token_id,
            start_time=start_time,
            end_time=end_time,
            starting_after=starting_after,
            limit=limit,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "UsageEventsListResponse",
            "401": "StringErrorResponse",
            "403": "StringErrorResponse",
            "500": "StringErrorResponse",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_usage_events_api_v1_usage_events_get_without_preload_content(
        self,
        workspace_id: Annotated[
            Optional[List[StrictStr]], Field(description="Filter by workspace IDs")
        ] = None,
        user_id: Annotated[
            Optional[List[StrictStr]], Field(description="Filter by user IDs")
        ] = None,
        access_token_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Filter events by access token IDs  **IMPORTANT**: This is not the same as the access token used in the authorization header of the request as this would be insecure but the id of the token. The id can be look up using the access token lookup endpoint."
            ),
        ] = None,
        start_time: Annotated[
            Optional[datetime],
            Field(
                description="Include events starting from this time (inclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`"
            ),
        ] = None,
        end_time: Annotated[
            Optional[datetime],
            Field(
                description="Include events until this time (exclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`"
            ),
        ] = None,
        starting_after: Annotated[
            Optional[StrictStr],
            Field(
                description="Return events after this event ID; to be used for pagination, won't change the `total_count`"
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(
                description="Maximum number of events to return (in the response). The lower the faster the response time (less memory consumption or bandwidth)."
            ),
        ] = None,
        expand: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Include additional fields in the response.  - The total count represents all the number of events that match the query, not only the ones returned in the response, but is only accurate up to 100000 events."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Usage Events

        List usage events sorted chronologically by timestamp. Events can be filtered by workspace, user, or access token.  Filter combinations: - Multiple filters (e.g. workspace_id & user_id) use AND logic - Multiple values for same filter (e.g. workspace_id=123&workspace_id=456) use OR logic  Pagination: - Use starting_after with event IDs for cursor-based navigation - has_more indicates if more events exist beyond limit - total_count (optional) shows total matching events up to 100,000

        :param workspace_id: Filter by workspace IDs
        :type workspace_id: List[str]
        :param user_id: Filter by user IDs
        :type user_id: List[str]
        :param access_token_id: Filter events by access token IDs  **IMPORTANT**: This is not the same as the access token used in the authorization header of the request as this would be insecure but the id of the token. The id can be look up using the access token lookup endpoint.
        :type access_token_id: List[str]
        :param start_time: Include events starting from this time (inclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`
        :type start_time: datetime
        :param end_time: Include events until this time (exclusive).  Format: Unix timestamp, e.g., `1717689600`, or ISO 8601 with timezone, e.g., `2024-06-06T16:00:00Z`
        :type end_time: datetime
        :param starting_after: Return events after this event ID; to be used for pagination, won't change the `total_count`
        :type starting_after: str
        :param limit: Maximum number of events to return (in the response). The lower the faster the response time (less memory consumption or bandwidth).
        :type limit: int
        :param expand: Include additional fields in the response.  - The total count represents all the number of events that match the query, not only the ones returned in the response, but is only accurate up to 100000 events.
        :type expand: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_usage_events_api_v1_usage_events_get_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            access_token_id=access_token_id,
            start_time=start_time,
            end_time=end_time,
            starting_after=starting_after,
            limit=limit,
            expand=expand,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "UsageEventsListResponse",
            "401": "StringErrorResponse",
            "403": "StringErrorResponse",
            "500": "StringErrorResponse",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _list_usage_events_api_v1_usage_events_get_serialize(
        self,
        workspace_id,
        user_id,
        access_token_id,
        start_time,
        end_time,
        starting_after,
        limit,
        expand,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {
            "workspace_id": "multi",
            "user_id": "multi",
            "access_token_id": "multi",
            "expand": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if workspace_id is not None:
            _query_params.append(("workspace_id", workspace_id))

        if user_id is not None:
            _query_params.append(("user_id", user_id))

        if access_token_id is not None:
            _query_params.append(("access_token_id", access_token_id))

        if start_time is not None:
            if isinstance(start_time, datetime):
                _query_params.append(
                    (
                        "start_time",
                        start_time.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("start_time", start_time))

        if end_time is not None:
            if isinstance(end_time, datetime):
                _query_params.append(
                    (
                        "end_time",
                        end_time.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("end_time", end_time))

        if starting_after is not None:
            _query_params.append(("starting_after", starting_after))

        if limit is not None:
            _query_params.append(("limit", limit))

        if expand is not None:
            _query_params.append(("expand", expand))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: List[str] = ["Basic", "Bearer"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/v1/usage/events",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
