# coding: utf-8

"""
AskUI Workspaces API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.30
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictStr,
    field_validator,
)
from typing_extensions import Annotated, Self


class EmailAgentTrigger(BaseModel):
    """
    EmailAgentTrigger
    """  # noqa: E501

    active: Optional[StrictBool] = Field(
        default=True, description="If false, no emails can be send to trigger agent."
    )
    allowed_senders: Optional[List[StrictStr]] = Field(
        default=None,
        description="The email addresses that are allowed to send emails to trigger the agent. If empty, no emails can be send to trigger agent.",
        alias="allowedSenders",
    )
    email: Annotated[str, Field(strict=True)] = Field(
        description="The email address of the agent to send emails to to trigger the agent. The email address must be unique for each agent. The domain of the email address is fixed. The local part of the email address must be between 1 and 64 characters long and can only contain the following characters: a-z, A-Z, 0-9, -, _, . and +."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["active", "allowedSenders", "email"]

    @field_validator("email")
    def email_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9-_.+]+@.*$", value):
            raise ValueError(
                r"must validate the regular expression /^[a-zA-Z0-9-_.+]+@.*$/"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailAgentTrigger from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailAgentTrigger from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "active": obj.get("active") if obj.get("active") is not None else True,
                "allowedSenders": obj.get("allowedSenders"),
                "email": obj.get("email"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
