# Generated by ariadne-codegen
# Source: ../graphql

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    DeviceExecutionStateEnum,
    ExecutionResultStateEnum,
    ExecutionStateEnum,
    ExecutionTypeEnum,
    ProviderTypeEnum,
    RunOnEnum,
)


class Execution(BaseModel):
    executions: Optional["ExecutionExecutions"]


class ExecutionExecutions(BaseModel):
    results: Optional[List[Optional["ExecutionExecutionsResults"]]]


class ExecutionExecutionsResults(BaseModel):
    id: str
    task_id: Optional[str] = Field(alias="taskId")
    name: Optional[str]
    execution_type: Optional[ExecutionTypeEnum] = Field(alias="executionType")
    created_at: Optional[Any] = Field(alias="createdAt")
    updated_at: Optional[Any] = Field(alias="updatedAt")
    log: Optional[str]
    do: Optional[str]
    done: Optional[str]
    process: Optional["ExecutionExecutionsResultsProcess"]
    neops_task: Optional["ExecutionExecutionsResultsNeopsTask"] = Field(
        alias="neopsTask"
    )
    state: Optional[ExecutionStateEnum]
    device_execution: Optional[
        List[Optional["ExecutionExecutionsResultsDeviceExecution"]]
    ] = Field(alias="deviceExecution")
    execution_results: Optional[
        List[Optional["ExecutionExecutionsResultsExecutionResults"]]
    ] = Field(alias="executionResults")


class ExecutionExecutionsResultsProcess(BaseModel):
    name: Optional[str]
    id: str


class ExecutionExecutionsResultsNeopsTask(BaseModel):
    id: str
    name: Optional[str]
    description: Optional[str]
    provider: Optional["ExecutionExecutionsResultsNeopsTaskProvider"]


class ExecutionExecutionsResultsNeopsTaskProvider(BaseModel):
    provider_type: Optional[ProviderTypeEnum] = Field(alias="providerType")


class ExecutionExecutionsResultsDeviceExecution(BaseModel):
    id: str
    device: Optional["ExecutionExecutionsResultsDeviceExecutionDevice"]
    run_on: Optional[RunOnEnum] = Field(alias="runOn")
    execute_on: Optional[List[Optional[int]]] = Field(alias="executeOn")
    state: Optional[DeviceExecutionStateEnum]
    result: Optional[Any]
    do: Optional[str]
    exception: Optional[str]
    done: Optional[str]
    changed: Optional[bool]
    log: Optional[str]


class ExecutionExecutionsResultsDeviceExecutionDevice(BaseModel):
    id: str
    hostname: Optional[str]
    platform: Optional["ExecutionExecutionsResultsDeviceExecutionDevicePlatform"]


class ExecutionExecutionsResultsDeviceExecutionDevicePlatform(BaseModel):
    id: str
    name: Optional[str]


class ExecutionExecutionsResultsExecutionResults(BaseModel):
    devicegroupexecutionresult: Optional[
        "ExecutionExecutionsResultsExecutionResultsDevicegroupexecutionresult"
    ]
    deviceexecutionresult: Optional[
        "ExecutionExecutionsResultsExecutionResultsDeviceexecutionresult"
    ]
    clientexecutionresult: Optional[
        "ExecutionExecutionsResultsExecutionResultsClientexecutionresult"
    ]
    interfaceexecutionresult: Optional[
        "ExecutionExecutionsResultsExecutionResultsInterfaceexecutionresult"
    ]


class ExecutionExecutionsResultsExecutionResultsDevicegroupexecutionresult(BaseModel):
    group: Optional[
        "ExecutionExecutionsResultsExecutionResultsDevicegroupexecutionresultGroup"
    ]
    granularity: Optional[int]
    message: Optional[str]
    state: Optional[ExecutionResultStateEnum]


class ExecutionExecutionsResultsExecutionResultsDevicegroupexecutionresultGroup(
    BaseModel
):
    name: Optional[str]


class ExecutionExecutionsResultsExecutionResultsDeviceexecutionresult(BaseModel):
    device: Optional[
        "ExecutionExecutionsResultsExecutionResultsDeviceexecutionresultDevice"
    ]
    granularity: Optional[int]
    message: Optional[str]
    state: Optional[ExecutionResultStateEnum]


class ExecutionExecutionsResultsExecutionResultsDeviceexecutionresultDevice(BaseModel):
    hostname: Optional[str]


class ExecutionExecutionsResultsExecutionResultsClientexecutionresult(BaseModel):
    client: Optional[
        "ExecutionExecutionsResultsExecutionResultsClientexecutionresultClient"
    ]
    granularity: Optional[int]
    message: Optional[str]
    state: Optional[ExecutionResultStateEnum]


class ExecutionExecutionsResultsExecutionResultsClientexecutionresultClient(BaseModel):
    macaddress: Optional[str]


class ExecutionExecutionsResultsExecutionResultsInterfaceexecutionresult(BaseModel):
    interface: Optional[
        "ExecutionExecutionsResultsExecutionResultsInterfaceexecutionresultInterface"
    ]
    granularity: Optional[int]
    message: Optional[str]
    state: Optional[ExecutionResultStateEnum]


class ExecutionExecutionsResultsExecutionResultsInterfaceexecutionresultInterface(
    BaseModel
):
    name: Optional[str]


Execution.model_rebuild()
ExecutionExecutions.model_rebuild()
ExecutionExecutionsResults.model_rebuild()
ExecutionExecutionsResultsNeopsTask.model_rebuild()
ExecutionExecutionsResultsDeviceExecution.model_rebuild()
ExecutionExecutionsResultsDeviceExecutionDevice.model_rebuild()
ExecutionExecutionsResultsExecutionResults.model_rebuild()
ExecutionExecutionsResultsExecutionResultsDevicegroupexecutionresult.model_rebuild()
ExecutionExecutionsResultsExecutionResultsDeviceexecutionresult.model_rebuild()
ExecutionExecutionsResultsExecutionResultsClientexecutionresult.model_rebuild()
ExecutionExecutionsResultsExecutionResultsInterfaceexecutionresult.model_rebuild()
