<a id="mypy-boto3-discovery"></a>

# mypy-boto3-discovery

[![PyPI - mypy-boto3-discovery](https://img.shields.io/pypi/v/mypy-boto3-discovery.svg?color=blue)](https://pypi.org/project/mypy-boto3-discovery)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-discovery.svg?color=blue)](https://pypi.org/project/mypy-boto3-discovery)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-discovery?color=blue)](https://pypistats.org/packages/mypy-boto3-discovery)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ApplicationDiscoveryService 1.18.3](https://boto3.amazonaws.com/v1/documentation/api/1.18.3/reference/services/discovery.html#ApplicationDiscoveryService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 5.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-discovery docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_discovery/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-discovery](#mypy-boto3-discovery)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `ApplicationDiscoveryService` service.

```bash
python -m pip install boto3-stubs[discovery]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[discovery]` in your environment:
  `python -m pip install 'boto3-stubs[discovery]'`

Both type checking and auto-complete should work for
`ApplicationDiscoveryService` service. No explicit type annotations required,
write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[discovery]` in your environment:
  `python -m pip install 'boto3-stubs[discovery]'`

Both type checking and auto-complete should work for
`ApplicationDiscoveryService` service. No explicit type annotations required,
write your `boto3` code as usual. Auto-complete can be slow on big projects or
if you have a lot of installed `boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[discovery]` in your environment:
  `python -m pip install 'boto3-stubs[discovery]'`
- Run `mypy` as usual

Type checking should work for `ApplicationDiscoveryService` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[discovery]` in your environment:
  `python -m pip install 'boto3-stubs[discovery]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ApplicationDiscoveryService` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ApplicationDiscoveryServiceClient` provides annotations for
`boto3.client("discovery")`.

```python
import boto3

from mypy_boto3_discovery import ApplicationDiscoveryServiceClient

client: ApplicationDiscoveryServiceClient = boto3.client("discovery")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ApplicationDiscoveryServiceClient = session.client("discovery")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_discovery.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_discovery import ApplicationDiscoveryServiceClient
from mypy_boto3_discovery.paginator import (
    DescribeAgentsPaginator,
    DescribeContinuousExportsPaginator,
    DescribeExportConfigurationsPaginator,
    DescribeExportTasksPaginator,
    DescribeTagsPaginator,
    ListConfigurationsPaginator,
)

client: ApplicationDiscoveryServiceClient = boto3.client("discovery")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_agents_paginator: DescribeAgentsPaginator = client.get_paginator("describe_agents")
describe_continuous_exports_paginator: DescribeContinuousExportsPaginator = client.get_paginator("describe_continuous_exports")
describe_export_configurations_paginator: DescribeExportConfigurationsPaginator = client.get_paginator("describe_export_configurations")
describe_export_tasks_paginator: DescribeExportTasksPaginator = client.get_paginator("describe_export_tasks")
describe_tags_paginator: DescribeTagsPaginator = client.get_paginator("describe_tags")
list_configurations_paginator: ListConfigurationsPaginator = client.get_paginator("list_configurations")
```

<a id="literals"></a>

### Literals

`mypy_boto3_discovery.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_discovery.literals import (
    AgentStatusType,
    BatchDeleteImportDataErrorCodeType,
    ConfigurationItemTypeType,
    ContinuousExportStatusType,
    DataSourceType,
    DescribeAgentsPaginatorName,
    DescribeContinuousExportsPaginatorName,
    DescribeExportConfigurationsPaginatorName,
    DescribeExportTasksPaginatorName,
    DescribeTagsPaginatorName,
    ExportDataFormatType,
    ExportStatusType,
    ImportStatusType,
    ImportTaskFilterNameType,
    ListConfigurationsPaginatorName,
    orderStringType,
)

def check_value(value: AgentStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_discovery.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_discovery.type_defs import (
    AgentConfigurationStatusTypeDef,
    AgentInfoTypeDef,
    AgentNetworkInfoTypeDef,
    AssociateConfigurationItemsToApplicationRequestRequestTypeDef,
    BatchDeleteImportDataErrorTypeDef,
    BatchDeleteImportDataRequestRequestTypeDef,
    BatchDeleteImportDataResponseTypeDef,
    ConfigurationTagTypeDef,
    ContinuousExportDescriptionTypeDef,
    CreateApplicationRequestRequestTypeDef,
    CreateApplicationResponseTypeDef,
    CreateTagsRequestRequestTypeDef,
    CustomerAgentInfoTypeDef,
    CustomerConnectorInfoTypeDef,
    DeleteApplicationsRequestRequestTypeDef,
    DeleteTagsRequestRequestTypeDef,
    DescribeAgentsRequestRequestTypeDef,
    DescribeAgentsResponseTypeDef,
    DescribeConfigurationsRequestRequestTypeDef,
    DescribeConfigurationsResponseTypeDef,
    DescribeContinuousExportsRequestRequestTypeDef,
    DescribeContinuousExportsResponseTypeDef,
    DescribeExportConfigurationsRequestRequestTypeDef,
    DescribeExportConfigurationsResponseTypeDef,
    DescribeExportTasksRequestRequestTypeDef,
    DescribeExportTasksResponseTypeDef,
    DescribeImportTasksRequestRequestTypeDef,
    DescribeImportTasksResponseTypeDef,
    DescribeTagsRequestRequestTypeDef,
    DescribeTagsResponseTypeDef,
    DisassociateConfigurationItemsFromApplicationRequestRequestTypeDef,
    ExportConfigurationsResponseTypeDef,
    ExportFilterTypeDef,
    ExportInfoTypeDef,
    FilterTypeDef,
    GetDiscoverySummaryResponseTypeDef,
    ImportTaskFilterTypeDef,
    ImportTaskTypeDef,
    ListConfigurationsRequestRequestTypeDef,
    ListConfigurationsResponseTypeDef,
    ListServerNeighborsRequestRequestTypeDef,
    ListServerNeighborsResponseTypeDef,
    NeighborConnectionDetailTypeDef,
    OrderByElementTypeDef,
    PaginatorConfigTypeDef,
    ResponseMetadataTypeDef,
    StartContinuousExportResponseTypeDef,
    StartDataCollectionByAgentIdsRequestRequestTypeDef,
    StartDataCollectionByAgentIdsResponseTypeDef,
    StartExportTaskRequestRequestTypeDef,
    StartExportTaskResponseTypeDef,
    StartImportTaskRequestRequestTypeDef,
    StartImportTaskResponseTypeDef,
    StopContinuousExportRequestRequestTypeDef,
    StopContinuousExportResponseTypeDef,
    StopDataCollectionByAgentIdsRequestRequestTypeDef,
    StopDataCollectionByAgentIdsResponseTypeDef,
    TagFilterTypeDef,
    TagTypeDef,
    UpdateApplicationRequestRequestTypeDef,
)

def get_structure() -> AgentConfigurationStatusTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-discovery` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-discovery docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_discovery/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
