# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.address import Address
from ..types.cost_traces_response import CostTracesResponse
from ..types.creation_source import CreationSource
from ..types.customer import Customer
from ..types.entitlement_usage import EntitlementUsage
from ..types.tax_exempt_status import TaxExemptStatus
from .raw_client import AsyncRawCustomersClient, RawCustomersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomersClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Customer]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Customer]
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        email: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        name : str

        email : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.create(
            name="Acme, Inc.",
            external_id="acme-inc",
        )
        """
        _response = self._raw_client.create(
            name=name,
            email=email,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            request_options=request_options,
        )
        return _response.data

    def get(self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Customer:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.get(
            customer_id="customerId",
        )
        """
        _response = self._raw_client.get(customer_id, request_options=request_options)
        return _response.data

    def update(
        self,
        customer_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        vat_number: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        customer_id : str

        name : typing.Optional[str]

        email : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        vat_number : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Customer updated successfully

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.update(
            customer_id="customerId",
            name="Acme, Inc. (Updated)",
            phone="123-456-7890",
            employee_count=101.0,
            annual_revenue=1000001.0,
        )
        """
        _response = self._raw_client.update(
            customer_id,
            name=name,
            email=email,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            vat_number=vat_number,
            request_options=request_options,
        )
        return _response.data

    def delete(self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.delete(
            customer_id="customerId",
        )
        """
        _response = self._raw_client.delete(customer_id, request_options=request_options)
        return _response.data

    def get_entitlements(
        self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[EntitlementUsage]:
        """
        Parameters
        ----------
        customer_id : str
            The customer ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EntitlementUsage]
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.get_entitlements(
            customer_id="customerId",
        )
        """
        _response = self._raw_client.get_entitlements(customer_id, request_options=request_options)
        return _response.data

    def get_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Customer:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.get_by_external_id(
            external_id="externalId",
        )
        """
        _response = self._raw_client.get_by_external_id(external_id, request_options=request_options)
        return _response.data

    def update_by_external_id(
        self,
        external_id_: str,
        *,
        name: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        vat_number: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        external_id_ : str

        name : typing.Optional[str]

        email : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        vat_number : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.update_by_external_id(
            external_id_="externalId",
        )
        """
        _response = self._raw_client.update_by_external_id(
            external_id_,
            name=name,
            email=email,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            vat_number=vat_number,
            request_options=request_options,
        )
        return _response.data

    def delete_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.delete_by_external_id(
            external_id="externalId",
        )
        """
        _response = self._raw_client.delete_by_external_id(external_id, request_options=request_options)
        return _response.data

    def get_costs_by_external_id(
        self,
        external_id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        start_time: typing.Optional[dt.datetime] = None,
        end_time: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CostTracesResponse:
        """
        Parameters
        ----------
        external_id : str
            The external ID of the customer

        limit : typing.Optional[int]
            Maximum number of traces to return (1-1000)

        offset : typing.Optional[int]
            Number of traces to skip for pagination

        start_time : typing.Optional[dt.datetime]
            Filter traces starting from this time (ISO 8601 format)

        end_time : typing.Optional[dt.datetime]
            Filter traces up to this time (ISO 8601 format)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CostTracesResponse
            Success response

        Examples
        --------
        import datetime

        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.customers.get_costs_by_external_id(
            external_id="externalId",
            limit=1,
            offset=1,
            start_time=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            end_time=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
        )
        """
        _response = self._raw_client.get_costs_by_external_id(
            external_id,
            limit=limit,
            offset=offset,
            start_time=start_time,
            end_time=end_time,
            request_options=request_options,
        )
        return _response.data


class AsyncCustomersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomersClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Customer]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Customer]
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        email: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        name : str

        email : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.create(
                name="Acme, Inc.",
                external_id="acme-inc",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            email=email,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            request_options=request_options,
        )
        return _response.data

    async def get(self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Customer:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.get(
                customer_id="customerId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(customer_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        customer_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        vat_number: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        customer_id : str

        name : typing.Optional[str]

        email : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        vat_number : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Customer updated successfully

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.update(
                customer_id="customerId",
                name="Acme, Inc. (Updated)",
                phone="123-456-7890",
                employee_count=101.0,
                annual_revenue=1000001.0,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            customer_id,
            name=name,
            email=email,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            vat_number=vat_number,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        customer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.delete(
                customer_id="customerId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(customer_id, request_options=request_options)
        return _response.data

    async def get_entitlements(
        self, customer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[EntitlementUsage]:
        """
        Parameters
        ----------
        customer_id : str
            The customer ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EntitlementUsage]
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.get_entitlements(
                customer_id="customerId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_entitlements(customer_id, request_options=request_options)
        return _response.data

    async def get_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Customer:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.get_by_external_id(
                external_id="externalId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_external_id(external_id, request_options=request_options)
        return _response.data

    async def update_by_external_id(
        self,
        external_id_: str,
        *,
        name: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        employee_count: typing.Optional[float] = OMIT,
        annual_revenue: typing.Optional[float] = OMIT,
        tax_exempt_status: typing.Optional[TaxExemptStatus] = OMIT,
        creation_source: typing.Optional[CreationSource] = OMIT,
        website: typing.Optional[str] = OMIT,
        billing_address: typing.Optional[Address] = OMIT,
        vat_number: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Customer:
        """
        Parameters
        ----------
        external_id_ : str

        name : typing.Optional[str]

        email : typing.Optional[str]

        external_id : typing.Optional[str]

        phone : typing.Optional[str]

        employee_count : typing.Optional[float]

        annual_revenue : typing.Optional[float]

        tax_exempt_status : typing.Optional[TaxExemptStatus]

        creation_source : typing.Optional[CreationSource]

        website : typing.Optional[str]

        billing_address : typing.Optional[Address]

        vat_number : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Customer
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.update_by_external_id(
                external_id_="externalId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_external_id(
            external_id_,
            name=name,
            email=email,
            external_id=external_id,
            phone=phone,
            employee_count=employee_count,
            annual_revenue=annual_revenue,
            tax_exempt_status=tax_exempt_status,
            creation_source=creation_source,
            website=website,
            billing_address=billing_address,
            vat_number=vat_number,
            request_options=request_options,
        )
        return _response.data

    async def delete_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.delete_by_external_id(
                external_id="externalId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_external_id(external_id, request_options=request_options)
        return _response.data

    async def get_costs_by_external_id(
        self,
        external_id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        start_time: typing.Optional[dt.datetime] = None,
        end_time: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CostTracesResponse:
        """
        Parameters
        ----------
        external_id : str
            The external ID of the customer

        limit : typing.Optional[int]
            Maximum number of traces to return (1-1000)

        offset : typing.Optional[int]
            Number of traces to skip for pagination

        start_time : typing.Optional[dt.datetime]
            Filter traces starting from this time (ISO 8601 format)

        end_time : typing.Optional[dt.datetime]
            Filter traces up to this time (ISO 8601 format)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CostTracesResponse
            Success response

        Examples
        --------
        import asyncio
        import datetime

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.customers.get_costs_by_external_id(
                external_id="externalId",
                limit=1,
                offset=1,
                start_time=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                end_time=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_costs_by_external_id(
            external_id,
            limit=limit,
            offset=offset,
            start_time=start_time,
            end_time=end_time,
            request_options=request_options,
        )
        return _response.data
