# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...types.order import Order
from ...types.order_line_create import OrderLineCreate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawLinesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def update(
        self,
        order_id: str,
        *,
        lines: typing.Optional[typing.Sequence[OrderLineCreate]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Order]:
        """
        Parameters
        ----------
        order_id : str

        lines : typing.Optional[typing.Sequence[OrderLineCreate]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Order]
            Success response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"orders/{jsonable_encoder(order_id)}/lines",
            method="PUT",
            json={
                "lines": convert_and_respect_annotation_metadata(
                    object_=lines, annotation=typing.Sequence[OrderLineCreate], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Order,
                    parse_obj_as(
                        type_=Order,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawLinesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def update(
        self,
        order_id: str,
        *,
        lines: typing.Optional[typing.Sequence[OrderLineCreate]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Order]:
        """
        Parameters
        ----------
        order_id : str

        lines : typing.Optional[typing.Sequence[OrderLineCreate]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Order]
            Success response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"orders/{jsonable_encoder(order_id)}/lines",
            method="PUT",
            json={
                "lines": convert_and_respect_annotation_metadata(
                    object_=lines, annotation=typing.Sequence[OrderLineCreate], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Order,
                    parse_obj_as(
                        type_=Order,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
