# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .order_line_attribute_pricing import OrderLineAttributePricing


class OrderLineAttributeCreate(UniversalBaseModel):
    agent_attribute_name: typing_extensions.Annotated[str, FieldMetadata(alias="agentAttributeName")] = pydantic.Field()
    """
    The name of the agent attribute to override (e.g., "api_call", "call_placed")
    """

    quantity: typing.Optional[float] = pydantic.Field(default=None)
    """
    Quantity for this attribute (defaults to 0)
    """

    pricing: OrderLineAttributePricing = pydantic.Field()
    """
    Custom pricing configuration for this attribute
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
