# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class Signal(UniversalBaseModel):
    event_name: typing.Optional[str] = None
    agent_id: typing.Optional[str] = None
    external_agent_id: typing.Optional[str] = None
    customer_id: typing.Optional[str] = None
    """
    Deprecated. The external customer id. Use `external_customer_id` or `internal_customer_id` instead.
    """

    data: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    idempotency_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique key to ensure idempotent signal processing
    """

    internal_customer_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Paid's internal customer ID
    """

    external_customer_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Your system's customer ID
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
