# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-04-04 23:07
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0020_build_ordering'),
    ]

    operations = [
        migrations.CreateModel(
            name='Backend',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField()),
                ('username', models.CharField(max_length=128)),
                ('token', models.CharField(max_length=1024)),
                ('implementation_type', models.CharField(choices=[('lava', 'LAVA'), ('null', 'None')], default='null', max_length=64)),
                ('poll_interval', models.IntegerField(default=60)),
            ],
        ),
        migrations.CreateModel(
            name='TestJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('build', models.TextField()),
                ('environment', models.CharField(max_length=100, validators=[django.core.validators.RegexValidator(regex='^[a-zA-Z0-9][a-zA-Z0-9_-]+')])),
                ('definition', models.TextField()),
                ('submitted', models.BooleanField(default=False)),
                ('fetched', models.BooleanField(default=False)),
                ('last_fetch_attempt', models.DateTimeField(blank=True, default=None, null=True)),
                ('job_id', models.CharField(blank=True, max_length=128, null=True)),
                ('job_status', models.CharField(blank=True, max_length=128, null=True)),
                ('backend', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='test_jobs', to='ci.Backend')),
                ('target', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Project')),
            ],
        ),
    ]
