# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-10-23 19:58
from __future__ import unicode_literals

from django.db import migrations
from django.conf import settings


POSTGRESQL = 'postgresql' in settings.DATABASES['default']['ENGINE']


SQL = """
UPDATE ci_testjob
SET target_build_id = core_build.id
FROM core_build
WHERE core_build.project_id = ci_testjob.target_id
AND core_build.version = ci_testjob.build
"""


REVERSE_SQL = """
UPDATE ci_testjob SET target_build_id = NULL
"""


class Migration(migrations.Migration):

    dependencies = [
        ('ci', '0014_testjob_target_build'),
    ]

    if POSTGRESQL:
        # Only PostgreSQL is supported. SQLite does not support "UPDATE FROM"
        # so a similar UPDATE query would take ages
        operations = [
            migrations.RunSQL(SQL, reverse_sql=REVERSE_SQL),
        ]
    else:
        operations = []
