# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-06-27 13:25
from __future__ import unicode_literals

from django.db import migrations

from squad.core.models import TestSummary, MetricsSummary


def update_test_summary(apps, schema_editor):
    ProjectStatus = apps.get_model('core', 'ProjectStatus')
    for status in ProjectStatus.objects.all():
        if status.build:
            summary = TestSummary(status.build)
            metrics_summary = MetricsSummary(status.build)
            status.tests_pass = summary.tests_pass
            status.tests_fail = summary.tests_fail
            status.tests_skip = summary.tests_skip
            status.metrics_summary = metrics_summary.value
            status.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0037_project_status_test_summary_fields'),
    ]

    operations = [
        migrations.RunPython(
            update_test_summary,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
