# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pypipr']

package_data = \
{'': ['*']}

install_requires = \
['colorama',
 'cssselect',
 'lxml',
 'pyyaml>=6.0,<7.0',
 'requests>=2.30.0,<3.0.0',
 'tzdata']

extras_require = \
{':platform_system == "Linux"': ['getch']}

setup_kwargs = {
    'name': 'pypipr',
    'version': '0.1.79',
    'description': 'The Python Package Index Project',
    'long_description': '# About\nThe Python Package Index Project (pypipr)\n\npypi : https://pypi.org/project/pypipr\n\n\n# Setup\nInstall with pip\n```\npython -m pip install pypipr\n```\n\nImport with * for fastest access\n```python\nfrom pypipr.pypipr import *\n```\n\n\n# Functions\n`WINDOWS` True apabila berjalan di platform Windows\n\n```python\nprint(WINDOWS)\n```\n\n\n`LINUX` True apabila berjalan di platform Linux\n\n```python\nprint(LINUX)\n```\n\n\n`avg()` Simple Average Function karena tidak disediakan oleh python\n\n```python\nn = [1, 22, 2, 3, 13, 2, 123, 12, 31, 2, 2, 12, 2, 1]\nprint(avg(n))\n```\n\n\n`random_bool()` Menghasilkan nilai random antara 1 atau 0\n\n```python\nprint(random_bool())\n```\n\n\n`set_timeout()` Menjalankan fungsi ketika sudah sekian detik.\n\n```python\nset_timeout(3, lambda: print("Timeout 3"))\nx = set_timeout(7, lambda: print("Timeout 7"))\nprint(x)\nprint("menghentikan timeout 7")\nx.cancel()\n```\n\n\n`get_class_method()` Mengembalikan berupa tuple yg berisi list dari method dalam class\n\n```python\nclass ExampleGetClassMethod:\n    def a():\n        return [x for x in range(10)]\n\n    def b():\n        return [x for x in range(10)]\n\n    def c():\n        return [x for x in range(10)]\n\n    def d():\n        return [x for x in range(10)]\n\n\nif __name__ == "__main__":\n    print(get_class_method(ExampleGetClassMethod))\n```\n\n\n`exit_if_empty()` Menghentikan program apabila semua variabel bernilai false\n\n```python\nvar1 = None\nvar2 = \'0\'\nexit_if_empty(var1, var2)\n```\n\n\n`strtr()` STRing TRanslate, mengubah string menggunakan kamus dari dict.\n\n```python\ntext = \'aku disini mau kemana saja\'\nreplacements = {\n    "disini": "disitu",\n    "kemana": "kesini",\n}\nprint(strtr(text, replacements))\n```\n\n\n`strtr_regex()` STRing TRanslate, mengubah string menggunakan kamus dari dict.\n\n```python\ntext = \'aku {{ ini }} mau ke {{ sini }} mau kemana saja\'\nreplacements = {\n    r"\\{\\{\\s*(ini)\\s*\\}\\}": r"itu dan \\1",\n    r"\\{\\{\\s*sini\\s*\\}\\}": r"situ",\n}\nprint(strtr_regex(text, replacements))\n```\n\n\n`print_dir()` print possible property and method from variable\n\n```python\np = pathlib.Path("c:/arba/dzukhron.dz")\nprint_dir(p)\n```\n\n\n`is_iterable()` Mengecek apakah suatu variabel bisa dilakukan forloop atau tidak\n\n```python\ns = \'ini string\'\nprint(is_iterable(s))\n\nl = [12,21,2,1]\nprint(is_iterable(l))\n```\n\n\n`irange()` Meningkatkan fungsi range() dari python untuk pengulangan menggunakan huruf\n\n```python\nprint(generator.irange(\'a\', \'z\'))\nprint(irange(\'H\', \'a\'))\nprint(irange(\'1\', \'5\', 3))\nprint(irange(-10, 4, 3))\nprint(irange(1, 5))\n```\n\n\n`serialize()`  PHP like serialize function\n\n```python\ndata = {\n    \'a\': 123,\n    \'t\': [\'disini\', \'senang\', \'disana\', \'senang\'],\n    \'l\': (12, 23, [12, 42])\n}\nprint(serialize(data))\n```\n\n\n`unserialize()` PHP like unserialize function\n\n```python\ndata = {\n    \'a\': 123,\n    \'t\': [\'disini\', \'senang\', \'disana\', \'senang\'],\n    \'l\': (12, 23, [12, 42])\n}\ns = serialize(data)\nprint(unserialize(s))\n```\n\n\n# Compare Performance\n\n`class ComparePerformance` Menjalankan seluruh method dalam class, kemudian membandingkan waktu yg diperlukan.\n\n```python\nclass ExampleComparePerformance(ComparePerformance):\n    # number = 1\n    z = 10\n\n    def a(self):\n        return (x for x in range(self.z))\n\n    def b(self):\n        return tuple(x for x in range(self.z))\n\n    def c(self):\n        return [x for x in range(self.z)]\n\n    def d(self):\n        return list(x for x in range(self.z))\n\n\nif __name__ == "__main__":\n    print(ExampleComparePerformance().compare_result())\n    print(ExampleComparePerformance().compare_performance())\n    print(ExampleComparePerformance().compare_performance())\n    print(ExampleComparePerformance().compare_performance())\n    print(ExampleComparePerformance().compare_performance())\n    print(ExampleComparePerformance().compare_performance())\n```\n\n\n# Run Parallel\n\n`class RunParallel` Menjalankan program secara bersamaan.\n\n\nStructure:\n- Semua methods akan dijalankan secara paralel kecuali method dengan nama yg diawali underscore `_`\n- Method untuk multithreading/multiprocessing harus memiliki 2 parameter, yaitu: `result: dict` dan `q: queue.Queue`. Parameter `result` digunaan untuk memberikan return value dari method, dan Parameter `q` digunakan untuk mengirim data antar proses.\n- Method untuk asyncio harus menggunakan keyword `async def`, dan untuk perpindahan antar kode menggunakan `await asyncio.sleep(0)`, dan keyword `return` untuk memberikan return value.\n- Return Value berupa dictionary dengan key adalah nama function, dan value adalah return value dari setiap fungsi\n\n\nNote:\n- `class RunParallel` didesain hanya untuk pemrosesan data saja.\n- Penggunaannya `class RunParallel` dengan cara membuat instance sub class beserta data yg akan diproses, kemudian panggil fungsi yg dipilih `run_asyncio / run_multi_threading / run_multi_processing`, kemudian dapatkan hasilnya.\n- `class RunParallel` tidak didesain untuk menyimpan data, karena setiap module terutama module `multiprocessing` tidak dapat mengakses data kelas dari proses yg berbeda.\n\n\n```python\nclass ExampleRunParallel(RunParallel):\n    z = "ini"\n\n    def __init__(self) -> None:\n        self.pop = random.randint(0, 100)\n    \n    def _set_property_here(self, v):\n        self.prop = v\n\n    def a(self, result: dict, q: queue.Queue):\n        result["z"] = self.z\n        result["pop"] = self.pop\n        result["a"] = "a"\n        q.put("from a 1")\n        q.put("from a 2")\n\n    def b(self, result: dict, q: queue.Queue):\n        result["z"] = self.z\n        result["pop"] = self.pop\n        result["b"] = "b"\n        result["q_get"] = q.get()\n\n    def c(self, result: dict, q: queue.Queue):\n        result["z"] = self.z\n        result["pop"] = self.pop\n        result["c"] = "c"\n        result["q_get"] = q.get()\n\n    async def d(self):\n        print("hello")\n        await asyncio.sleep(0)\n        print("hello")\n\n        result = {}\n        result["z"] = self.z\n        result["pop"] = self.pop\n        result["d"] = "d"\n        return result\n\n    async def e(self):\n        print("world")\n        await asyncio.sleep(0)\n        print("world")\n\n        result = {}\n        result["z"] = self.z\n        result["pop"] = self.pop\n        result["e"] = "e"\n        return result\n\n\nif __name__ == "__main__":\n    print(ExampleRunParallel().run_asyncio())\n    print(ExampleRunParallel().run_multi_threading())\n    print(ExampleRunParallel().run_multi_processing())\n```\n\n\n# Collections\n\n`sets_ordered()` Hanya mengambil nilai unik dari suatu list\n\n```python\narray = [2, 3, 12, 3, 3, 42, 42, 1, 43, 2, 42, 41, 4, 24, 32, 42, 3, 12, 32, 42, 42]\nprint(generator.sets_ordered(array))\nprint(sets_ordered(array))\n```\n\n\n`chunck_array()` membagi array menjadi potongan dengan besaran yg diinginkan\n\n```python\narray = [2, 3, 12, 3, 3, 42, 42, 1, 43, 2, 42, 41, 4, 24, 32, 42, 3, 12, 32, 42, 42]\nprint(generator.chunck_array(array, 5))\nprint(chunck_array(array, 5))\n```\n\n\n`dict_first()` Mengambil nilai (key, value) pertama dari dictionary dalam bentuk tuple\n\n```python\nd = {\n    "key1": "value1",\n    "key2": "value2",\n    "key3": "value3",\n}\nprint(dict_first(d))\n```\n\n\n`implode()` Simplify Python join functions\n\n```python\narr = [\'asd\',\'dfs\',\'weq\',\'qweqw\']\nprint(implode(\'-\', arr))\n```\n\n\n# Console\n\n`print_colorize()` print ke console dengan warna\n\n```python\nprint_colorize("Print some text")\nprint_colorize("Print some text", color=colorama.Fore.RED)\n```\n\n\n`@Log()` / `Log decorator` akan melakukan print ke console. Mempermudah pembuatan log karena tidak perlu mengubah fungsi yg sudah ada. Berguna untuk memberikan informasi proses program yg sedang berjalan.\n\n```python\n\n@log\ndef some_function():\n    pass\n\n@log()\ndef some_function_again():\n    pass\n\n@log("Calling some function")\ndef some_function_more():\n    pass\n\nif __name__ == "__main__":\n    some_function()\n    some_function_again()\n    some_function_more()\n```\n\n\n`print_log` akan melakukan print ke console. Berguna untuk memberikan informasi proses program yg sedang berjalan.\n\n```python\nprint_log("Standalone Log")\n```\n\n\n`input_char()` meminta masukan satu huruf tanpa menekan enter.\n\n```py\ninput_char("Input char : ")\ninput_char("Input char : ", default=\'Y\')\ninput_char("Input Char without print : ", echo_char=False)\n```\n\n\n# Datetime\n\n`datetime_now()` memudahkan dalam membuat tanggal dan waktu untuk suatu timezone\n\n```python\nprint(datetime_now("Asia/Jakarta"))\nprint(datetime_now("GMT"))\nprint(datetime_now("Etc/GMT+7"))\n```\n\n\n`datetime_from_string()` Parse iso_string menjadi datetime object dengan timezone UTC\n\n```python\nprint(datetime_from_string("2022-12-12 15:40:13").isoformat())\nprint(datetime_from_string("2022-12-12 15:40:13", timezone="Asia/Jakarta").isoformat())\n```\n\n\n# File and Folder\n\n`file_put_contents()` membuat file kemudian menuliskan contents ke file. Apabila file memiliki contents, maka contents akan di overwrite.\n\n```py\nfile_put_contents("ifile_test.txt", "Contoh menulis content")\n```\n\n\n`file_get_contents()` membaca contents file ke memory.\n\n```py\nprint(file_get_contents("ifile_test.txt"))\n```\n\n\n`html_get_contents()` Mengambil content html dari url\n\n```py\nprint(html_get_contents("https://arbadzukhron.deta.dev/"))\n```\n```python\n# Using XPATH\na = html_get_contents("https://www.google.com/", xpath="//a")\nfor i in a:\n    print(i.text)\n    print(i.attrib.get(\'href\'))\n\n# Using REGEX\na = html_get_contents("https://www.google.com/", regex=r"(<a.[^>]+>(?:(?:\\s+)?(.[^<]+)(?:\\s+)?)<\\/a>)")\nfor i in a:\n    print(i)\n\n# Using cssselect\na = html_get_contents("https://www.google.com/", css_select="a")\nfor i in a:\n    print(i.text)\n    print(i.attrib.get("href"))\n```\n\n\n`html_put_contents()` Mengirim POST data ke url. Return response content.\n\n```py\ndata = dict(pengirim="saya", penerima="kamu")\nprint(html_put_contents("https://arbadzukhron.deta.dev/", data))\n```\n\n\n`get_filesize()` Mengambil informasi file size dalam bytes\n\n```python\nprint(get_filesize(__file__))\n```\n\n\n`get_filemtime()` Mengambil informasi last modification time file dalam nano seconds\n\n```python\nprint(get_filemtime(__file__))\n```\n\n\n`create_folder()` membuat folder secara recursive.\n\n```py\ncreate_folder("contoh_membuat_folder")\ncreate_folder("contoh/membuat/folder/recursive")\ncreate_folder("./contoh_membuat_folder/secara/recursive")\n```\n\n\n`iscandir()` scan folder, subfolder, dan file\n\n```py\nfor i in generator.iscandir():\n    print(i)\n\nfor i in iscandir():\n    print(i)\n```\n\n\n`scan_folder()` scan folder dan subfolder\n\n```python\nfor i in generator.scan_folder(recursive=False):\n    print(i)\n\nfor i in scan_folder(recursive=False):\n    print(i)\n```\n\n\n`scan_file()` scan file dalam folder dan subfolder\n\n```py\nfor i in generator.scan_file():\n    print(i)\n    \nfor i in scan_file():\n    print(i)\n```\n\n\n`dirname()` nama folder\n\n```python\nprint(dirname("/ini/nama/folder/ke/file.py"))\n```\n\n\n`basename()` nama file dari path\n\n```python\nprint(basename("/ini/nama/folder/ke/file.py"))\n```\n\n\n# Third Party\n\n`github_pull()` simple github pull\n\n```py\ngithub_pull()\n```\n\n\n`github_push()` simple github push dengan auto commit message\n\n```py\ngithub_push(\'Commit Message\')\n```\n',
    'author': 'ufiapjj',
    'author_email': 'ufiapjj@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.9',
}


setup(**setup_kwargs)
