"""Remove unique attribute from username

Revision ID: ebc827e80373
Revises: 8ba7d4c42044
Create Date: 2024-12-05 16:24:01.098473
"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "ebc827e80373"
down_revision = "8ba7d4c42044"


def upgrade():
    """Alembic migration."""
    # ### commands auto generated by Alembic - please adjust! ###
    # Remove the index and recreate it as there is no way to remove just the unique
    # constrain from index
    op.drop_index("ix_users_username", "users")
    op.create_index("ix_users_username", "users", ["username"])
    # ### end Alembic commands ###


def downgrade():
    """Downgrade migration."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_users_username", "users")
    op.create_index(op.f("ix_users_username"), "users", ["username"], unique=True)
    # ### end Alembic commands ###
