#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Copyright 2018  Red Hat, Inc.
#
# This copyrighted material is made available to anyone wishing to use,
# modify, copy, or redistribute it subject to the terms and conditions
# of the GNU General Public License v.2, or (at your option) any later
# version.  This program is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY expressed or implied, including the
# implied warranties of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.  You
# should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# Any Red Hat trademarks that are incorporated in the source
# code or documentation are not subject to the GNU General Public
# License and may only be used or replicated with the express permission
# of Red Hat, Inc.
#
"""
This script is used for GDPR SAR (General Data Protection Regulation
Subject Access Requests).
It returns information about specific user saved by Anitya.
It reads SAR_USERNAME and SAR_EMAIL environment variables as keys for
getting data from database.

 Authors:
   Michal Konecny <mkonecny@redhat.com>
"""

import json
import logging
import os
import sys

from anitya import db
from anitya.config import config

_log = logging.getLogger("anitya")


def main():
    """
    Retrieve database entry for user.
    """
    _log.debug("SAR script start")
    db.initialize(config)
    sar_username = os.getenv("SAR_USERNAME")
    sar_email = os.getenv("SAR_EMAIL")

    users = []

    if sar_email:
        _log.debug("Find users by e-mail %s", sar_email)
        users = users + db.User.query.filter_by(email=sar_email).all()

    if sar_username:
        _log.debug("Find users by username %s", sar_username)
        users = users + db.User.query.filter_by(username=sar_username).all()

    users_list = []
    for user in users:
        user_dict = user.to_dict()
        users_list.append(user_dict)

    json.dump(users_list, sys.stdout)
    _log.debug("SAR script end")


if __name__ == "__main__":
    main()
