# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.08.05
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from agilicus_api.api_client import ApiClient
from agilicus_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ApplicationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_config(self, app_id, env_name, environment_config, **kwargs):  # noqa: E501
        """Add an environment configuration row  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_config(app_id, env_name, environment_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param EnvironmentConfig environment_config: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_config_with_http_info(app_id, env_name, environment_config, **kwargs)  # noqa: E501

    def add_config_with_http_info(self, app_id, env_name, environment_config, **kwargs):  # noqa: E501
        """Add an environment configuration row  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_config_with_http_info(app_id, env_name, environment_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param EnvironmentConfig environment_config: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'environment_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `add_config`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `add_config`")  # noqa: E501
        # verify the required parameter 'environment_config' is set
        if self.api_client.client_side_validation and ('environment_config' not in local_var_params or  # noqa: E501
                                                        local_var_params['environment_config'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `environment_config` when calling `add_config`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `add_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `add_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'environment_config' in local_var_params:
            body_params = local_var_params['environment_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_role(self, app_id, role_v2, **kwargs):  # noqa: E501
        """Add a role to the application.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role(app_id, role_v2, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param RoleV2 role_v2: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_role_with_http_info(app_id, role_v2, **kwargs)  # noqa: E501

    def add_role_with_http_info(self, app_id, role_v2, **kwargs):  # noqa: E501
        """Add a role to the application.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_with_http_info(app_id, role_v2, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param RoleV2 role_v2: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleV2, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'role_v2']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `add_role`")  # noqa: E501
        # verify the required parameter 'role_v2' is set
        if self.api_client.client_side_validation and ('role_v2' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_v2'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_v2` when calling `add_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `add_role`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'role_v2' in local_var_params:
            body_params = local_var_params['role_v2']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/roles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_role_to_rule_entry(self, app_id, role_to_rule_entry, **kwargs):  # noqa: E501
        """Add a rule to a role in the application.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_to_rule_entry(app_id, role_to_rule_entry, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param RoleToRuleEntry role_to_rule_entry: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleToRuleEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_role_to_rule_entry_with_http_info(app_id, role_to_rule_entry, **kwargs)  # noqa: E501

    def add_role_to_rule_entry_with_http_info(self, app_id, role_to_rule_entry, **kwargs):  # noqa: E501
        """Add a rule to a role in the application.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_to_rule_entry_with_http_info(app_id, role_to_rule_entry, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param RoleToRuleEntry role_to_rule_entry: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleToRuleEntry, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'role_to_rule_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role_to_rule_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `add_role_to_rule_entry`")  # noqa: E501
        # verify the required parameter 'role_to_rule_entry' is set
        if self.api_client.client_side_validation and ('role_to_rule_entry' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_to_rule_entry'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_to_rule_entry` when calling `add_role_to_rule_entry`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `add_role_to_rule_entry`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'role_to_rule_entry' in local_var_params:
            body_params = local_var_params['role_to_rule_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/role_to_rule_entries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleToRuleEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_rule(self, app_id, rule_v2, **kwargs):  # noqa: E501
        """Add a rule to the application.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_rule(app_id, rule_v2, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param RuleV2 rule_v2: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RuleV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_rule_with_http_info(app_id, rule_v2, **kwargs)  # noqa: E501

    def add_rule_with_http_info(self, app_id, rule_v2, **kwargs):  # noqa: E501
        """Add a rule to the application.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_rule_with_http_info(app_id, rule_v2, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param RuleV2 rule_v2: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RuleV2, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'rule_v2']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `add_rule`")  # noqa: E501
        # verify the required parameter 'rule_v2' is set
        if self.api_client.client_side_validation and ('rule_v2' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_v2'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_v2` when calling `add_rule`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `add_rule`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule_v2' in local_var_params:
            body_params = local_var_params['rule_v2']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_application(self, application, **kwargs):  # noqa: E501
        """Create an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_application(application, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Application application: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_application_with_http_info(application, **kwargs)  # noqa: E501

    def create_application_with_http_info(self, application, **kwargs):  # noqa: E501
        """Create an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_application_with_http_info(application, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Application application: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Application, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['application']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'application' is set
        if self.api_client.client_side_validation and ('application' not in local_var_params or  # noqa: E501
                                                        local_var_params['application'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `application` when calling `create_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'application' in local_var_params:
            body_params = local_var_params['application']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_application(self, app_id, **kwargs):  # noqa: E501
        """Remove an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_application(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_application_with_http_info(app_id, **kwargs)  # noqa: E501

    def delete_application_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Remove an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_application_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `delete_application`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `delete_application`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_config(self, app_id, env_name, env_config_id, maintenance_org_id, **kwargs):  # noqa: E501
        """Remove an environment configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_config(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_config_with_http_info(app_id, env_name, env_config_id, maintenance_org_id, **kwargs)  # noqa: E501

    def delete_config_with_http_info(self, app_id, env_name, env_config_id, maintenance_org_id, **kwargs):  # noqa: E501
        """Remove an environment configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_config_with_http_info(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'env_config_id', 'maintenance_org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `delete_config`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `delete_config`")  # noqa: E501
        # verify the required parameter 'env_config_id' is set
        if self.api_client.client_side_validation and ('env_config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_config_id` when calling `delete_config`")  # noqa: E501
        # verify the required parameter 'maintenance_org_id' is set
        if self.api_client.client_side_validation and ('maintenance_org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['maintenance_org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `maintenance_org_id` when calling `delete_config`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `delete_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `delete_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_config_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_config_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_config_id` when calling `delete_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'maintenance_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['maintenance_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `maintenance_org_id` when calling `delete_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501
        if 'env_config_id' in local_var_params:
            path_params['env_config_id'] = local_var_params['env_config_id']  # noqa: E501

        query_params = []
        if 'maintenance_org_id' in local_var_params and local_var_params['maintenance_org_id'] is not None:  # noqa: E501
            query_params.append(('maintenance_org_id', local_var_params['maintenance_org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role(self, app_id, role_id, **kwargs):  # noqa: E501
        """Remove a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role(app_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_id: The id of a role (required)
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_role_with_http_info(app_id, role_id, **kwargs)  # noqa: E501

    def delete_role_with_http_info(self, app_id, role_id, **kwargs):  # noqa: E501
        """Remove a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_with_http_info(app_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_id: The id of a role (required)
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'role_id', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `delete_role`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if self.api_client.client_side_validation and ('role_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_id` when calling `delete_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `delete_role`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'role_id' in local_var_params:
            path_params['role_id'] = local_var_params['role_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/roles/{role_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role_to_rule_entry(self, app_id, role_to_rule_entry_id, **kwargs):  # noqa: E501
        """Remove a role_to_rule_entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_to_rule_entry(app_id, role_to_rule_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_to_rule_entry_id: The id of a role to rule entry (required)
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_role_to_rule_entry_with_http_info(app_id, role_to_rule_entry_id, **kwargs)  # noqa: E501

    def delete_role_to_rule_entry_with_http_info(self, app_id, role_to_rule_entry_id, **kwargs):  # noqa: E501
        """Remove a role_to_rule_entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_to_rule_entry_with_http_info(app_id, role_to_rule_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_to_rule_entry_id: The id of a role to rule entry (required)
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'role_to_rule_entry_id', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role_to_rule_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `delete_role_to_rule_entry`")  # noqa: E501
        # verify the required parameter 'role_to_rule_entry_id' is set
        if self.api_client.client_side_validation and ('role_to_rule_entry_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_to_rule_entry_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_to_rule_entry_id` when calling `delete_role_to_rule_entry`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `delete_role_to_rule_entry`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'role_to_rule_entry_id' in local_var_params:
            path_params['role_to_rule_entry_id'] = local_var_params['role_to_rule_entry_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_rule(self, app_id, rule_id, **kwargs):  # noqa: E501
        """Remove a rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule(app_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str rule_id: The id of a rule (required)
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_rule_with_http_info(app_id, rule_id, **kwargs)  # noqa: E501

    def delete_rule_with_http_info(self, app_id, rule_id, **kwargs):  # noqa: E501
        """Remove a rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule_with_http_info(app_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str rule_id: The id of a rule (required)
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'rule_id', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `delete_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if self.api_client.client_side_validation and ('rule_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_id` when calling `delete_rule`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `delete_rule`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'rule_id' in local_var_params:
            path_params['rule_id'] = local_var_params['rule_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/rules/{rule_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_application(self, app_id, **kwargs):  # noqa: E501
        """Get a application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_application(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param str assigned_org_id: Organisation unique identifier for an assigned object
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_application_with_http_info(app_id, **kwargs)  # noqa: E501

    def get_application_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Get a application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_application_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param str assigned_org_id: Organisation unique identifier for an assigned object
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Application, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'org_id', 'assigned_org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_application`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `get_application`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'assigned_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['assigned_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `assigned_org_id` when calling `get_application`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'assigned_org_id' in local_var_params and local_var_params['assigned_org_id'] is not None:  # noqa: E501
            query_params.append(('assigned_org_id', local_var_params['assigned_org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config(self, app_id, env_name, env_config_id, maintenance_org_id, **kwargs):  # noqa: E501
        """Get environment configuration  # noqa: E501

        Retrieve environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_config_with_http_info(app_id, env_name, env_config_id, maintenance_org_id, **kwargs)  # noqa: E501

    def get_config_with_http_info(self, app_id, env_name, env_config_id, maintenance_org_id, **kwargs):  # noqa: E501
        """Get environment configuration  # noqa: E501

        Retrieve environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_with_http_info(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'env_config_id', 'maintenance_org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_config`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `get_config`")  # noqa: E501
        # verify the required parameter 'env_config_id' is set
        if self.api_client.client_side_validation and ('env_config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_config_id` when calling `get_config`")  # noqa: E501
        # verify the required parameter 'maintenance_org_id' is set
        if self.api_client.client_side_validation and ('maintenance_org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['maintenance_org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `maintenance_org_id` when calling `get_config`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `get_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `get_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_config_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_config_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_config_id` when calling `get_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'maintenance_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['maintenance_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `maintenance_org_id` when calling `get_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501
        if 'env_config_id' in local_var_params:
            path_params['env_config_id'] = local_var_params['env_config_id']  # noqa: E501

        query_params = []
        if 'maintenance_org_id' in local_var_params and local_var_params['maintenance_org_id'] is not None:  # noqa: E501
            query_params.append(('maintenance_org_id', local_var_params['maintenance_org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_environment(self, app_id, env_name, org_id, **kwargs):  # noqa: E501
        """Get an environment  # noqa: E501

        This allows an environment maintainer to get an environment they maintain.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment(app_id, env_name, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str org_id: Organisation unique identifier (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_environment_with_http_info(app_id, env_name, org_id, **kwargs)  # noqa: E501

    def get_environment_with_http_info(self, app_id, env_name, org_id, **kwargs):  # noqa: E501
        """Get an environment  # noqa: E501

        This allows an environment maintainer to get an environment they maintain.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment_with_http_info(app_id, env_name, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str org_id: Organisation unique identifier (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Environment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_environment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_environment`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `get_environment`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if self.api_client.client_side_validation and ('org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `org_id` when calling `get_environment`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `get_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `get_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `org_id` when calling `get_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Environment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role(self, app_id, role_id, **kwargs):  # noqa: E501
        """Get a role  # noqa: E501

        Retrieves a given role by ID   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role(app_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_id: The id of a role (required)
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_role_with_http_info(app_id, role_id, **kwargs)  # noqa: E501

    def get_role_with_http_info(self, app_id, role_id, **kwargs):  # noqa: E501
        """Get a role  # noqa: E501

        Retrieves a given role by ID   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_with_http_info(app_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_id: The id of a role (required)
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleV2, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'role_id', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_role`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if self.api_client.client_side_validation and ('role_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_id` when calling `get_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `get_role`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'role_id' in local_var_params:
            path_params['role_id'] = local_var_params['role_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/roles/{role_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role_to_rule_entry(self, app_id, role_to_rule_entry_id, **kwargs):  # noqa: E501
        """Get a role_to_rule_entry  # noqa: E501

        Retrieves a given role_to_rule_entry by ID   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_to_rule_entry(app_id, role_to_rule_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_to_rule_entry_id: The id of a role to rule entry (required)
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleToRuleEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_role_to_rule_entry_with_http_info(app_id, role_to_rule_entry_id, **kwargs)  # noqa: E501

    def get_role_to_rule_entry_with_http_info(self, app_id, role_to_rule_entry_id, **kwargs):  # noqa: E501
        """Get a role_to_rule_entry  # noqa: E501

        Retrieves a given role_to_rule_entry by ID   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_to_rule_entry_with_http_info(app_id, role_to_rule_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_to_rule_entry_id: The id of a role to rule entry (required)
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleToRuleEntry, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'role_to_rule_entry_id', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role_to_rule_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_role_to_rule_entry`")  # noqa: E501
        # verify the required parameter 'role_to_rule_entry_id' is set
        if self.api_client.client_side_validation and ('role_to_rule_entry_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_to_rule_entry_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_to_rule_entry_id` when calling `get_role_to_rule_entry`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `get_role_to_rule_entry`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'role_to_rule_entry_id' in local_var_params:
            path_params['role_to_rule_entry_id'] = local_var_params['role_to_rule_entry_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleToRuleEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule(self, app_id, rule_id, **kwargs):  # noqa: E501
        """Get a rule  # noqa: E501

        Retrieves a given rule by ID   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule(app_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str rule_id: The id of a rule (required)
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RuleV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_rule_with_http_info(app_id, rule_id, **kwargs)  # noqa: E501

    def get_rule_with_http_info(self, app_id, rule_id, **kwargs):  # noqa: E501
        """Get a rule  # noqa: E501

        Retrieves a given rule by ID   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_with_http_info(app_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str rule_id: The id of a rule (required)
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RuleV2, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'rule_id', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if self.api_client.client_side_validation and ('rule_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_id` when calling `get_rule`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `get_rule`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'rule_id' in local_var_params:
            path_params['rule_id'] = local_var_params['rule_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/rules/{rule_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_applications(self, **kwargs):  # noqa: E501
        """Get applications  # noqa: E501

        Retrieves all applications related to the org_id. Different types of relationship may be queried by setting the appropriate flags:   - assigned: Has an Environment assigned to the organisation.   - owned: Owned by the organisation.   - maintained: Has an Environment maintained by the organisation. Any combination of the relationship flags may be set. Note that if the organisation does not own the Application, but maintains or is assigned an environment only those assignments and environments for the querying organisation will be shown.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_applications(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str org_id: Organisation Unique identifier
        :param str assigned_org_id: Organisation unique identifier for an assigned object
        :param bool maintained: Query for Applications maintained by the `org_id`. These are Applications which have an Environment whose `maintenance_org_id` is the `org_id`. 
        :param bool assigned: Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. 
        :param bool owned: Query for Applications owned by the `org_id`.
        :param datetime updated_since: query since updated
        :param bool show_status: Whether the return value should include the status for included objects. If false the query may run faster but will not include status information. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListApplicationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_applications_with_http_info(**kwargs)  # noqa: E501

    def list_applications_with_http_info(self, **kwargs):  # noqa: E501
        """Get applications  # noqa: E501

        Retrieves all applications related to the org_id. Different types of relationship may be queried by setting the appropriate flags:   - assigned: Has an Environment assigned to the organisation.   - owned: Owned by the organisation.   - maintained: Has an Environment maintained by the organisation. Any combination of the relationship flags may be set. Note that if the organisation does not own the Application, but maintains or is assigned an environment only those assignments and environments for the querying organisation will be shown.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_applications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str org_id: Organisation Unique identifier
        :param str assigned_org_id: Organisation unique identifier for an assigned object
        :param bool maintained: Query for Applications maintained by the `org_id`. These are Applications which have an Environment whose `maintenance_org_id` is the `org_id`. 
        :param bool assigned: Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. 
        :param bool owned: Query for Applications owned by the `org_id`.
        :param datetime updated_since: query since updated
        :param bool show_status: Whether the return value should include the status for included objects. If false the query may run faster but will not include status information. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListApplicationsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['org_id', 'assigned_org_id', 'maintained', 'assigned', 'owned', 'updated_since', 'show_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_applications" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'assigned_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['assigned_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `assigned_org_id` when calling `list_applications`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'assigned_org_id' in local_var_params and local_var_params['assigned_org_id'] is not None:  # noqa: E501
            query_params.append(('assigned_org_id', local_var_params['assigned_org_id']))  # noqa: E501
        if 'maintained' in local_var_params and local_var_params['maintained'] is not None:  # noqa: E501
            query_params.append(('maintained', local_var_params['maintained']))  # noqa: E501
        if 'assigned' in local_var_params and local_var_params['assigned'] is not None:  # noqa: E501
            query_params.append(('assigned', local_var_params['assigned']))  # noqa: E501
        if 'owned' in local_var_params and local_var_params['owned'] is not None:  # noqa: E501
            query_params.append(('owned', local_var_params['owned']))  # noqa: E501
        if 'updated_since' in local_var_params and local_var_params['updated_since'] is not None:  # noqa: E501
            query_params.append(('updated_since', local_var_params['updated_since']))  # noqa: E501
        if 'show_status' in local_var_params and local_var_params['show_status'] is not None:  # noqa: E501
            query_params.append(('show_status', local_var_params['show_status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListApplicationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_combined_rules(self, **kwargs):  # noqa: E501
        """List rules combined by scope or role  # noqa: E501

        Retrieve all role_to_rule_entries for an application. If assigned is true, this will list all role_to_rule_entries for applications assigned to the given org_id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_combined_rules(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str org_id: Organisation Unique identifier
        :param list[RuleScopeEnum] scopes: The scopes of the rules to search for. Multiple values are ORed together.
        :param str app_id: Application unique identifier
        :param int limit: limit the number of rows in the response
        :param bool assigned: Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListCombinedRulesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_combined_rules_with_http_info(**kwargs)  # noqa: E501

    def list_combined_rules_with_http_info(self, **kwargs):  # noqa: E501
        """List rules combined by scope or role  # noqa: E501

        Retrieve all role_to_rule_entries for an application. If assigned is true, this will list all role_to_rule_entries for applications assigned to the given org_id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_combined_rules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str org_id: Organisation Unique identifier
        :param list[RuleScopeEnum] scopes: The scopes of the rules to search for. Multiple values are ORed together.
        :param str app_id: Application unique identifier
        :param int limit: limit the number of rows in the response
        :param bool assigned: Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListCombinedRulesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['org_id', 'scopes', 'app_id', 'limit', 'assigned']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_combined_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `list_combined_rules`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_combined_rules`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_combined_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'scopes' in local_var_params and local_var_params['scopes'] is not None:  # noqa: E501
            query_params.append(('scopes', local_var_params['scopes']))  # noqa: E501
            collection_formats['scopes'] = 'multi'  # noqa: E501
        if 'app_id' in local_var_params and local_var_params['app_id'] is not None:  # noqa: E501
            query_params.append(('app_id', local_var_params['app_id']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'assigned' in local_var_params and local_var_params['assigned'] is not None:  # noqa: E501
            query_params.append(('assigned', local_var_params['assigned']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/combined_rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListCombinedRulesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_configs(self, app_id, env_name, maintenance_org_id, **kwargs):  # noqa: E501
        """Get all environment configuration  # noqa: E501

        Retrieve all environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_configs(app_id, env_name, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListConfigsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_configs_with_http_info(app_id, env_name, maintenance_org_id, **kwargs)  # noqa: E501

    def list_configs_with_http_info(self, app_id, env_name, maintenance_org_id, **kwargs):  # noqa: E501
        """Get all environment configuration  # noqa: E501

        Retrieve all environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_configs_with_http_info(app_id, env_name, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListConfigsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'maintenance_org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_configs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `list_configs`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `list_configs`")  # noqa: E501
        # verify the required parameter 'maintenance_org_id' is set
        if self.api_client.client_side_validation and ('maintenance_org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['maintenance_org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `maintenance_org_id` when calling `list_configs`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `list_configs`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `list_configs`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'maintenance_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['maintenance_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `maintenance_org_id` when calling `list_configs`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []
        if 'maintenance_org_id' in local_var_params and local_var_params['maintenance_org_id'] is not None:  # noqa: E501
            query_params.append(('maintenance_org_id', local_var_params['maintenance_org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListConfigsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_environment_configs_all_apps(self, maintenance_org_id, **kwargs):  # noqa: E501
        """Get all environment configuration for a given organisation.  # noqa: E501

        Retrieve all environment configuration for a organisation.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_environment_configs_all_apps(maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param int limit: limit the number of rows in the response
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListEnvironmentConfigsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_environment_configs_all_apps_with_http_info(maintenance_org_id, **kwargs)  # noqa: E501

    def list_environment_configs_all_apps_with_http_info(self, maintenance_org_id, **kwargs):  # noqa: E501
        """Get all environment configuration for a given organisation.  # noqa: E501

        Retrieve all environment configuration for a organisation.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_environment_configs_all_apps_with_http_info(maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param int limit: limit the number of rows in the response
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListEnvironmentConfigsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['maintenance_org_id', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_environment_configs_all_apps" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'maintenance_org_id' is set
        if self.api_client.client_side_validation and ('maintenance_org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['maintenance_org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `maintenance_org_id` when calling `list_environment_configs_all_apps`")  # noqa: E501

        if self.api_client.client_side_validation and 'maintenance_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['maintenance_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `maintenance_org_id` when calling `list_environment_configs_all_apps`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_environment_configs_all_apps`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_environment_configs_all_apps`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'maintenance_org_id' in local_var_params and local_var_params['maintenance_org_id'] is not None:  # noqa: E501
            query_params.append(('maintenance_org_id', local_var_params['maintenance_org_id']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/environment_configs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListEnvironmentConfigsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_role_to_rule_entries(self, app_id, **kwargs):  # noqa: E501
        """Get all RoleToRuleEntries  # noqa: E501

        Retrieve all role_to_rule_entries for an application   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_role_to_rule_entries(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param int limit: limit the number of rows in the response
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListRoleToRuleEntries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_role_to_rule_entries_with_http_info(app_id, **kwargs)  # noqa: E501

    def list_role_to_rule_entries_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Get all RoleToRuleEntries  # noqa: E501

        Retrieve all role_to_rule_entries for an application   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_role_to_rule_entries_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param int limit: limit the number of rows in the response
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListRoleToRuleEntries, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'org_id', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_role_to_rule_entries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `list_role_to_rule_entries`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `list_role_to_rule_entries`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_role_to_rule_entries`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_role_to_rule_entries`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/role_to_rule_entries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListRoleToRuleEntries',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_roles(self, app_id, **kwargs):  # noqa: E501
        """Get all roles  # noqa: E501

        Retrieve all roles for an application   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_roles(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param int limit: limit the number of rows in the response
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListRoles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_roles_with_http_info(app_id, **kwargs)  # noqa: E501

    def list_roles_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Get all roles  # noqa: E501

        Retrieve all roles for an application   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_roles_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param int limit: limit the number of rows in the response
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListRoles, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'org_id', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_roles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `list_roles`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `list_roles`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_roles`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_roles`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListRoles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_rules(self, app_id, **kwargs):  # noqa: E501
        """Get all rules  # noqa: E501

        Retrieve all rules for an application   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_rules(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param RuleScopeEnum scope: The scope of the rules to search for
        :param int limit: limit the number of rows in the response
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_rules_with_http_info(app_id, **kwargs)  # noqa: E501

    def list_rules_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Get all rules  # noqa: E501

        Retrieve all rules for an application   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_rules_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param RuleScopeEnum scope: The scope of the rules to search for
        :param int limit: limit the number of rows in the response
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListRules, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'org_id', 'scope', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `list_rules`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `list_rules`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_rules`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_runtime_status(self, app_id, env_name, org_id, **kwargs):  # noqa: E501
        """Get an environment's runtime status  # noqa: E501

        Get an environment's runtime status   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_runtime_status(app_id, env_name, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str org_id: Organisation unique identifier (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RuntimeStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_runtime_status_with_http_info(app_id, env_name, org_id, **kwargs)  # noqa: E501

    def list_runtime_status_with_http_info(self, app_id, env_name, org_id, **kwargs):  # noqa: E501
        """Get an environment's runtime status  # noqa: E501

        Get an environment's runtime status   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_runtime_status_with_http_info(app_id, env_name, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str org_id: Organisation unique identifier (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RuntimeStatus, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_runtime_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `list_runtime_status`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `list_runtime_status`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if self.api_client.client_side_validation and ('org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `org_id` when calling `list_runtime_status`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `list_runtime_status`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `list_runtime_status`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `org_id` when calling `list_runtime_status`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/status/runtime_status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuntimeStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_application(self, app_id, **kwargs):  # noqa: E501
        """Create or update an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_application(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param Application application:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_application_with_http_info(app_id, **kwargs)  # noqa: E501

    def replace_application_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Create or update an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_application_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param Application application:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Application, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'application']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `replace_application`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `replace_application`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'application' in local_var_params:
            body_params = local_var_params['application']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_config(self, app_id, env_name, env_config_id, environment_config, **kwargs):  # noqa: E501
        """Update environment configuration  # noqa: E501

        Update environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_config(app_id, env_name, env_config_id, environment_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param EnvironmentConfig environment_config: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_config_with_http_info(app_id, env_name, env_config_id, environment_config, **kwargs)  # noqa: E501

    def replace_config_with_http_info(self, app_id, env_name, env_config_id, environment_config, **kwargs):  # noqa: E501
        """Update environment configuration  # noqa: E501

        Update environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_config_with_http_info(app_id, env_name, env_config_id, environment_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param EnvironmentConfig environment_config: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'env_config_id', 'environment_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `replace_config`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `replace_config`")  # noqa: E501
        # verify the required parameter 'env_config_id' is set
        if self.api_client.client_side_validation and ('env_config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_config_id` when calling `replace_config`")  # noqa: E501
        # verify the required parameter 'environment_config' is set
        if self.api_client.client_side_validation and ('environment_config' not in local_var_params or  # noqa: E501
                                                        local_var_params['environment_config'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `environment_config` when calling `replace_config`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `replace_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `replace_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_config_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_config_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_config_id` when calling `replace_config`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501
        if 'env_config_id' in local_var_params:
            path_params['env_config_id'] = local_var_params['env_config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'environment_config' in local_var_params:
            body_params = local_var_params['environment_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_environment(self, app_id, env_name, **kwargs):  # noqa: E501
        """Update an environment  # noqa: E501

        This allows an environment maintainer to update the environment. Note that the maintenence_organisation in the body must match the existing one.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_environment(app_id, env_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param Environment environment:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_environment_with_http_info(app_id, env_name, **kwargs)  # noqa: E501

    def replace_environment_with_http_info(self, app_id, env_name, **kwargs):  # noqa: E501
        """Update an environment  # noqa: E501

        This allows an environment maintainer to update the environment. Note that the maintenence_organisation in the body must match the existing one.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_environment_with_http_info(app_id, env_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param Environment environment:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Environment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'environment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_environment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `replace_environment`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `replace_environment`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `replace_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `replace_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'environment' in local_var_params:
            body_params = local_var_params['environment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Environment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_role(self, app_id, role_id, **kwargs):  # noqa: E501
        """Update a role  # noqa: E501

        Updates a role with a new specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_role(app_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_id: The id of a role (required)
        :param RoleV2 role_v2:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_role_with_http_info(app_id, role_id, **kwargs)  # noqa: E501

    def replace_role_with_http_info(self, app_id, role_id, **kwargs):  # noqa: E501
        """Update a role  # noqa: E501

        Updates a role with a new specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_role_with_http_info(app_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_id: The id of a role (required)
        :param RoleV2 role_v2:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleV2, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'role_id', 'role_v2']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `replace_role`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if self.api_client.client_side_validation and ('role_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_id` when calling `replace_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `replace_role`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'role_id' in local_var_params:
            path_params['role_id'] = local_var_params['role_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'role_v2' in local_var_params:
            body_params = local_var_params['role_v2']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/roles/{role_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_role_to_rule_entry(self, app_id, role_to_rule_entry_id, **kwargs):  # noqa: E501
        """Update a role_to_rule_entry  # noqa: E501

        Updates a role_to_rule_entry with a new specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_role_to_rule_entry(app_id, role_to_rule_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_to_rule_entry_id: The id of a role to rule entry (required)
        :param RoleToRuleEntry role_to_rule_entry:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleToRuleEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_role_to_rule_entry_with_http_info(app_id, role_to_rule_entry_id, **kwargs)  # noqa: E501

    def replace_role_to_rule_entry_with_http_info(self, app_id, role_to_rule_entry_id, **kwargs):  # noqa: E501
        """Update a role_to_rule_entry  # noqa: E501

        Updates a role_to_rule_entry with a new specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_role_to_rule_entry_with_http_info(app_id, role_to_rule_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str role_to_rule_entry_id: The id of a role to rule entry (required)
        :param RoleToRuleEntry role_to_rule_entry:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleToRuleEntry, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'role_to_rule_entry_id', 'role_to_rule_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_role_to_rule_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `replace_role_to_rule_entry`")  # noqa: E501
        # verify the required parameter 'role_to_rule_entry_id' is set
        if self.api_client.client_side_validation and ('role_to_rule_entry_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_to_rule_entry_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_to_rule_entry_id` when calling `replace_role_to_rule_entry`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `replace_role_to_rule_entry`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'role_to_rule_entry_id' in local_var_params:
            path_params['role_to_rule_entry_id'] = local_var_params['role_to_rule_entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'role_to_rule_entry' in local_var_params:
            body_params = local_var_params['role_to_rule_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleToRuleEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_rule(self, app_id, rule_id, **kwargs):  # noqa: E501
        """Update a rule  # noqa: E501

        Updates a rule with a new specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_rule(app_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str rule_id: The id of a rule (required)
        :param RuleV2 rule_v2:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RuleV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_rule_with_http_info(app_id, rule_id, **kwargs)  # noqa: E501

    def replace_rule_with_http_info(self, app_id, rule_id, **kwargs):  # noqa: E501
        """Update a rule  # noqa: E501

        Updates a rule with a new specification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_rule_with_http_info(app_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str rule_id: The id of a rule (required)
        :param RuleV2 rule_v2:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RuleV2, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'rule_id', 'rule_v2']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `replace_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if self.api_client.client_side_validation and ('rule_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_id` when calling `replace_rule`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `replace_rule`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'rule_id' in local_var_params:
            path_params['rule_id'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rule_v2' in local_var_params:
            body_params = local_var_params['rule_v2']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/rules/{rule_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_runtime_status(self, app_id, env_name, runtime_status, **kwargs):  # noqa: E501
        """update an environemnt's runtime status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_runtime_status(app_id, env_name, runtime_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param RuntimeStatus runtime_status: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RuntimeStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_runtime_status_with_http_info(app_id, env_name, runtime_status, **kwargs)  # noqa: E501

    def replace_runtime_status_with_http_info(self, app_id, env_name, runtime_status, **kwargs):  # noqa: E501
        """update an environemnt's runtime status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_runtime_status_with_http_info(app_id, env_name, runtime_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param RuntimeStatus runtime_status: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RuntimeStatus, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'runtime_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_runtime_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `replace_runtime_status`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `replace_runtime_status`")  # noqa: E501
        # verify the required parameter 'runtime_status' is set
        if self.api_client.client_side_validation and ('runtime_status' not in local_var_params or  # noqa: E501
                                                        local_var_params['runtime_status'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `runtime_status` when calling `replace_runtime_status`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `replace_runtime_status`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `replace_runtime_status`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'runtime_status' in local_var_params:
            body_params = local_var_params['runtime_status']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/status/runtime_status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuntimeStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
