# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.08.05
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from agilicus_api.api_client import ApiClient
from agilicus_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CataloguesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_catalogue(self, catalogue, **kwargs):  # noqa: E501
        """create a catalogue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_catalogue(catalogue, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Catalogue catalogue: Catalogue (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Catalogue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_catalogue_with_http_info(catalogue, **kwargs)  # noqa: E501

    def create_catalogue_with_http_info(self, catalogue, **kwargs):  # noqa: E501
        """create a catalogue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_catalogue_with_http_info(catalogue, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Catalogue catalogue: Catalogue (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Catalogue, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_catalogue" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue' is set
        if self.api_client.client_side_validation and ('catalogue' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue` when calling `create_catalogue`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'catalogue' in local_var_params:
            body_params = local_var_params['catalogue']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Catalogue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_catalogue_entry(self, catalogue_id, catalogue_entry, **kwargs):  # noqa: E501
        """create a catalogue entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_catalogue_entry(catalogue_id, catalogue_entry, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param CatalogueEntry catalogue_entry: CatalogueEntry (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CatalogueEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_catalogue_entry_with_http_info(catalogue_id, catalogue_entry, **kwargs)  # noqa: E501

    def create_catalogue_entry_with_http_info(self, catalogue_id, catalogue_entry, **kwargs):  # noqa: E501
        """create a catalogue entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_catalogue_entry_with_http_info(catalogue_id, catalogue_entry, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param CatalogueEntry catalogue_entry: CatalogueEntry (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CatalogueEntry, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue_id', 'catalogue_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_catalogue_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue_id' is set
        if self.api_client.client_side_validation and ('catalogue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_id` when calling `create_catalogue_entry`")  # noqa: E501
        # verify the required parameter 'catalogue_entry' is set
        if self.api_client.client_side_validation and ('catalogue_entry' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_entry'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_entry` when calling `create_catalogue_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalogue_id' in local_var_params:
            path_params['catalogue_id'] = local_var_params['catalogue_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'catalogue_entry' in local_var_params:
            body_params = local_var_params['catalogue_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues/{catalogue_id}/catalogue_entries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogueEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_catalogue(self, catalogue_id, **kwargs):  # noqa: E501
        """Delete the catalogue specified by catalogue_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_catalogue(catalogue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_catalogue_with_http_info(catalogue_id, **kwargs)  # noqa: E501

    def delete_catalogue_with_http_info(self, catalogue_id, **kwargs):  # noqa: E501
        """Delete the catalogue specified by catalogue_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_catalogue_with_http_info(catalogue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_catalogue" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue_id' is set
        if self.api_client.client_side_validation and ('catalogue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_id` when calling `delete_catalogue`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalogue_id' in local_var_params:
            path_params['catalogue_id'] = local_var_params['catalogue_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues/{catalogue_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_catalogue_entry(self, catalogue_id, catalogue_entry_id, **kwargs):  # noqa: E501
        """Delete the catalogue specified by catalogue_entry_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_catalogue_entry(catalogue_id, catalogue_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param str catalogue_entry_id: catalogue_entry_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_catalogue_entry_with_http_info(catalogue_id, catalogue_entry_id, **kwargs)  # noqa: E501

    def delete_catalogue_entry_with_http_info(self, catalogue_id, catalogue_entry_id, **kwargs):  # noqa: E501
        """Delete the catalogue specified by catalogue_entry_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_catalogue_entry_with_http_info(catalogue_id, catalogue_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param str catalogue_entry_id: catalogue_entry_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue_id', 'catalogue_entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_catalogue_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue_id' is set
        if self.api_client.client_side_validation and ('catalogue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_id` when calling `delete_catalogue_entry`")  # noqa: E501
        # verify the required parameter 'catalogue_entry_id' is set
        if self.api_client.client_side_validation and ('catalogue_entry_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_entry_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_entry_id` when calling `delete_catalogue_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalogue_id' in local_var_params:
            path_params['catalogue_id'] = local_var_params['catalogue_id']  # noqa: E501
        if 'catalogue_entry_id' in local_var_params:
            path_params['catalogue_entry_id'] = local_var_params['catalogue_entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_catalogue(self, catalogue_id, **kwargs):  # noqa: E501
        """Get the catalogue specified by catalogue_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_catalogue(catalogue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Catalogue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_catalogue_with_http_info(catalogue_id, **kwargs)  # noqa: E501

    def get_catalogue_with_http_info(self, catalogue_id, **kwargs):  # noqa: E501
        """Get the catalogue specified by catalogue_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_catalogue_with_http_info(catalogue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Catalogue, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_catalogue" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue_id' is set
        if self.api_client.client_side_validation and ('catalogue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_id` when calling `get_catalogue`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalogue_id' in local_var_params:
            path_params['catalogue_id'] = local_var_params['catalogue_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues/{catalogue_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Catalogue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_catalogue_entry(self, catalogue_id, catalogue_entry_id, **kwargs):  # noqa: E501
        """Get the catalogue entry by id for the given catalogue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_catalogue_entry(catalogue_id, catalogue_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param str catalogue_entry_id: catalogue_entry_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CatalogueEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_catalogue_entry_with_http_info(catalogue_id, catalogue_entry_id, **kwargs)  # noqa: E501

    def get_catalogue_entry_with_http_info(self, catalogue_id, catalogue_entry_id, **kwargs):  # noqa: E501
        """Get the catalogue entry by id for the given catalogue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_catalogue_entry_with_http_info(catalogue_id, catalogue_entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param str catalogue_entry_id: catalogue_entry_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CatalogueEntry, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue_id', 'catalogue_entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_catalogue_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue_id' is set
        if self.api_client.client_side_validation and ('catalogue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_id` when calling `get_catalogue_entry`")  # noqa: E501
        # verify the required parameter 'catalogue_entry_id' is set
        if self.api_client.client_side_validation and ('catalogue_entry_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_entry_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_entry_id` when calling `get_catalogue_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalogue_id' in local_var_params:
            path_params['catalogue_id'] = local_var_params['catalogue_id']  # noqa: E501
        if 'catalogue_entry_id' in local_var_params:
            path_params['catalogue_entry_id'] = local_var_params['catalogue_entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogueEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_all_catalogue_entries(self, **kwargs):  # noqa: E501
        """List all catalogue entries independant of the catalogue they belong to  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_catalogue_entries(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str catalogue_entry_name: Query based on a catalogue entries name
        :param str catalogue_category: Query based on a catalogue's category
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListCatalogueEntriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_all_catalogue_entries_with_http_info(**kwargs)  # noqa: E501

    def list_all_catalogue_entries_with_http_info(self, **kwargs):  # noqa: E501
        """List all catalogue entries independant of the catalogue they belong to  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_catalogue_entries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str catalogue_entry_name: Query based on a catalogue entries name
        :param str catalogue_category: Query based on a catalogue's category
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListCatalogueEntriesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['limit', 'catalogue_entry_name', 'catalogue_category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_catalogue_entries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_all_catalogue_entries`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_all_catalogue_entries`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'catalogue_entry_name' in local_var_params and local_var_params['catalogue_entry_name'] is not None:  # noqa: E501
            query_params.append(('catalogue_entry_name', local_var_params['catalogue_entry_name']))  # noqa: E501
        if 'catalogue_category' in local_var_params and local_var_params['catalogue_category'] is not None:  # noqa: E501
            query_params.append(('catalogue_category', local_var_params['catalogue_category']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogue_entries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListCatalogueEntriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_catalogue_entries(self, catalogue_id, **kwargs):  # noqa: E501
        """List catalogue entries in the catalogue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_catalogue_entries(catalogue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param int limit: limit the number of rows in the response
        :param str catalogue_entry_name: Query based on a catalogue entries name
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListCatalogueEntriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_catalogue_entries_with_http_info(catalogue_id, **kwargs)  # noqa: E501

    def list_catalogue_entries_with_http_info(self, catalogue_id, **kwargs):  # noqa: E501
        """List catalogue entries in the catalogue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_catalogue_entries_with_http_info(catalogue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param int limit: limit the number of rows in the response
        :param str catalogue_entry_name: Query based on a catalogue entries name
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListCatalogueEntriesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue_id', 'limit', 'catalogue_entry_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_catalogue_entries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue_id' is set
        if self.api_client.client_side_validation and ('catalogue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_id` when calling `list_catalogue_entries`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_catalogue_entries`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_catalogue_entries`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'catalogue_id' in local_var_params:
            path_params['catalogue_id'] = local_var_params['catalogue_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'catalogue_entry_name' in local_var_params and local_var_params['catalogue_entry_name'] is not None:  # noqa: E501
            query_params.append(('catalogue_entry_name', local_var_params['catalogue_entry_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues/{catalogue_id}/catalogue_entries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListCatalogueEntriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_catalogues(self, **kwargs):  # noqa: E501
        """List all catalogues  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_catalogues(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str catalogue_category: Query based on a catalogue's category
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListCataloguesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_catalogues_with_http_info(**kwargs)  # noqa: E501

    def list_catalogues_with_http_info(self, **kwargs):  # noqa: E501
        """List all catalogues  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_catalogues_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str catalogue_category: Query based on a catalogue's category
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListCataloguesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['limit', 'catalogue_category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_catalogues" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_catalogues`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_catalogues`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'catalogue_category' in local_var_params and local_var_params['catalogue_category'] is not None:  # noqa: E501
            query_params.append(('catalogue_category', local_var_params['catalogue_category']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListCataloguesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_catalogue(self, catalogue_id, catalogue, **kwargs):  # noqa: E501
        """Replace the catalogue specified by catalogue_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_catalogue(catalogue_id, catalogue, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param Catalogue catalogue: Catalogue (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Catalogue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_catalogue_with_http_info(catalogue_id, catalogue, **kwargs)  # noqa: E501

    def replace_catalogue_with_http_info(self, catalogue_id, catalogue, **kwargs):  # noqa: E501
        """Replace the catalogue specified by catalogue_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_catalogue_with_http_info(catalogue_id, catalogue, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param Catalogue catalogue: Catalogue (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Catalogue, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue_id', 'catalogue']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_catalogue" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue_id' is set
        if self.api_client.client_side_validation and ('catalogue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_id` when calling `replace_catalogue`")  # noqa: E501
        # verify the required parameter 'catalogue' is set
        if self.api_client.client_side_validation and ('catalogue' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue` when calling `replace_catalogue`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalogue_id' in local_var_params:
            path_params['catalogue_id'] = local_var_params['catalogue_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'catalogue' in local_var_params:
            body_params = local_var_params['catalogue']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues/{catalogue_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Catalogue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_catalogue_entry(self, catalogue_id, catalogue_entry_id, catalogue_entry, **kwargs):  # noqa: E501
        """Replace the catalogue entry specified by catalogue_entry_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_catalogue_entry(catalogue_id, catalogue_entry_id, catalogue_entry, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param str catalogue_entry_id: catalogue_entry_id path (required)
        :param CatalogueEntry catalogue_entry: CatalogueEntry (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CatalogueEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_catalogue_entry_with_http_info(catalogue_id, catalogue_entry_id, catalogue_entry, **kwargs)  # noqa: E501

    def replace_catalogue_entry_with_http_info(self, catalogue_id, catalogue_entry_id, catalogue_entry, **kwargs):  # noqa: E501
        """Replace the catalogue entry specified by catalogue_entry_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_catalogue_entry_with_http_info(catalogue_id, catalogue_entry_id, catalogue_entry, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str catalogue_id: catalogue_id path (required)
        :param str catalogue_entry_id: catalogue_entry_id path (required)
        :param CatalogueEntry catalogue_entry: CatalogueEntry (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CatalogueEntry, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['catalogue_id', 'catalogue_entry_id', 'catalogue_entry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_catalogue_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'catalogue_id' is set
        if self.api_client.client_side_validation and ('catalogue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_id` when calling `replace_catalogue_entry`")  # noqa: E501
        # verify the required parameter 'catalogue_entry_id' is set
        if self.api_client.client_side_validation and ('catalogue_entry_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_entry_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_entry_id` when calling `replace_catalogue_entry`")  # noqa: E501
        # verify the required parameter 'catalogue_entry' is set
        if self.api_client.client_side_validation and ('catalogue_entry' not in local_var_params or  # noqa: E501
                                                        local_var_params['catalogue_entry'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `catalogue_entry` when calling `replace_catalogue_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'catalogue_id' in local_var_params:
            path_params['catalogue_id'] = local_var_params['catalogue_id']  # noqa: E501
        if 'catalogue_entry_id' in local_var_params:
            path_params['catalogue_entry_id'] = local_var_params['catalogue_entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'catalogue_entry' in local_var_params:
            body_params = local_var_params['catalogue_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogueEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
