# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.08.05
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from agilicus_api.api_client import ApiClient
from agilicus_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ChallengesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_challenge(self, challenge, **kwargs):  # noqa: E501
        """create a challenge  # noqa: E501

        Creates a challenge according to the provide specification. This challenge will persist for a period of time waiting for the challenge to be passed. It will eventually time out.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_challenge(challenge, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Challenge challenge: The challenge to create (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Challenge
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_challenge_with_http_info(challenge, **kwargs)  # noqa: E501

    def create_challenge_with_http_info(self, challenge, **kwargs):  # noqa: E501
        """create a challenge  # noqa: E501

        Creates a challenge according to the provide specification. This challenge will persist for a period of time waiting for the challenge to be passed. It will eventually time out.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_challenge_with_http_info(challenge, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Challenge challenge: The challenge to create (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Challenge, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['challenge']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_challenge" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'challenge' is set
        if self.api_client.client_side_validation and ('challenge' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge` when calling `create_challenge`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'challenge' in local_var_params:
            body_params = local_var_params['challenge']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenges', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Challenge',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_totp_enrollment(self, totp_enrollment, **kwargs):  # noqa: E501
        """create a TOTP challenge enrollment  # noqa: E501

        Creates a TOTP challenge enrollment. The returned body will contain the key the user needs to enroll in their application. The enrollment is not complete until the user provides a valid answer.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_totp_enrollment(totp_enrollment, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TOTPEnrollment totp_enrollment: The TOTP challenge enrollment to create. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TOTPEnrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_totp_enrollment_with_http_info(totp_enrollment, **kwargs)  # noqa: E501

    def create_totp_enrollment_with_http_info(self, totp_enrollment, **kwargs):  # noqa: E501
        """create a TOTP challenge enrollment  # noqa: E501

        Creates a TOTP challenge enrollment. The returned body will contain the key the user needs to enroll in their application. The enrollment is not complete until the user provides a valid answer.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_totp_enrollment_with_http_info(totp_enrollment, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TOTPEnrollment totp_enrollment: The TOTP challenge enrollment to create. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TOTPEnrollment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['totp_enrollment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_totp_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'totp_enrollment' is set
        if self.api_client.client_side_validation and ('totp_enrollment' not in local_var_params or  # noqa: E501
                                                        local_var_params['totp_enrollment'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `totp_enrollment` when calling `create_totp_enrollment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'totp_enrollment' in local_var_params:
            body_params = local_var_params['totp_enrollment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/totp', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TOTPEnrollment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_webauthn_enrollment(self, web_auth_n_enrollment, **kwargs):  # noqa: E501
        """create a WebAuthN challenge enrollment  # noqa: E501

        Initiates a WebAuthN challenge enrollment. The enrollment is not complete until the user provides a valid answer.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webauthn_enrollment(web_auth_n_enrollment, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WebAuthNEnrollment web_auth_n_enrollment: The WebAuthN challenge enrollment to create. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WebAuthNEnrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_webauthn_enrollment_with_http_info(web_auth_n_enrollment, **kwargs)  # noqa: E501

    def create_webauthn_enrollment_with_http_info(self, web_auth_n_enrollment, **kwargs):  # noqa: E501
        """create a WebAuthN challenge enrollment  # noqa: E501

        Initiates a WebAuthN challenge enrollment. The enrollment is not complete until the user provides a valid answer.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webauthn_enrollment_with_http_info(web_auth_n_enrollment, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WebAuthNEnrollment web_auth_n_enrollment: The WebAuthN challenge enrollment to create. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WebAuthNEnrollment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['web_auth_n_enrollment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_webauthn_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'web_auth_n_enrollment' is set
        if self.api_client.client_side_validation and ('web_auth_n_enrollment' not in local_var_params or  # noqa: E501
                                                        local_var_params['web_auth_n_enrollment'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `web_auth_n_enrollment` when calling `create_webauthn_enrollment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'web_auth_n_enrollment' in local_var_params:
            body_params = local_var_params['web_auth_n_enrollment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/webauthn', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebAuthNEnrollment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_challenge(self, challenge_id, **kwargs):  # noqa: E501
        """Delete the challenge specified by challenge_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_challenge(challenge_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str challenge_id: A challenge id found in a path. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_challenge_with_http_info(challenge_id, **kwargs)  # noqa: E501

    def delete_challenge_with_http_info(self, challenge_id, **kwargs):  # noqa: E501
        """Delete the challenge specified by challenge_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_challenge_with_http_info(challenge_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str challenge_id: A challenge id found in a path. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['challenge_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_challenge" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'challenge_id' is set
        if self.api_client.client_side_validation and ('challenge_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge_id` when calling `delete_challenge`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'challenge_id' in local_var_params:
            path_params['challenge_id'] = local_var_params['challenge_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenges/{challenge_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_totp_enrollment(self, totp_id, **kwargs):  # noqa: E501
        """Delete the TOTP enrollment specified by totp id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_totp_enrollment(totp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str totp_id: A totp id found in a path. (required)
        :param str user_id: Query based on user id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_totp_enrollment_with_http_info(totp_id, **kwargs)  # noqa: E501

    def delete_totp_enrollment_with_http_info(self, totp_id, **kwargs):  # noqa: E501
        """Delete the TOTP enrollment specified by totp id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_totp_enrollment_with_http_info(totp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str totp_id: A totp id found in a path. (required)
        :param str user_id: Query based on user id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['totp_id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_totp_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'totp_id' is set
        if self.api_client.client_side_validation and ('totp_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['totp_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `totp_id` when calling `delete_totp_enrollment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'totp_id' in local_var_params:
            path_params['totp_id'] = local_var_params['totp_id']  # noqa: E501

        query_params = []
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/totp/{totp_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_webauthn_enrollment(self, webauthn_id, **kwargs):  # noqa: E501
        """Delete the WebAuthN enrollment specified by webauthn_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webauthn_enrollment(webauthn_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str webauthn_id: A webauthn id found in a path. (required)
        :param str user_id: Query based on user id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_webauthn_enrollment_with_http_info(webauthn_id, **kwargs)  # noqa: E501

    def delete_webauthn_enrollment_with_http_info(self, webauthn_id, **kwargs):  # noqa: E501
        """Delete the WebAuthN enrollment specified by webauthn_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webauthn_enrollment_with_http_info(webauthn_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str webauthn_id: A webauthn id found in a path. (required)
        :param str user_id: Query based on user id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['webauthn_id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webauthn_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'webauthn_id' is set
        if self.api_client.client_side_validation and ('webauthn_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['webauthn_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `webauthn_id` when calling `delete_webauthn_enrollment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webauthn_id' in local_var_params:
            path_params['webauthn_id'] = local_var_params['webauthn_id']  # noqa: E501

        query_params = []
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/webauthn/{webauthn_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_answer(self, challenge_id, challenge_answer, challenge_uid, allowed, challenge_type, **kwargs):  # noqa: E501
        """answer a challenge  # noqa: E501

        Checks whether the challenge answer is correct. If the challenge is not accepting answers, or the anwer is incorrect, a failure will be returned. Otherwise, the challenge will be considered answered and the user can log in.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_answer(challenge_id, challenge_answer, challenge_uid, allowed, challenge_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str challenge_id: A challenge id found in a path. (required)
        :param str challenge_answer: The answer for the challenge (required)
        :param str challenge_uid: The user id for the challenge (required)
        :param bool allowed: Whether the challenge was allowed. If true, then the user can proceed with the login. If false, then the user will be denied their login attempt. Set this to false if the login attempt was not desired.  (required)
        :param str challenge_type: challenge method type query (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChallengeAnswer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_answer_with_http_info(challenge_id, challenge_answer, challenge_uid, allowed, challenge_type, **kwargs)  # noqa: E501

    def get_answer_with_http_info(self, challenge_id, challenge_answer, challenge_uid, allowed, challenge_type, **kwargs):  # noqa: E501
        """answer a challenge  # noqa: E501

        Checks whether the challenge answer is correct. If the challenge is not accepting answers, or the anwer is incorrect, a failure will be returned. Otherwise, the challenge will be considered answered and the user can log in.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_answer_with_http_info(challenge_id, challenge_answer, challenge_uid, allowed, challenge_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str challenge_id: A challenge id found in a path. (required)
        :param str challenge_answer: The answer for the challenge (required)
        :param str challenge_uid: The user id for the challenge (required)
        :param bool allowed: Whether the challenge was allowed. If true, then the user can proceed with the login. If false, then the user will be denied their login attempt. Set this to false if the login attempt was not desired.  (required)
        :param str challenge_type: challenge method type query (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChallengeAnswer, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['challenge_id', 'challenge_answer', 'challenge_uid', 'allowed', 'challenge_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_answer" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'challenge_id' is set
        if self.api_client.client_side_validation and ('challenge_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge_id` when calling `get_answer`")  # noqa: E501
        # verify the required parameter 'challenge_answer' is set
        if self.api_client.client_side_validation and ('challenge_answer' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge_answer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge_answer` when calling `get_answer`")  # noqa: E501
        # verify the required parameter 'challenge_uid' is set
        if self.api_client.client_side_validation and ('challenge_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge_uid` when calling `get_answer`")  # noqa: E501
        # verify the required parameter 'allowed' is set
        if self.api_client.client_side_validation and ('allowed' not in local_var_params or  # noqa: E501
                                                        local_var_params['allowed'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `allowed` when calling `get_answer`")  # noqa: E501
        # verify the required parameter 'challenge_type' is set
        if self.api_client.client_side_validation and ('challenge_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge_type` when calling `get_answer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'challenge_id' in local_var_params:
            path_params['challenge_id'] = local_var_params['challenge_id']  # noqa: E501

        query_params = []
        if 'challenge_answer' in local_var_params and local_var_params['challenge_answer'] is not None:  # noqa: E501
            query_params.append(('challenge_answer', local_var_params['challenge_answer']))  # noqa: E501
        if 'challenge_uid' in local_var_params and local_var_params['challenge_uid'] is not None:  # noqa: E501
            query_params.append(('challenge_uid', local_var_params['challenge_uid']))  # noqa: E501
        if 'allowed' in local_var_params and local_var_params['allowed'] is not None:  # noqa: E501
            query_params.append(('allowed', local_var_params['allowed']))  # noqa: E501
        if 'challenge_type' in local_var_params and local_var_params['challenge_type'] is not None:  # noqa: E501
            query_params.append(('challenge_type', local_var_params['challenge_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenges/{challenge_id}/answers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChallengeAnswer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_challenge(self, challenge_id, **kwargs):  # noqa: E501
        """Get the challenge specified by challenge_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_challenge(challenge_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str challenge_id: A challenge id found in a path. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Challenge
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_challenge_with_http_info(challenge_id, **kwargs)  # noqa: E501

    def get_challenge_with_http_info(self, challenge_id, **kwargs):  # noqa: E501
        """Get the challenge specified by challenge_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_challenge_with_http_info(challenge_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str challenge_id: A challenge id found in a path. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Challenge, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['challenge_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_challenge" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'challenge_id' is set
        if self.api_client.client_side_validation and ('challenge_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge_id` when calling `get_challenge`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'challenge_id' in local_var_params:
            path_params['challenge_id'] = local_var_params['challenge_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenges/{challenge_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Challenge',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_totp_enrollment(self, totp_id, **kwargs):  # noqa: E501
        """Get the TOTP enrollment specified by totp_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_totp_enrollment(totp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str totp_id: A totp id found in a path. (required)
        :param str user_id: Query based on user id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TOTPEnrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_totp_enrollment_with_http_info(totp_id, **kwargs)  # noqa: E501

    def get_totp_enrollment_with_http_info(self, totp_id, **kwargs):  # noqa: E501
        """Get the TOTP enrollment specified by totp_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_totp_enrollment_with_http_info(totp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str totp_id: A totp id found in a path. (required)
        :param str user_id: Query based on user id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TOTPEnrollment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['totp_id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_totp_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'totp_id' is set
        if self.api_client.client_side_validation and ('totp_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['totp_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `totp_id` when calling `get_totp_enrollment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'totp_id' in local_var_params:
            path_params['totp_id'] = local_var_params['totp_id']  # noqa: E501

        query_params = []
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/totp/{totp_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TOTPEnrollment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webauthn_enrollment(self, webauthn_id, **kwargs):  # noqa: E501
        """Get the WebAuthN enrollment specified by webauthn_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webauthn_enrollment(webauthn_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str webauthn_id: A webauthn id found in a path. (required)
        :param str user_id: Query based on user id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WebAuthNEnrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_webauthn_enrollment_with_http_info(webauthn_id, **kwargs)  # noqa: E501

    def get_webauthn_enrollment_with_http_info(self, webauthn_id, **kwargs):  # noqa: E501
        """Get the WebAuthN enrollment specified by webauthn_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webauthn_enrollment_with_http_info(webauthn_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str webauthn_id: A webauthn id found in a path. (required)
        :param str user_id: Query based on user id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WebAuthNEnrollment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['webauthn_id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webauthn_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'webauthn_id' is set
        if self.api_client.client_side_validation and ('webauthn_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['webauthn_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `webauthn_id` when calling `get_webauthn_enrollment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webauthn_id' in local_var_params:
            path_params['webauthn_id'] = local_var_params['webauthn_id']  # noqa: E501

        query_params = []
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/webauthn/{webauthn_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebAuthNEnrollment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_totp_enrollment(self, **kwargs):  # noqa: E501
        """List the totp enrollment results  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_totp_enrollment(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str user_id: Query based on user id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListTOTPEnrollmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_totp_enrollment_with_http_info(**kwargs)  # noqa: E501

    def list_totp_enrollment_with_http_info(self, **kwargs):  # noqa: E501
        """List the totp enrollment results  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_totp_enrollment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str user_id: Query based on user id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListTOTPEnrollmentResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['limit', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_totp_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_totp_enrollment`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_totp_enrollment`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/totp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListTOTPEnrollmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_webauthn_enrollments(self, **kwargs):  # noqa: E501
        """List the webauthn enrollments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_webauthn_enrollments(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str user_id: Query based on user id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListWebAuthNEnrollmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_webauthn_enrollments_with_http_info(**kwargs)  # noqa: E501

    def list_webauthn_enrollments_with_http_info(self, **kwargs):  # noqa: E501
        """List the webauthn enrollments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_webauthn_enrollments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str user_id: Query based on user id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListWebAuthNEnrollmentResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['limit', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_webauthn_enrollments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_webauthn_enrollments`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_webauthn_enrollments`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/webauthn', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListWebAuthNEnrollmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_challenge(self, challenge_id, challenge, **kwargs):  # noqa: E501
        """Replace the challenge specified by challenge_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_challenge(challenge_id, challenge, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str challenge_id: A challenge id found in a path. (required)
        :param Challenge challenge: The challenge to replace. Note that some fields, such as user_id, cannot be modified. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Challenge
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_challenge_with_http_info(challenge_id, challenge, **kwargs)  # noqa: E501

    def replace_challenge_with_http_info(self, challenge_id, challenge, **kwargs):  # noqa: E501
        """Replace the challenge specified by challenge_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_challenge_with_http_info(challenge_id, challenge, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str challenge_id: A challenge id found in a path. (required)
        :param Challenge challenge: The challenge to replace. Note that some fields, such as user_id, cannot be modified. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Challenge, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['challenge_id', 'challenge']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_challenge" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'challenge_id' is set
        if self.api_client.client_side_validation and ('challenge_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge_id` when calling `replace_challenge`")  # noqa: E501
        # verify the required parameter 'challenge' is set
        if self.api_client.client_side_validation and ('challenge' not in local_var_params or  # noqa: E501
                                                        local_var_params['challenge'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `challenge` when calling `replace_challenge`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'challenge_id' in local_var_params:
            path_params['challenge_id'] = local_var_params['challenge_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'challenge' in local_var_params:
            body_params = local_var_params['challenge']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenges/{challenge_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Challenge',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_totp_enrollment(self, totp_id, totp_enrollment_answer, **kwargs):  # noqa: E501
        """Update the totp_enrollment if the answer provided is correct. This moves the state from pending to success.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_totp_enrollment(totp_id, totp_enrollment_answer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str totp_id: A totp id found in a path. (required)
        :param TOTPEnrollmentAnswer totp_enrollment_answer: The answer to the TOTP enrollment specified by totp_id. (required)
        :param str user_id: Query based on user id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TOTPEnrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_totp_enrollment_with_http_info(totp_id, totp_enrollment_answer, **kwargs)  # noqa: E501

    def update_totp_enrollment_with_http_info(self, totp_id, totp_enrollment_answer, **kwargs):  # noqa: E501
        """Update the totp_enrollment if the answer provided is correct. This moves the state from pending to success.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_totp_enrollment_with_http_info(totp_id, totp_enrollment_answer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str totp_id: A totp id found in a path. (required)
        :param TOTPEnrollmentAnswer totp_enrollment_answer: The answer to the TOTP enrollment specified by totp_id. (required)
        :param str user_id: Query based on user id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TOTPEnrollment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['totp_id', 'totp_enrollment_answer', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_totp_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'totp_id' is set
        if self.api_client.client_side_validation and ('totp_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['totp_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `totp_id` when calling `update_totp_enrollment`")  # noqa: E501
        # verify the required parameter 'totp_enrollment_answer' is set
        if self.api_client.client_side_validation and ('totp_enrollment_answer' not in local_var_params or  # noqa: E501
                                                        local_var_params['totp_enrollment_answer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `totp_enrollment_answer` when calling `update_totp_enrollment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'totp_id' in local_var_params:
            path_params['totp_id'] = local_var_params['totp_id']  # noqa: E501

        query_params = []
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'totp_enrollment_answer' in local_var_params:
            body_params = local_var_params['totp_enrollment_answer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/totp/{totp_id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TOTPEnrollment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_webauthn_enrollment(self, webauthn_id, web_auth_n_enrollment_answer, **kwargs):  # noqa: E501
        """Update the WebAuthN enrollment if the answer provided is correct. This completes the device enrollment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webauthn_enrollment(webauthn_id, web_auth_n_enrollment_answer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str webauthn_id: A webauthn id found in a path. (required)
        :param WebAuthNEnrollmentAnswer web_auth_n_enrollment_answer: The answer to the WebAuthN enrollment specified by webauthn_id. (required)
        :param str user_id: Query based on user id
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WebAuthNEnrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_webauthn_enrollment_with_http_info(webauthn_id, web_auth_n_enrollment_answer, **kwargs)  # noqa: E501

    def update_webauthn_enrollment_with_http_info(self, webauthn_id, web_auth_n_enrollment_answer, **kwargs):  # noqa: E501
        """Update the WebAuthN enrollment if the answer provided is correct. This completes the device enrollment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webauthn_enrollment_with_http_info(webauthn_id, web_auth_n_enrollment_answer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str webauthn_id: A webauthn id found in a path. (required)
        :param WebAuthNEnrollmentAnswer web_auth_n_enrollment_answer: The answer to the WebAuthN enrollment specified by webauthn_id. (required)
        :param str user_id: Query based on user id
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WebAuthNEnrollment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['webauthn_id', 'web_auth_n_enrollment_answer', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_webauthn_enrollment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'webauthn_id' is set
        if self.api_client.client_side_validation and ('webauthn_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['webauthn_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `webauthn_id` when calling `update_webauthn_enrollment`")  # noqa: E501
        # verify the required parameter 'web_auth_n_enrollment_answer' is set
        if self.api_client.client_side_validation and ('web_auth_n_enrollment_answer' not in local_var_params or  # noqa: E501
                                                        local_var_params['web_auth_n_enrollment_answer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `web_auth_n_enrollment_answer` when calling `update_webauthn_enrollment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webauthn_id' in local_var_params:
            path_params['webauthn_id'] = local_var_params['webauthn_id']  # noqa: E501

        query_params = []
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'web_auth_n_enrollment_answer' in local_var_params:
            body_params = local_var_params['web_auth_n_enrollment_answer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/challenge_enrollment/webauthn/{webauthn_id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebAuthNEnrollment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
