# agilicus_api.UsersApi

All URIs are relative to *https://api.agilicus.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_challenge_method**](UsersApi.md#create_challenge_method) | **POST** /users/{user_id}/mfa_challenge_methods | Create a multi-factor authentication method
[**create_upstream_user_identity**](UsersApi.md#create_upstream_user_identity) | **POST** /users/{user_id}/upstream_user_identities | Create an upstream user identity
[**create_user**](UsersApi.md#create_user) | **POST** /users | Create a user
[**create_user_identity_update**](UsersApi.md#create_user_identity_update) | **POST** /users/{user_id}/user_identity_updates | Update a user&#39;s core identity information.
[**delete_challenge_method**](UsersApi.md#delete_challenge_method) | **DELETE** /users/{user_id}/mfa_challenge_methods/{challenge_method_id} | Delete a user&#39;s multi-factor authentication challenge method
[**delete_upstream_user_identity**](UsersApi.md#delete_upstream_user_identity) | **DELETE** /users/{user_id}/upstream_user_identities/{upstream_user_identity_id} | Delete an upstream user identity
[**delete_user**](UsersApi.md#delete_user) | **DELETE** /v1/orgs/{org_id}/users/{user_id} | Remove a user from an organisation
[**get_challenge_method**](UsersApi.md#get_challenge_method) | **GET** /users/{user_id}/mfa_challenge_methods/{challenge_method_id} | Get a single challenge method for the given user
[**get_upstream_user_identity**](UsersApi.md#get_upstream_user_identity) | **GET** /users/{user_id}/upstream_user_identities/{upstream_user_identity_id} | Get a single upstream user identity
[**get_user**](UsersApi.md#get_user) | **GET** /users/{user_id} | Get a single user
[**list_all_user_orgs**](UsersApi.md#list_all_user_orgs) | **GET** /users/{user_id}/orgs | Return all organisations a user has been assigned to
[**list_all_user_roles**](UsersApi.md#list_all_user_roles) | **GET** /users/{user_id}/render_roles | Return all roles for a user
[**list_challenge_methods**](UsersApi.md#list_challenge_methods) | **GET** /users/{user_id}/mfa_challenge_methods | Get all of a user&#39;s multi-factor authentication challenge method configuration
[**list_combined_user_details**](UsersApi.md#list_combined_user_details) | **GET** /v1/combined_user_details | Get all combined details about users
[**list_upstream_user_identities**](UsersApi.md#list_upstream_user_identities) | **GET** /users/{user_id}/upstream_user_identities | Get all of a user&#39;s upstream user identities
[**list_user_guids**](UsersApi.md#list_user_guids) | **GET** /users_ids | Get a list of all user GUIDs
[**list_user_permissions**](UsersApi.md#list_user_permissions) | **GET** /users/{user_id}/host_permissions | Return the user&#39;s host permissions
[**list_users**](UsersApi.md#list_users) | **GET** /users | Get all users
[**replace_challenge_method**](UsersApi.md#replace_challenge_method) | **PUT** /users/{user_id}/mfa_challenge_methods/{challenge_method_id} | Update a user&#39;s multi-factor authentication challenge method
[**replace_upstream_user_identity**](UsersApi.md#replace_upstream_user_identity) | **PUT** /users/{user_id}/upstream_user_identities/{upstream_user_identity_id} | Update an upstream user identity
[**replace_user**](UsersApi.md#replace_user) | **PUT** /users/{user_id} | Create or update a user
[**replace_user_role**](UsersApi.md#replace_user_role) | **PUT** /users/{user_id}/roles | Create or update a user role
[**reset_user_mfa_challenge_methods**](UsersApi.md#reset_user_mfa_challenge_methods) | **POST** /users/{user_id}/reset_mfa_challenge_methods | Resets a user&#39;s multi-factor authentication method


# **create_challenge_method**
> MFAChallengeMethod create_challenge_method(user_id, mfa_challenge_method)

Create a multi-factor authentication method

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
mfa_challenge_method = agilicus_api.MFAChallengeMethod() # MFAChallengeMethod | 

    try:
        # Create a multi-factor authentication method
        api_response = api_instance.create_challenge_method(user_id, mfa_challenge_method)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->create_challenge_method: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **mfa_challenge_method** | [**MFAChallengeMethod**](MFAChallengeMethod.md)|  | 

### Return type

[**MFAChallengeMethod**](MFAChallengeMethod.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | New authentication methods created |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_upstream_user_identity**
> UpstreamUserIdentity create_upstream_user_identity(user_id, upstream_user_identity)

Create an upstream user identity

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
upstream_user_identity = agilicus_api.UpstreamUserIdentity() # UpstreamUserIdentity | 

    try:
        # Create an upstream user identity
        api_response = api_instance.create_upstream_user_identity(user_id, upstream_user_identity)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->create_upstream_user_identity: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **upstream_user_identity** | [**UpstreamUserIdentity**](UpstreamUserIdentity.md)|  | 

### Return type

[**UpstreamUserIdentity**](UpstreamUserIdentity.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | New upstream identity created and associated with the user. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_user**
> User create_user(user)

Create a user

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user = agilicus_api.User() # User | 

    try:
        # Create a user
        api_response = api_instance.create_user(user)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->create_user: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user** | [**User**](User.md)|  | 

### Return type

[**User**](User.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | New User created |  -  |
**409** | User already exists |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_user_identity_update**
> UserIdentityUpdate create_user_identity_update(user_id, user_identity_update)

Update a user's core identity information.

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
user_identity_update = agilicus_api.UserIdentityUpdate() # UserIdentityUpdate | 

    try:
        # Update a user's core identity information.
        api_response = api_instance.create_user_identity_update(user_id, user_identity_update)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->create_user_identity_update: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **user_identity_update** | [**UserIdentityUpdate**](UserIdentityUpdate.md)|  | 

### Return type

[**UserIdentityUpdate**](UserIdentityUpdate.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | User updated with identity information. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_challenge_method**
> delete_challenge_method(user_id, challenge_method_id)

Delete a user's multi-factor authentication challenge method

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
challenge_method_id = '1234' # str | challenge method id

    try:
        # Delete a user's multi-factor authentication challenge method
        api_instance.delete_challenge_method(user_id, challenge_method_id)
    except ApiException as e:
        print("Exception when calling UsersApi->delete_challenge_method: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **challenge_method_id** | **str**| challenge method id | 

### Return type

void (empty response body)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Challenge method updated |  -  |
**404** | Challenge method does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_upstream_user_identity**
> delete_upstream_user_identity(user_id, upstream_user_identity_id)

Delete an upstream user identity

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
upstream_user_identity_id = 'sad934lsawql2' # str | The unique id of the upstream user identity

    try:
        # Delete an upstream user identity
        api_instance.delete_upstream_user_identity(user_id, upstream_user_identity_id)
    except ApiException as e:
        print("Exception when calling UsersApi->delete_upstream_user_identity: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **upstream_user_identity_id** | **str**| The unique id of the upstream user identity | 

### Return type

void (empty response body)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Upstream user identity deleted. |  -  |
**404** | Upstream user identity does not exist. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_user**
> delete_user(org_id, user_id)

Remove a user from an organisation

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    org_id = '1234' # str | Organisation Unique identifier
user_id = '1234' # str | user_id path

    try:
        # Remove a user from an organisation
        api_instance.delete_user(org_id, user_id)
    except ApiException as e:
        print("Exception when calling UsersApi->delete_user: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **org_id** | **str**| Organisation Unique identifier | 
 **user_id** | **str**| user_id path | 

### Return type

void (empty response body)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | User was removed from organisation |  -  |
**404** | User does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_challenge_method**
> MFAChallengeMethod get_challenge_method(user_id, challenge_method_id)

Get a single challenge method for the given user

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
challenge_method_id = '1234' # str | challenge method id

    try:
        # Get a single challenge method for the given user
        api_response = api_instance.get_challenge_method(user_id, challenge_method_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->get_challenge_method: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **challenge_method_id** | **str**| challenge method id | 

### Return type

[**MFAChallengeMethod**](MFAChallengeMethod.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Return user |  -  |
**404** | Challenge method does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_upstream_user_identity**
> UpstreamUserIdentity get_upstream_user_identity(user_id, upstream_user_identity_id)

Get a single upstream user identity

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
upstream_user_identity_id = 'sad934lsawql2' # str | The unique id of the upstream user identity

    try:
        # Get a single upstream user identity
        api_response = api_instance.get_upstream_user_identity(user_id, upstream_user_identity_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->get_upstream_user_identity: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **upstream_user_identity_id** | **str**| The unique id of the upstream user identity | 

### Return type

[**UpstreamUserIdentity**](UpstreamUserIdentity.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Upstream user identity found and returned. |  -  |
**404** | Upstream user identity does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_user**
> User get_user(user_id, org_id=org_id)

Get a single user

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
org_id = '1234' # str | Organisation Unique identifier (optional)

    try:
        # Get a single user
        api_response = api_instance.get_user(user_id, org_id=org_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->get_user: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **org_id** | **str**| Organisation Unique identifier | [optional] 

### Return type

[**User**](User.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Return user |  -  |
**404** | User does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_all_user_orgs**
> ListOrgsResponse list_all_user_orgs(user_id, issuer=issuer)

Return all organisations a user has been assigned to

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
issuer = 'example.com' # str | Organisation issuer (optional)

    try:
        # Return all organisations a user has been assigned to
        api_response = api_instance.list_all_user_orgs(user_id, issuer=issuer)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->list_all_user_orgs: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **issuer** | **str**| Organisation issuer | [optional] 

### Return type

[**ListOrgsResponse**](ListOrgsResponse.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | roles |  -  |
**404** | User does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_all_user_roles**
> Roles list_all_user_roles(user_id, org_id=org_id)

Return all roles for a user

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
org_id = '1234' # str | Organisation Unique identifier (optional)

    try:
        # Return all roles for a user
        api_response = api_instance.list_all_user_roles(user_id, org_id=org_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->list_all_user_roles: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **org_id** | **str**| Organisation Unique identifier | [optional] 

### Return type

[**Roles**](Roles.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | roles |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_challenge_methods**
> ListMFAChallengeMethods list_challenge_methods(user_id, limit=limit, challenge_type=challenge_type, method_status=method_status)

Get all of a user's multi-factor authentication challenge method configuration

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
limit = 500 # int | limit the number of rows in the response (optional) (default to 500)
challenge_type = 'sms' # str | challenge method type query (optional)
method_status = false # bool | The status of the challenge method. True for enabled, false for disabled. (optional)

    try:
        # Get all of a user's multi-factor authentication challenge method configuration
        api_response = api_instance.list_challenge_methods(user_id, limit=limit, challenge_type=challenge_type, method_status=method_status)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->list_challenge_methods: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **limit** | **int**| limit the number of rows in the response | [optional] [default to 500]
 **challenge_type** | **str**| challenge method type query | [optional] 
 **method_status** | **bool**| The status of the challenge method. True for enabled, false for disabled. | [optional] 

### Return type

[**ListMFAChallengeMethods**](ListMFAChallengeMethods.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Return user&#39;s multi-factor authentication challenge method configuration |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_combined_user_details**
> ListCombinedUserDetailsResponse list_combined_user_details(email=email, previous_email=previous_email, org_id=org_id, limit=limit, type=type, user_id=user_id)

Get all combined details about users

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    email = 'foo@example.com' # str | Query based on user email (optional)
previous_email = 'foo@example.com' # str | Pagination based query with the user's email as the key. To get the initial entries supply an empty string. (optional)
org_id = '1234' # str | Organisation Unique identifier (optional)
limit = 500 # int | limit the number of rows in the response (optional) (default to 500)
type = '1234' # str | user type (optional)
user_id = '1234' # str | Query based on user id (optional)

    try:
        # Get all combined details about users
        api_response = api_instance.list_combined_user_details(email=email, previous_email=previous_email, org_id=org_id, limit=limit, type=type, user_id=user_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->list_combined_user_details: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email** | **str**| Query based on user email | [optional] 
 **previous_email** | **str**| Pagination based query with the user&#39;s email as the key. To get the initial entries supply an empty string. | [optional] 
 **org_id** | **str**| Organisation Unique identifier | [optional] 
 **limit** | **int**| limit the number of rows in the response | [optional] [default to 500]
 **type** | **str**| user type | [optional] 
 **user_id** | **str**| Query based on user id | [optional] 

### Return type

[**ListCombinedUserDetailsResponse**](ListCombinedUserDetailsResponse.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Return combined user details |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_upstream_user_identities**
> ListUpstreamUserIdentitiesResponse list_upstream_user_identities(user_id, limit=limit)

Get all of a user's upstream user identities

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
limit = 500 # int | limit the number of rows in the response (optional) (default to 500)

    try:
        # Get all of a user's upstream user identities
        api_response = api_instance.list_upstream_user_identities(user_id, limit=limit)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->list_upstream_user_identities: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **limit** | **int**| limit the number of rows in the response | [optional] [default to 500]

### Return type

[**ListUpstreamUserIdentitiesResponse**](ListUpstreamUserIdentitiesResponse.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Return user&#39;s upstream identities |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_user_guids**
> ListUserGuidsResponse list_user_guids(updated_since=updated_since)

Get a list of all user GUIDs

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    updated_since = '2015-07-07T15:49:51.230+02:00' # datetime | query since updated (optional)

    try:
        # Get a list of all user GUIDs
        api_response = api_instance.list_user_guids(updated_since=updated_since)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->list_user_guids: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_since** | **datetime**| query since updated | [optional] 

### Return type

[**ListUserGuidsResponse**](ListUserGuidsResponse.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | A list of user GUIDs |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_user_permissions**
> HostPermissions list_user_permissions(user_id, org_id=org_id)

Return the user's host permissions

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
org_id = '1234' # str | Organisation Unique identifier (optional)

    try:
        # Return the user's host permissions
        api_response = api_instance.list_user_permissions(user_id, org_id=org_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->list_user_permissions: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **org_id** | **str**| Organisation Unique identifier | [optional] 

### Return type

[**HostPermissions**](HostPermissions.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | roles |  -  |
**404** | User does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_users**
> ListUsersResponse list_users(email=email, previous_email=previous_email, provider=provider, org_id=org_id, issuer=issuer, limit=limit, type=type, upstream_user_id=upstream_user_id, upstream_idp_id=upstream_idp_id)

Get all users

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    email = 'foo@example.com' # str | Query based on user email (optional)
previous_email = 'foo@example.com' # str | Pagination based query with the user's email as the key. To get the initial entries supply an empty string. (optional)
provider = 'google.com' # str | Query based on identity provider (optional)
org_id = '1234' # str | Organisation Unique identifier (optional)
issuer = 'example.com' # str | Organisation issuer (optional)
limit = 500 # int | limit the number of rows in the response (optional) (default to 500)
type = '1234' # str | user type (optional)
upstream_user_id = '1234-abcd' # str | The id of the user from upstream (optional)
upstream_idp_id = 'sad934lsawql2' # str | The unique id of the upstream idp (optional)

    try:
        # Get all users
        api_response = api_instance.list_users(email=email, previous_email=previous_email, provider=provider, org_id=org_id, issuer=issuer, limit=limit, type=type, upstream_user_id=upstream_user_id, upstream_idp_id=upstream_idp_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->list_users: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email** | **str**| Query based on user email | [optional] 
 **previous_email** | **str**| Pagination based query with the user&#39;s email as the key. To get the initial entries supply an empty string. | [optional] 
 **provider** | **str**| Query based on identity provider | [optional] 
 **org_id** | **str**| Organisation Unique identifier | [optional] 
 **issuer** | **str**| Organisation issuer | [optional] 
 **limit** | **int**| limit the number of rows in the response | [optional] [default to 500]
 **type** | **str**| user type | [optional] 
 **upstream_user_id** | **str**| The id of the user from upstream | [optional] 
 **upstream_idp_id** | **str**| The unique id of the upstream idp | [optional] 

### Return type

[**ListUsersResponse**](ListUsersResponse.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Return users |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **replace_challenge_method**
> MFAChallengeMethod replace_challenge_method(user_id, challenge_method_id, mfa_challenge_method=mfa_challenge_method)

Update a user's multi-factor authentication challenge method

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
challenge_method_id = '1234' # str | challenge method id
mfa_challenge_method = agilicus_api.MFAChallengeMethod() # MFAChallengeMethod |  (optional)

    try:
        # Update a user's multi-factor authentication challenge method
        api_response = api_instance.replace_challenge_method(user_id, challenge_method_id, mfa_challenge_method=mfa_challenge_method)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->replace_challenge_method: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **challenge_method_id** | **str**| challenge method id | 
 **mfa_challenge_method** | [**MFAChallengeMethod**](MFAChallengeMethod.md)|  | [optional] 

### Return type

[**MFAChallengeMethod**](MFAChallengeMethod.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Challenge method updated |  -  |
**404** | Challenge method does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **replace_upstream_user_identity**
> UpstreamUserIdentity replace_upstream_user_identity(user_id, upstream_user_identity_id, upstream_user_identity=upstream_user_identity)

Update an upstream user identity

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
upstream_user_identity_id = 'sad934lsawql2' # str | The unique id of the upstream user identity
upstream_user_identity = agilicus_api.UpstreamUserIdentity() # UpstreamUserIdentity |  (optional)

    try:
        # Update an upstream user identity
        api_response = api_instance.replace_upstream_user_identity(user_id, upstream_user_identity_id, upstream_user_identity=upstream_user_identity)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UsersApi->replace_upstream_user_identity: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **upstream_user_identity_id** | **str**| The unique id of the upstream user identity | 
 **upstream_user_identity** | [**UpstreamUserIdentity**](UpstreamUserIdentity.md)|  | [optional] 

### Return type

[**UpstreamUserIdentity**](UpstreamUserIdentity.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Upstream user identity updated |  -  |
**404** | Upstream user identity does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **replace_user**
> replace_user(user_id, user=user)

Create or update a user

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
user = agilicus_api.User() # User |  (optional)

    try:
        # Create or update a user
        api_instance.replace_user(user_id, user=user)
    except ApiException as e:
        print("Exception when calling UsersApi->replace_user: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **user** | [**User**](User.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | User updated |  -  |
**404** | User does not exists |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **replace_user_role**
> replace_user_role(user_id, org_id=org_id, replace_user_role_request=replace_user_role_request)

Create or update a user role

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
org_id = '1234' # str | Organisation Unique identifier (optional)
replace_user_role_request = agilicus_api.ReplaceUserRoleRequest() # ReplaceUserRoleRequest |  (optional)

    try:
        # Create or update a user role
        api_instance.replace_user_role(user_id, org_id=org_id, replace_user_role_request=replace_user_role_request)
    except ApiException as e:
        print("Exception when calling UsersApi->replace_user_role: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **org_id** | **str**| Organisation Unique identifier | [optional] 
 **replace_user_role_request** | [**ReplaceUserRoleRequest**](ReplaceUserRoleRequest.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | User role updated |  -  |
**404** | User does not exists |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **reset_user_mfa_challenge_methods**
> reset_user_mfa_challenge_methods(user_id, reset_mfa_challenge_method)

Resets a user's multi-factor authentication method

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.UsersApi(api_client)
    user_id = '1234' # str | user_id path
reset_mfa_challenge_method = agilicus_api.ResetMFAChallengeMethod() # ResetMFAChallengeMethod | 

    try:
        # Resets a user's multi-factor authentication method
        api_instance.reset_user_mfa_challenge_methods(user_id, reset_mfa_challenge_method)
    except ApiException as e:
        print("Exception when calling UsersApi->reset_user_mfa_challenge_methods: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **str**| user_id path | 
 **reset_mfa_challenge_method** | [**ResetMFAChallengeMethod**](ResetMFAChallengeMethod.md)|  | 

### Return type

void (empty response body)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | User&#39;s multi-factor authentication methods were reset successfully |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

