# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.08.05
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from agilicus_api.configuration import Configuration


class CatalogueEntry(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'catalogue_id': 'str',
        'catalogue_category': 'str',
        'name': 'str',
        'content': 'str',
        'tag': 'str',
        'short_description': 'str',
        'long_description': 'str',
        'created': 'datetime',
        'updated': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'catalogue_id': 'catalogue_id',
        'catalogue_category': 'catalogue_category',
        'name': 'name',
        'content': 'content',
        'tag': 'tag',
        'short_description': 'short_description',
        'long_description': 'long_description',
        'created': 'created',
        'updated': 'updated'
    }

    def __init__(self, id=None, catalogue_id=None, catalogue_category=None, name=None, content=None, tag=None, short_description=None, long_description=None, created=None, updated=None, local_vars_configuration=None):  # noqa: E501
        """CatalogueEntry - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._catalogue_id = None
        self._catalogue_category = None
        self._name = None
        self._content = None
        self._tag = None
        self._short_description = None
        self._long_description = None
        self._created = None
        self._updated = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if catalogue_id is not None:
            self.catalogue_id = catalogue_id
        if catalogue_category is not None:
            self.catalogue_category = catalogue_category
        self.name = name
        if content is not None:
            self.content = content
        if tag is not None:
            self.tag = tag
        if short_description is not None:
            self.short_description = short_description
        if long_description is not None:
            self.long_description = long_description
        if created is not None:
            self.created = created
        if updated is not None:
            self.updated = updated

    @property
    def id(self):
        """Gets the id of this CatalogueEntry.  # noqa: E501

        Unique identifier  # noqa: E501

        :return: The id of this CatalogueEntry.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CatalogueEntry.

        Unique identifier  # noqa: E501

        :param id: The id of this CatalogueEntry.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def catalogue_id(self):
        """Gets the catalogue_id of this CatalogueEntry.  # noqa: E501

        Unique identifier  # noqa: E501

        :return: The catalogue_id of this CatalogueEntry.  # noqa: E501
        :rtype: str
        """
        return self._catalogue_id

    @catalogue_id.setter
    def catalogue_id(self, catalogue_id):
        """Sets the catalogue_id of this CatalogueEntry.

        Unique identifier  # noqa: E501

        :param catalogue_id: The catalogue_id of this CatalogueEntry.  # noqa: E501
        :type: str
        """

        self._catalogue_id = catalogue_id

    @property
    def catalogue_category(self):
        """Gets the catalogue_category of this CatalogueEntry.  # noqa: E501

        The category of catalogue that this entry is apart of  # noqa: E501

        :return: The catalogue_category of this CatalogueEntry.  # noqa: E501
        :rtype: str
        """
        return self._catalogue_category

    @catalogue_category.setter
    def catalogue_category(self, catalogue_category):
        """Sets the catalogue_category of this CatalogueEntry.

        The category of catalogue that this entry is apart of  # noqa: E501

        :param catalogue_category: The catalogue_category of this CatalogueEntry.  # noqa: E501
        :type: str
        """

        self._catalogue_category = catalogue_category

    @property
    def name(self):
        """Gets the name of this CatalogueEntry.  # noqa: E501

        The name of the catalogue entry in a user friendly form  # noqa: E501

        :return: The name of this CatalogueEntry.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CatalogueEntry.

        The name of the catalogue entry in a user friendly form  # noqa: E501

        :param name: The name of this CatalogueEntry.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `100`")  # noqa: E501

        self._name = name

    @property
    def content(self):
        """Gets the content of this CatalogueEntry.  # noqa: E501

        The content of the catalogue  # noqa: E501

        :return: The content of this CatalogueEntry.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this CatalogueEntry.

        The content of the catalogue  # noqa: E501

        :param content: The content of this CatalogueEntry.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                content is not None and len(content) > 5242880):
            raise ValueError("Invalid value for `content`, length must be less than or equal to `5242880`")  # noqa: E501

        self._content = content

    @property
    def tag(self):
        """Gets the tag of this CatalogueEntry.  # noqa: E501

        A qualifier for the catalogue entry. Used for differentiating between entries of the same name  # noqa: E501

        :return: The tag of this CatalogueEntry.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this CatalogueEntry.

        A qualifier for the catalogue entry. Used for differentiating between entries of the same name  # noqa: E501

        :param tag: The tag of this CatalogueEntry.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                tag is not None and len(tag) > 40):
            raise ValueError("Invalid value for `tag`, length must be less than or equal to `40`")  # noqa: E501

        self._tag = tag

    @property
    def short_description(self):
        """Gets the short_description of this CatalogueEntry.  # noqa: E501

        A short description of the catalogue entry.  # noqa: E501

        :return: The short_description of this CatalogueEntry.  # noqa: E501
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """Sets the short_description of this CatalogueEntry.

        A short description of the catalogue entry.  # noqa: E501

        :param short_description: The short_description of this CatalogueEntry.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                short_description is not None and len(short_description) > 255):
            raise ValueError("Invalid value for `short_description`, length must be less than or equal to `255`")  # noqa: E501

        self._short_description = short_description

    @property
    def long_description(self):
        """Gets the long_description of this CatalogueEntry.  # noqa: E501

        A detailed description of the catalogue entry  # noqa: E501

        :return: The long_description of this CatalogueEntry.  # noqa: E501
        :rtype: str
        """
        return self._long_description

    @long_description.setter
    def long_description(self, long_description):
        """Sets the long_description of this CatalogueEntry.

        A detailed description of the catalogue entry  # noqa: E501

        :param long_description: The long_description of this CatalogueEntry.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                long_description is not None and len(long_description) > 2000):
            raise ValueError("Invalid value for `long_description`, length must be less than or equal to `2000`")  # noqa: E501

        self._long_description = long_description

    @property
    def created(self):
        """Gets the created of this CatalogueEntry.  # noqa: E501

        Creation time  # noqa: E501

        :return: The created of this CatalogueEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this CatalogueEntry.

        Creation time  # noqa: E501

        :param created: The created of this CatalogueEntry.  # noqa: E501
        :type: datetime
        """

        self._created = created

    @property
    def updated(self):
        """Gets the updated of this CatalogueEntry.  # noqa: E501

        Update time  # noqa: E501

        :return: The updated of this CatalogueEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """Sets the updated of this CatalogueEntry.

        Update time  # noqa: E501

        :param updated: The updated of this CatalogueEntry.  # noqa: E501
        :type: datetime
        """

        self._updated = updated

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CatalogueEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CatalogueEntry):
            return True

        return self.to_dict() != other.to_dict()
