# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.08.05
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from agilicus_api.configuration import Configuration


class Issuer(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'issuer': 'str',
        'enabled': 'bool',
        'org_id': 'str',
        'theme_file_id': 'str',
        'upstream_redirect_uri': 'str',
        'managed_upstreams': 'list[ManagedUpstreamIdentityProvider]',
        'oidc_upstreams': 'list[OIDCUpstreamIdentityProvider]',
        'clients': 'list[IssuerClient]'
    }

    attribute_map = {
        'id': 'id',
        'issuer': 'issuer',
        'enabled': 'enabled',
        'org_id': 'org_id',
        'theme_file_id': 'theme_file_id',
        'upstream_redirect_uri': 'upstream_redirect_uri',
        'managed_upstreams': 'managed_upstreams',
        'oidc_upstreams': 'oidc_upstreams',
        'clients': 'clients'
    }

    def __init__(self, id=None, issuer=None, enabled=True, org_id=None, theme_file_id=None, upstream_redirect_uri=None, managed_upstreams=None, oidc_upstreams=None, clients=None, local_vars_configuration=None):  # noqa: E501
        """Issuer - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._issuer = None
        self._enabled = None
        self._org_id = None
        self._theme_file_id = None
        self._upstream_redirect_uri = None
        self._managed_upstreams = None
        self._oidc_upstreams = None
        self._clients = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.issuer = issuer
        if enabled is not None:
            self.enabled = enabled
        if org_id is not None:
            self.org_id = org_id
        if theme_file_id is not None:
            self.theme_file_id = theme_file_id
        if upstream_redirect_uri is not None:
            self.upstream_redirect_uri = upstream_redirect_uri
        if managed_upstreams is not None:
            self.managed_upstreams = managed_upstreams
        if oidc_upstreams is not None:
            self.oidc_upstreams = oidc_upstreams
        if clients is not None:
            self.clients = clients

    @property
    def id(self):
        """Gets the id of this Issuer.  # noqa: E501

        Unique identifier  # noqa: E501

        :return: The id of this Issuer.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Issuer.

        Unique identifier  # noqa: E501

        :param id: The id of this Issuer.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def issuer(self):
        """Gets the issuer of this Issuer.  # noqa: E501

        connect id issuer  # noqa: E501

        :return: The issuer of this Issuer.  # noqa: E501
        :rtype: str
        """
        return self._issuer

    @issuer.setter
    def issuer(self, issuer):
        """Sets the issuer of this Issuer.

        connect id issuer  # noqa: E501

        :param issuer: The issuer of this Issuer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and issuer is None:  # noqa: E501
            raise ValueError("Invalid value for `issuer`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                issuer is not None and len(issuer) > 100):
            raise ValueError("Invalid value for `issuer`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                issuer is not None and len(issuer) < 1):
            raise ValueError("Invalid value for `issuer`, length must be greater than or equal to `1`")  # noqa: E501

        self._issuer = issuer

    @property
    def enabled(self):
        """Gets the enabled of this Issuer.  # noqa: E501

        Describes whether or not the issuer is enabled  # noqa: E501

        :return: The enabled of this Issuer.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this Issuer.

        Describes whether or not the issuer is enabled  # noqa: E501

        :param enabled: The enabled of this Issuer.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def org_id(self):
        """Gets the org_id of this Issuer.  # noqa: E501

        ID of the organisation which owns the issuer  # noqa: E501

        :return: The org_id of this Issuer.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this Issuer.

        ID of the organisation which owns the issuer  # noqa: E501

        :param org_id: The org_id of this Issuer.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                org_id is not None and len(org_id) > 40):
            raise ValueError("Invalid value for `org_id`, length must be less than or equal to `40`")  # noqa: E501

        self._org_id = org_id

    @property
    def theme_file_id(self):
        """Gets the theme_file_id of this Issuer.  # noqa: E501

        ID of the theme file. The theme file is a zip file containing the web assets to show the client on login.  # noqa: E501

        :return: The theme_file_id of this Issuer.  # noqa: E501
        :rtype: str
        """
        return self._theme_file_id

    @theme_file_id.setter
    def theme_file_id(self, theme_file_id):
        """Sets the theme_file_id of this Issuer.

        ID of the theme file. The theme file is a zip file containing the web assets to show the client on login.  # noqa: E501

        :param theme_file_id: The theme_file_id of this Issuer.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                theme_file_id is not None and len(theme_file_id) > 40):
            raise ValueError("Invalid value for `theme_file_id`, length must be less than or equal to `40`")  # noqa: E501

        self._theme_file_id = theme_file_id

    @property
    def upstream_redirect_uri(self):
        """Gets the upstream_redirect_uri of this Issuer.  # noqa: E501

        Upstream redirect URI is the URI to which OpenID Connect upstreams will redirect after authentication. This is provisioned by Agilicus, but must be allowed by the upstream.  # noqa: E501

        :return: The upstream_redirect_uri of this Issuer.  # noqa: E501
        :rtype: str
        """
        return self._upstream_redirect_uri

    @upstream_redirect_uri.setter
    def upstream_redirect_uri(self, upstream_redirect_uri):
        """Sets the upstream_redirect_uri of this Issuer.

        Upstream redirect URI is the URI to which OpenID Connect upstreams will redirect after authentication. This is provisioned by Agilicus, but must be allowed by the upstream.  # noqa: E501

        :param upstream_redirect_uri: The upstream_redirect_uri of this Issuer.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                upstream_redirect_uri is not None and len(upstream_redirect_uri) > 511):
            raise ValueError("Invalid value for `upstream_redirect_uri`, length must be less than or equal to `511`")  # noqa: E501

        self._upstream_redirect_uri = upstream_redirect_uri

    @property
    def managed_upstreams(self):
        """Gets the managed_upstreams of this Issuer.  # noqa: E501

        The set of managed upstream identity providers for this issuer. A managed upstream has its configuration managed by default, and can be enabled or disabled for this issuer via this api.  # noqa: E501

        :return: The managed_upstreams of this Issuer.  # noqa: E501
        :rtype: list[ManagedUpstreamIdentityProvider]
        """
        return self._managed_upstreams

    @managed_upstreams.setter
    def managed_upstreams(self, managed_upstreams):
        """Sets the managed_upstreams of this Issuer.

        The set of managed upstream identity providers for this issuer. A managed upstream has its configuration managed by default, and can be enabled or disabled for this issuer via this api.  # noqa: E501

        :param managed_upstreams: The managed_upstreams of this Issuer.  # noqa: E501
        :type: list[ManagedUpstreamIdentityProvider]
        """

        self._managed_upstreams = managed_upstreams

    @property
    def oidc_upstreams(self):
        """Gets the oidc_upstreams of this Issuer.  # noqa: E501

        The set of OpenID Connect upstream identity providers configured for this issuer. An upstream is managed by the client, and can be configured for this issuer via this api.  # noqa: E501

        :return: The oidc_upstreams of this Issuer.  # noqa: E501
        :rtype: list[OIDCUpstreamIdentityProvider]
        """
        return self._oidc_upstreams

    @oidc_upstreams.setter
    def oidc_upstreams(self, oidc_upstreams):
        """Sets the oidc_upstreams of this Issuer.

        The set of OpenID Connect upstream identity providers configured for this issuer. An upstream is managed by the client, and can be configured for this issuer via this api.  # noqa: E501

        :param oidc_upstreams: The oidc_upstreams of this Issuer.  # noqa: E501
        :type: list[OIDCUpstreamIdentityProvider]
        """

        self._oidc_upstreams = oidc_upstreams

    @property
    def clients(self):
        """Gets the clients of this Issuer.  # noqa: E501

        List of clients  # noqa: E501

        :return: The clients of this Issuer.  # noqa: E501
        :rtype: list[IssuerClient]
        """
        return self._clients

    @clients.setter
    def clients(self, clients):
        """Sets the clients of this Issuer.

        List of clients  # noqa: E501

        :param clients: The clients of this Issuer.  # noqa: E501
        :type: list[IssuerClient]
        """

        self._clients = clients

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Issuer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Issuer):
            return True

        return self.to_dict() != other.to_dict()
