# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.08.05
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from agilicus_api.configuration import Configuration


class RoleSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'app_id': 'str',
        'name': 'str',
        'comments': 'str',
        'included': 'list[IncludedRole]',
        'org_id': 'str'
    }

    attribute_map = {
        'app_id': 'app_id',
        'name': 'name',
        'comments': 'comments',
        'included': 'included',
        'org_id': 'org_id'
    }

    def __init__(self, app_id=None, name=None, comments=None, included=None, org_id=None, local_vars_configuration=None):  # noqa: E501
        """RoleSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._app_id = None
        self._name = None
        self._comments = None
        self._included = None
        self._org_id = None
        self.discriminator = None

        if app_id is not None:
            self.app_id = app_id
        self.name = name
        if comments is not None:
            self.comments = comments
        if included is not None:
            self.included = included
        if org_id is not None:
            self.org_id = org_id

    @property
    def app_id(self):
        """Gets the app_id of this RoleSpec.  # noqa: E501

        Unique identifier  # noqa: E501

        :return: The app_id of this RoleSpec.  # noqa: E501
        :rtype: str
        """
        return self._app_id

    @app_id.setter
    def app_id(self, app_id):
        """Sets the app_id of this RoleSpec.

        Unique identifier  # noqa: E501

        :param app_id: The app_id of this RoleSpec.  # noqa: E501
        :type: str
        """

        self._app_id = app_id

    @property
    def name(self):
        """Gets the name of this RoleSpec.  # noqa: E501

        A descriptive name of the role. This will be used to reference the role, in the context of the application, from other systems. Roles are case sensitive.   # noqa: E501

        :return: The name of this RoleSpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RoleSpec.

        A descriptive name of the role. This will be used to reference the role, in the context of the application, from other systems. Roles are case sensitive.   # noqa: E501

        :param name: The name of this RoleSpec.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'[A-Za-z0-9_]*', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/[A-Za-z0-9_]*/`")  # noqa: E501

        self._name = name

    @property
    def comments(self):
        """Gets the comments of this RoleSpec.  # noqa: E501

        A description of the role. The comments have no functional effect, but can help to clarify the purpose of a role when the name is not sufficient.   # noqa: E501

        :return: The comments of this RoleSpec.  # noqa: E501
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """Sets the comments of this RoleSpec.

        A description of the role. The comments have no functional effect, but can help to clarify the purpose of a role when the name is not sufficient.   # noqa: E501

        :param comments: The comments of this RoleSpec.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                comments is not None and len(comments) > 2047):
            raise ValueError("Invalid value for `comments`, length must be less than or equal to `2047`")  # noqa: E501

        self._comments = comments

    @property
    def included(self):
        """Gets the included of this RoleSpec.  # noqa: E501

        A list of included rules for the role. This role will grant permissions for all rules associated directly with itself, and with its included roles. Note that the inclusion is recursive: a role will get the rules of roles it includes, and the roles that they include, and so on. The roles are included by ID   # noqa: E501

        :return: The included of this RoleSpec.  # noqa: E501
        :rtype: list[IncludedRole]
        """
        return self._included

    @included.setter
    def included(self, included):
        """Sets the included of this RoleSpec.

        A list of included rules for the role. This role will grant permissions for all rules associated directly with itself, and with its included roles. Note that the inclusion is recursive: a role will get the rules of roles it includes, and the roles that they include, and so on. The roles are included by ID   # noqa: E501

        :param included: The included of this RoleSpec.  # noqa: E501
        :type: list[IncludedRole]
        """

        self._included = included

    @property
    def org_id(self):
        """Gets the org_id of this RoleSpec.  # noqa: E501

        Unique identifier  # noqa: E501

        :return: The org_id of this RoleSpec.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this RoleSpec.

        Unique identifier  # noqa: E501

        :param org_id: The org_id of this RoleSpec.  # noqa: E501
        :type: str
        """

        self._org_id = org_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoleSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RoleSpec):
            return True

        return self.to_dict() != other.to_dict()
