# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.08.05
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from agilicus_api.configuration import Configuration


class UserIdentity(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'email': 'str',
        'type': 'str',
        'upstream_user_identities': 'list[UpstreamUserIdentity]'
    }

    attribute_map = {
        'id': 'id',
        'first_name': 'first_name',
        'last_name': 'last_name',
        'email': 'email',
        'type': 'type',
        'upstream_user_identities': 'upstream_user_identities'
    }

    discriminator_value_class_map = {
        'GroupMember': 'GroupMember'
    }

    def __init__(self, id=None, first_name=None, last_name=None, email=None, type=None, upstream_user_identities=None, local_vars_configuration=None):  # noqa: E501
        """UserIdentity - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._first_name = None
        self._last_name = None
        self._email = None
        self._type = None
        self._upstream_user_identities = None
        self.discriminator = 'type'

        if id is not None:
            self.id = id
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if email is not None:
            self.email = email
        if type is not None:
            self.type = type
        if upstream_user_identities is not None:
            self.upstream_user_identities = upstream_user_identities

    @property
    def id(self):
        """Gets the id of this UserIdentity.  # noqa: E501

        Unique identifier  # noqa: E501

        :return: The id of this UserIdentity.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UserIdentity.

        Unique identifier  # noqa: E501

        :param id: The id of this UserIdentity.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def first_name(self):
        """Gets the first_name of this UserIdentity.  # noqa: E501

        User's first name  # noqa: E501

        :return: The first_name of this UserIdentity.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this UserIdentity.

        User's first name  # noqa: E501

        :param first_name: The first_name of this UserIdentity.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                first_name is not None and len(first_name) > 100):
            raise ValueError("Invalid value for `first_name`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                first_name is not None and len(first_name) < 1):
            raise ValueError("Invalid value for `first_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this UserIdentity.  # noqa: E501

        User's last name  # noqa: E501

        :return: The last_name of this UserIdentity.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this UserIdentity.

        User's last name  # noqa: E501

        :param last_name: The last_name of this UserIdentity.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                last_name is not None and len(last_name) > 100):
            raise ValueError("Invalid value for `last_name`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                last_name is not None and len(last_name) < 0):
            raise ValueError("Invalid value for `last_name`, length must be greater than or equal to `0`")  # noqa: E501

        self._last_name = last_name

    @property
    def email(self):
        """Gets the email of this UserIdentity.  # noqa: E501

        User's email address  # noqa: E501

        :return: The email of this UserIdentity.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserIdentity.

        User's email address  # noqa: E501

        :param email: The email of this UserIdentity.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) > 100):
            raise ValueError("Invalid value for `email`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) < 1):
            raise ValueError("Invalid value for `email`, length must be greater than or equal to `1`")  # noqa: E501

        self._email = email

    @property
    def type(self):
        """Gets the type of this UserIdentity.  # noqa: E501

        Type of user  # noqa: E501

        :return: The type of this UserIdentity.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this UserIdentity.

        Type of user  # noqa: E501

        :param type: The type of this UserIdentity.  # noqa: E501
        :type: str
        """
        allowed_values = ["user", "group", "sysgroup", "bigroup"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def upstream_user_identities(self):
        """Gets the upstream_user_identities of this UserIdentity.  # noqa: E501

        The upstream identities this user can use to log in to the system. When a user logs in, their identity in this system will be determined by matching against this list. Note that this implies that entries in this list are globally unique.   # noqa: E501

        :return: The upstream_user_identities of this UserIdentity.  # noqa: E501
        :rtype: list[UpstreamUserIdentity]
        """
        return self._upstream_user_identities

    @upstream_user_identities.setter
    def upstream_user_identities(self, upstream_user_identities):
        """Sets the upstream_user_identities of this UserIdentity.

        The upstream identities this user can use to log in to the system. When a user logs in, their identity in this system will be determined by matching against this list. Note that this implies that entries in this list are globally unique.   # noqa: E501

        :param upstream_user_identities: The upstream_user_identities of this UserIdentity.  # noqa: E501
        :type: list[UpstreamUserIdentity]
        """

        self._upstream_user_identities = upstream_user_identities

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_key = self.attribute_map[self.discriminator]
        discriminator_value = data[discriminator_key]
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserIdentity):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserIdentity):
            return True

        return self.to_dict() != other.to_dict()
