# agilicus-api
Agilicus API endpoints

The `agilicus_api` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2020.08.05
- Package version: 1.56.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.agilicus.com](https://www.agilicus.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.15
* six >= 1.10
* certifi
* python-dateutil

## Getting Started

In your own code, to use this library to connect and interact with agilicus-api,
you can run the following:

```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint

configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.ApplicationServicesApi(api_client)
    application_service = agilicus_api.ApplicationService() # ApplicationService | 

    try:
        # Create an ApplicationService
        api_response = api_instance.create_application_service(application_service)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApplicationServicesApi->create_application_service: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.agilicus.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationServicesApi* | [**create_application_service**](agilicus_api/docs/ApplicationServicesApi.md#create_application_service) | **POST** /v2/application_services | Create an ApplicationService
*ApplicationServicesApi* | [**delete_application_service**](agilicus_api/docs/ApplicationServicesApi.md#delete_application_service) | **DELETE** /v2/application_services/{app_service_id} | Remove an ApplicationService
*ApplicationServicesApi* | [**get_application_service**](agilicus_api/docs/ApplicationServicesApi.md#get_application_service) | **GET** /v2/application_services/{app_service_id} | Get a single ApplicationService
*ApplicationServicesApi* | [**list_application_services**](agilicus_api/docs/ApplicationServicesApi.md#list_application_services) | **GET** /v2/application_services | Get a subset of the ApplicationServices
*ApplicationServicesApi* | [**replace_application_service**](agilicus_api/docs/ApplicationServicesApi.md#replace_application_service) | **PUT** /v2/application_services/{app_service_id} | Create or update an Application Service.
*ApplicationsApi* | [**add_config**](agilicus_api/docs/ApplicationsApi.md#add_config) | **POST** /v2/applications/{app_id}/environments/{env_name}/configs | Add an environment configuration row
*ApplicationsApi* | [**add_role**](agilicus_api/docs/ApplicationsApi.md#add_role) | **POST** /v2/applications/{app_id}/roles | Add a role to the application.
*ApplicationsApi* | [**add_role_to_rule_entry**](agilicus_api/docs/ApplicationsApi.md#add_role_to_rule_entry) | **POST** /v2/applications/{app_id}/role_to_rule_entries | Add a rule to a role in the application.
*ApplicationsApi* | [**add_rule**](agilicus_api/docs/ApplicationsApi.md#add_rule) | **POST** /v2/applications/{app_id}/rules | Add a rule to the application.
*ApplicationsApi* | [**create_application**](agilicus_api/docs/ApplicationsApi.md#create_application) | **POST** /v2/applications | Create an application
*ApplicationsApi* | [**delete_application**](agilicus_api/docs/ApplicationsApi.md#delete_application) | **DELETE** /v2/applications/{app_id} | Remove an application
*ApplicationsApi* | [**delete_config**](agilicus_api/docs/ApplicationsApi.md#delete_config) | **DELETE** /v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id} | Remove an environment configuration
*ApplicationsApi* | [**delete_role**](agilicus_api/docs/ApplicationsApi.md#delete_role) | **DELETE** /v2/applications/{app_id}/roles/{role_id} | Remove a role
*ApplicationsApi* | [**delete_role_to_rule_entry**](agilicus_api/docs/ApplicationsApi.md#delete_role_to_rule_entry) | **DELETE** /v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id} | Remove a role_to_rule_entry
*ApplicationsApi* | [**delete_rule**](agilicus_api/docs/ApplicationsApi.md#delete_rule) | **DELETE** /v2/applications/{app_id}/rules/{rule_id} | Remove a rule
*ApplicationsApi* | [**get_application**](agilicus_api/docs/ApplicationsApi.md#get_application) | **GET** /v2/applications/{app_id} | Get a application
*ApplicationsApi* | [**get_config**](agilicus_api/docs/ApplicationsApi.md#get_config) | **GET** /v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id} | Get environment configuration
*ApplicationsApi* | [**get_environment**](agilicus_api/docs/ApplicationsApi.md#get_environment) | **GET** /v2/applications/{app_id}/environments/{env_name} | Get an environment
*ApplicationsApi* | [**get_role**](agilicus_api/docs/ApplicationsApi.md#get_role) | **GET** /v2/applications/{app_id}/roles/{role_id} | Get a role
*ApplicationsApi* | [**get_role_to_rule_entry**](agilicus_api/docs/ApplicationsApi.md#get_role_to_rule_entry) | **GET** /v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id} | Get a role_to_rule_entry
*ApplicationsApi* | [**get_rule**](agilicus_api/docs/ApplicationsApi.md#get_rule) | **GET** /v2/applications/{app_id}/rules/{rule_id} | Get a rule
*ApplicationsApi* | [**list_applications**](agilicus_api/docs/ApplicationsApi.md#list_applications) | **GET** /v2/applications | Get applications
*ApplicationsApi* | [**list_combined_rules**](agilicus_api/docs/ApplicationsApi.md#list_combined_rules) | **GET** /v2/combined_rules | List rules combined by scope or role
*ApplicationsApi* | [**list_configs**](agilicus_api/docs/ApplicationsApi.md#list_configs) | **GET** /v2/applications/{app_id}/environments/{env_name}/configs | Get all environment configuration
*ApplicationsApi* | [**list_environment_configs_all_apps**](agilicus_api/docs/ApplicationsApi.md#list_environment_configs_all_apps) | **GET** /v2/environment_configs | Get all environment configuration for a given organisation.
*ApplicationsApi* | [**list_role_to_rule_entries**](agilicus_api/docs/ApplicationsApi.md#list_role_to_rule_entries) | **GET** /v2/applications/{app_id}/role_to_rule_entries | Get all RoleToRuleEntries
*ApplicationsApi* | [**list_roles**](agilicus_api/docs/ApplicationsApi.md#list_roles) | **GET** /v2/applications/{app_id}/roles | Get all roles
*ApplicationsApi* | [**list_rules**](agilicus_api/docs/ApplicationsApi.md#list_rules) | **GET** /v2/applications/{app_id}/rules | Get all rules
*ApplicationsApi* | [**list_runtime_status**](agilicus_api/docs/ApplicationsApi.md#list_runtime_status) | **GET** /v2/applications/{app_id}/environments/{env_name}/status/runtime_status | Get an environment&#39;s runtime status
*ApplicationsApi* | [**replace_application**](agilicus_api/docs/ApplicationsApi.md#replace_application) | **PUT** /v2/applications/{app_id} | Create or update an application
*ApplicationsApi* | [**replace_config**](agilicus_api/docs/ApplicationsApi.md#replace_config) | **PUT** /v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id} | Update environment configuration
*ApplicationsApi* | [**replace_environment**](agilicus_api/docs/ApplicationsApi.md#replace_environment) | **PUT** /v2/applications/{app_id}/environments/{env_name} | Update an environment
*ApplicationsApi* | [**replace_role**](agilicus_api/docs/ApplicationsApi.md#replace_role) | **PUT** /v2/applications/{app_id}/roles/{role_id} | Update a role
*ApplicationsApi* | [**replace_role_to_rule_entry**](agilicus_api/docs/ApplicationsApi.md#replace_role_to_rule_entry) | **PUT** /v2/applications/{app_id}/role_to_rule_entries/{role_to_rule_entry_id} | Update a role_to_rule_entry
*ApplicationsApi* | [**replace_rule**](agilicus_api/docs/ApplicationsApi.md#replace_rule) | **PUT** /v2/applications/{app_id}/rules/{rule_id} | Update a rule
*ApplicationsApi* | [**replace_runtime_status**](agilicus_api/docs/ApplicationsApi.md#replace_runtime_status) | **PUT** /v2/applications/{app_id}/environments/{env_name}/status/runtime_status | update an environemnt&#39;s runtime status
*AuditsApi* | [**list_audits**](agilicus_api/docs/AuditsApi.md#list_audits) | **GET** /v1/audits | View audit records
*AuditsApi* | [**list_auth_records**](agilicus_api/docs/AuditsApi.md#list_auth_records) | **GET** /v1/auth_audits | View authentication audit records
*CataloguesApi* | [**create_catalogue**](agilicus_api/docs/CataloguesApi.md#create_catalogue) | **POST** /v1/catalogues | create a catalogue
*CataloguesApi* | [**create_catalogue_entry**](agilicus_api/docs/CataloguesApi.md#create_catalogue_entry) | **POST** /v1/catalogues/{catalogue_id}/catalogue_entries | create a catalogue entry
*CataloguesApi* | [**delete_catalogue**](agilicus_api/docs/CataloguesApi.md#delete_catalogue) | **DELETE** /v1/catalogues/{catalogue_id} | Delete the catalogue specified by catalogue_id
*CataloguesApi* | [**delete_catalogue_entry**](agilicus_api/docs/CataloguesApi.md#delete_catalogue_entry) | **DELETE** /v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id} | Delete the catalogue specified by catalogue_entry_id
*CataloguesApi* | [**get_catalogue**](agilicus_api/docs/CataloguesApi.md#get_catalogue) | **GET** /v1/catalogues/{catalogue_id} | Get the catalogue specified by catalogue_id
*CataloguesApi* | [**get_catalogue_entry**](agilicus_api/docs/CataloguesApi.md#get_catalogue_entry) | **GET** /v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id} | Get the catalogue entry by id for the given catalogue
*CataloguesApi* | [**list_all_catalogue_entries**](agilicus_api/docs/CataloguesApi.md#list_all_catalogue_entries) | **GET** /v1/catalogue_entries | List all catalogue entries independant of the catalogue they belong to
*CataloguesApi* | [**list_catalogue_entries**](agilicus_api/docs/CataloguesApi.md#list_catalogue_entries) | **GET** /v1/catalogues/{catalogue_id}/catalogue_entries | List catalogue entries in the catalogue
*CataloguesApi* | [**list_catalogues**](agilicus_api/docs/CataloguesApi.md#list_catalogues) | **GET** /v1/catalogues | List all catalogues
*CataloguesApi* | [**replace_catalogue**](agilicus_api/docs/CataloguesApi.md#replace_catalogue) | **PUT** /v1/catalogues/{catalogue_id} | Replace the catalogue specified by catalogue_id
*CataloguesApi* | [**replace_catalogue_entry**](agilicus_api/docs/CataloguesApi.md#replace_catalogue_entry) | **PUT** /v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id} | Replace the catalogue entry specified by catalogue_entry_id
*ChallengesApi* | [**create_challenge**](agilicus_api/docs/ChallengesApi.md#create_challenge) | **POST** /v1/challenges | create a challenge
*ChallengesApi* | [**create_totp_enrollment**](agilicus_api/docs/ChallengesApi.md#create_totp_enrollment) | **POST** /v1/challenge_enrollment/totp | create a TOTP challenge enrollment
*ChallengesApi* | [**create_webauthn_enrollment**](agilicus_api/docs/ChallengesApi.md#create_webauthn_enrollment) | **POST** /v1/challenge_enrollment/webauthn | create a WebAuthN challenge enrollment
*ChallengesApi* | [**delete_challenge**](agilicus_api/docs/ChallengesApi.md#delete_challenge) | **DELETE** /v1/challenges/{challenge_id} | Delete the challenge specified by challenge_id
*ChallengesApi* | [**delete_totp_enrollment**](agilicus_api/docs/ChallengesApi.md#delete_totp_enrollment) | **DELETE** /v1/challenge_enrollment/totp/{totp_id} | Delete the TOTP enrollment specified by totp id
*ChallengesApi* | [**delete_webauthn_enrollment**](agilicus_api/docs/ChallengesApi.md#delete_webauthn_enrollment) | **DELETE** /v1/challenge_enrollment/webauthn/{webauthn_id} | Delete the WebAuthN enrollment specified by webauthn_id
*ChallengesApi* | [**get_answer**](agilicus_api/docs/ChallengesApi.md#get_answer) | **GET** /v1/challenges/{challenge_id}/answers | answer a challenge
*ChallengesApi* | [**get_challenge**](agilicus_api/docs/ChallengesApi.md#get_challenge) | **GET** /v1/challenges/{challenge_id} | Get the challenge specified by challenge_id
*ChallengesApi* | [**get_totp_enrollment**](agilicus_api/docs/ChallengesApi.md#get_totp_enrollment) | **GET** /v1/challenge_enrollment/totp/{totp_id} | Get the TOTP enrollment specified by totp_id
*ChallengesApi* | [**get_webauthn_enrollment**](agilicus_api/docs/ChallengesApi.md#get_webauthn_enrollment) | **GET** /v1/challenge_enrollment/webauthn/{webauthn_id} | Get the WebAuthN enrollment specified by webauthn_id
*ChallengesApi* | [**list_totp_enrollment**](agilicus_api/docs/ChallengesApi.md#list_totp_enrollment) | **GET** /v1/challenge_enrollment/totp | List the totp enrollment results
*ChallengesApi* | [**list_webauthn_enrollments**](agilicus_api/docs/ChallengesApi.md#list_webauthn_enrollments) | **GET** /v1/challenge_enrollment/webauthn | List the webauthn enrollments
*ChallengesApi* | [**replace_challenge**](agilicus_api/docs/ChallengesApi.md#replace_challenge) | **PUT** /v1/challenges/{challenge_id} | Replace the challenge specified by challenge_id
*ChallengesApi* | [**update_totp_enrollment**](agilicus_api/docs/ChallengesApi.md#update_totp_enrollment) | **POST** /v1/challenge_enrollment/totp/{totp_id} | Update the totp_enrollment if the answer provided is correct. This moves the state from pending to success.
*ChallengesApi* | [**update_webauthn_enrollment**](agilicus_api/docs/ChallengesApi.md#update_webauthn_enrollment) | **POST** /v1/challenge_enrollment/webauthn/{webauthn_id} | Update the WebAuthN enrollment if the answer provided is correct. This completes the device enrollment.
*DiagnosticsApi* | [**list_logs**](agilicus_api/docs/DiagnosticsApi.md#list_logs) | **GET** /v1/diagnostics/logs | Retrieve application logs
*FilesApi* | [**add_file**](agilicus_api/docs/FilesApi.md#add_file) | **POST** /v1/files | upload a file
*FilesApi* | [**delete_file**](agilicus_api/docs/FilesApi.md#delete_file) | **DELETE** /v1/files/{file_id} | Delete a File
*FilesApi* | [**get_download**](agilicus_api/docs/FilesApi.md#get_download) | **GET** /v1/files_download/{file_id} | Download File
*FilesApi* | [**get_file**](agilicus_api/docs/FilesApi.md#get_file) | **GET** /v1/files/{file_id} | Get File metadata
*FilesApi* | [**list_files**](agilicus_api/docs/FilesApi.md#list_files) | **GET** /v1/files | Query Files
*FilesApi* | [**replace_file**](agilicus_api/docs/FilesApi.md#replace_file) | **PUT** /v1/files/{file_id} | Update a file
*GroupsApi* | [**add_group_member**](agilicus_api/docs/GroupsApi.md#add_group_member) | **POST** /v1/groups/{group_id}/members | Add a group member
*GroupsApi* | [**create_group**](agilicus_api/docs/GroupsApi.md#create_group) | **POST** /v1/groups | Create a group
*GroupsApi* | [**delete_group**](agilicus_api/docs/GroupsApi.md#delete_group) | **DELETE** /v1/groups/{group_id} | Delete a group
*GroupsApi* | [**delete_group_member**](agilicus_api/docs/GroupsApi.md#delete_group_member) | **DELETE** /v1/groups/{group_id}/members/{member_id} | Remove a group member
*GroupsApi* | [**get_group**](agilicus_api/docs/GroupsApi.md#get_group) | **GET** /v1/groups/{group_id} | Get a group
*GroupsApi* | [**list_groups**](agilicus_api/docs/GroupsApi.md#list_groups) | **GET** /v1/groups | Get all groups
*GroupsApi* | [**replace_group**](agilicus_api/docs/GroupsApi.md#replace_group) | **PUT** /v1/groups/{group_id} | update a group
*IssuersApi* | [**create_client**](agilicus_api/docs/IssuersApi.md#create_client) | **POST** /v1/clients | Create a client
*IssuersApi* | [**create_issuer**](agilicus_api/docs/IssuersApi.md#create_issuer) | **POST** /v1/issuers/issuer_roots | Create an issuer
*IssuersApi* | [**delete_client**](agilicus_api/docs/IssuersApi.md#delete_client) | **DELETE** /v1/clients/{client_id} | Delete a client
*IssuersApi* | [**delete_root**](agilicus_api/docs/IssuersApi.md#delete_root) | **DELETE** /v1/issuers/issuer_roots/{issuer_id} | Delete an Issuer
*IssuersApi* | [**get_client**](agilicus_api/docs/IssuersApi.md#get_client) | **GET** /v1/clients/{client_id} | Get client
*IssuersApi* | [**get_issuer**](agilicus_api/docs/IssuersApi.md#get_issuer) | **GET** /v1/issuers/issuer_extensions/{issuer_id} | Get issuer
*IssuersApi* | [**get_root**](agilicus_api/docs/IssuersApi.md#get_root) | **GET** /v1/issuers/issuer_roots/{issuer_id} | Get issuer
*IssuersApi* | [**list_clients**](agilicus_api/docs/IssuersApi.md#list_clients) | **GET** /v1/clients | Query Clients
*IssuersApi* | [**list_issuer_roots**](agilicus_api/docs/IssuersApi.md#list_issuer_roots) | **GET** /v1/issuers/issuer_roots | Query Issuers
*IssuersApi* | [**list_issuers**](agilicus_api/docs/IssuersApi.md#list_issuers) | **GET** /v1/issuers/issuer_extensions | Query Issuers
*IssuersApi* | [**replace_client**](agilicus_api/docs/IssuersApi.md#replace_client) | **PUT** /v1/clients/{client_id} | Update a client
*IssuersApi* | [**replace_issuer**](agilicus_api/docs/IssuersApi.md#replace_issuer) | **PUT** /v1/issuers/issuer_extensions/{issuer_id} | Update an issuer
*IssuersApi* | [**replace_root**](agilicus_api/docs/IssuersApi.md#replace_root) | **PUT** /v1/issuers/issuer_roots/{issuer_id} | Update an issuer
*MessagesApi* | [**create_message**](agilicus_api/docs/MessagesApi.md#create_message) | **POST** /v1/messages/{message_endpoint_id}/send | Send a message to a specific message endpoint.
*MessagesApi* | [**create_user_message**](agilicus_api/docs/MessagesApi.md#create_user_message) | **POST** /v1/messages/user/{user_id}/send | Send a message to a user on all (optionally of a type) endpoints.
*MessagesApi* | [**delete_message_endpoint**](agilicus_api/docs/MessagesApi.md#delete_message_endpoint) | **DELETE** /v1/messages/{message_endpoint_id} | Delete a messaging endpoint
*MessagesApi* | [**get_message_endpoint**](agilicus_api/docs/MessagesApi.md#get_message_endpoint) | **GET** /v1/messages/{message_endpoint_id} | Get a message endpoint
*MessagesApi* | [**list_message_endpoints**](agilicus_api/docs/MessagesApi.md#list_message_endpoints) | **GET** /v1/messages | List all message endpoints (all users or a single user)
*MessagesApi* | [**list_messages_config**](agilicus_api/docs/MessagesApi.md#list_messages_config) | **GET** /v1/messages/config | Get the config of the endpoint-types (e.g. public keys etc).
*MessagesApi* | [**replace_message_endpoint**](agilicus_api/docs/MessagesApi.md#replace_message_endpoint) | **PUT** /v1/messages/{message_endpoint_id} | Update a messaging endpoint
*MessagesApi* | [**update_message_endpoint**](agilicus_api/docs/MessagesApi.md#update_message_endpoint) | **POST** /v1/messages/register/{user_id} | Register a messaging endpoint on a user.
*MetricsApi* | [**list_active_users**](agilicus_api/docs/MetricsApi.md#list_active_users) | **GET** /v1/metrics/{org_id}/active_users | View number of active users
*MetricsApi* | [**list_top_users**](agilicus_api/docs/MetricsApi.md#list_top_users) | **GET** /v1/metrics/{org_id}/top_users | View top users
*OrganisationsApi* | [**create_blocking_upgrade_orgs_task**](agilicus_api/docs/OrganisationsApi.md#create_blocking_upgrade_orgs_task) | **POST** /v1/orgs/upgrade | utility to upgrade organisations
*OrganisationsApi* | [**create_org**](agilicus_api/docs/OrganisationsApi.md#create_org) | **POST** /v1/orgs | Create an organisation
*OrganisationsApi* | [**create_sub_org**](agilicus_api/docs/OrganisationsApi.md#create_sub_org) | **POST** /v1/orgs/{org_id}/orgs | Create a sub organisation
*OrganisationsApi* | [**delete_sub_org**](agilicus_api/docs/OrganisationsApi.md#delete_sub_org) | **DELETE** /v1/orgs/{org_id}/orgs/{sub_org_id} | Delete a sub organisation
*OrganisationsApi* | [**get_org**](agilicus_api/docs/OrganisationsApi.md#get_org) | **GET** /v1/orgs/{org_id} | Get a single organisation
*OrganisationsApi* | [**list_orgs**](agilicus_api/docs/OrganisationsApi.md#list_orgs) | **GET** /v1/orgs | Get all organisations
*OrganisationsApi* | [**list_sub_orgs**](agilicus_api/docs/OrganisationsApi.md#list_sub_orgs) | **GET** /v1/orgs/{org_id}/orgs | Get all sub organisations
*OrganisationsApi* | [**replace_org**](agilicus_api/docs/OrganisationsApi.md#replace_org) | **PUT** /v1/orgs/{org_id} | Create or update an organisation
*PermissionsApi* | [**get_elevated_user_roles**](agilicus_api/docs/PermissionsApi.md#get_elevated_user_roles) | **GET** /v1/elevated_permissions/{user_id} | Get elevated roles for a user
*PermissionsApi* | [**list_elevated_user_roles**](agilicus_api/docs/PermissionsApi.md#list_elevated_user_roles) | **GET** /v1/elevated_permissions | List all elevated users and their roles
*PermissionsApi* | [**replace_elevated_user_role**](agilicus_api/docs/PermissionsApi.md#replace_elevated_user_role) | **PUT** /v1/elevated_permissions/{user_id} | Create or update an elevated user role
*ServicesApi* | [**create_service**](agilicus_api/docs/ServicesApi.md#create_service) | **POST** /v2/services | Create a Service
*ServicesApi* | [**delete_service**](agilicus_api/docs/ServicesApi.md#delete_service) | **DELETE** /v2/services/{service_id} | Remove a Service
*ServicesApi* | [**get_service**](agilicus_api/docs/ServicesApi.md#get_service) | **GET** /v2/services/{service_id} | Get a single Service
*ServicesApi* | [**list_services**](agilicus_api/docs/ServicesApi.md#list_services) | **GET** /v2/services | Get a subset of the Services
*ServicesApi* | [**replace_service**](agilicus_api/docs/ServicesApi.md#replace_service) | **PUT** /v2/services/{service_id} | Create or update a Service.
*TokensApi* | [**create_introspect_token**](agilicus_api/docs/TokensApi.md#create_introspect_token) | **POST** /v1/tokens/introspect | Introspect a token
*TokensApi* | [**create_reissued_token**](agilicus_api/docs/TokensApi.md#create_reissued_token) | **POST** /v1/tokens/reissue | Issue a new token from another
*TokensApi* | [**create_revoke_token_task**](agilicus_api/docs/TokensApi.md#create_revoke_token_task) | **POST** /v1/tokens/revoke | Revoke a token
*TokensApi* | [**create_token**](agilicus_api/docs/TokensApi.md#create_token) | **POST** /v1/tokens | Create a token
*TokensApi* | [**create_token_validation**](agilicus_api/docs/TokensApi.md#create_token_validation) | **POST** /v1/tokens/validations | Validate a token request
*TokensApi* | [**list_tokens**](agilicus_api/docs/TokensApi.md#list_tokens) | **GET** /v1/tokens | Query tokens
*UsersApi* | [**create_challenge_method**](agilicus_api/docs/UsersApi.md#create_challenge_method) | **POST** /users/{user_id}/mfa_challenge_methods | Create a multi-factor authentication method
*UsersApi* | [**create_upstream_user_identity**](agilicus_api/docs/UsersApi.md#create_upstream_user_identity) | **POST** /users/{user_id}/upstream_user_identities | Create an upstream user identity
*UsersApi* | [**create_user**](agilicus_api/docs/UsersApi.md#create_user) | **POST** /users | Create a user
*UsersApi* | [**create_user_identity_update**](agilicus_api/docs/UsersApi.md#create_user_identity_update) | **POST** /users/{user_id}/user_identity_updates | Update a user&#39;s core identity information.
*UsersApi* | [**delete_challenge_method**](agilicus_api/docs/UsersApi.md#delete_challenge_method) | **DELETE** /users/{user_id}/mfa_challenge_methods/{challenge_method_id} | Delete a user&#39;s multi-factor authentication challenge method
*UsersApi* | [**delete_upstream_user_identity**](agilicus_api/docs/UsersApi.md#delete_upstream_user_identity) | **DELETE** /users/{user_id}/upstream_user_identities/{upstream_user_identity_id} | Delete an upstream user identity
*UsersApi* | [**delete_user**](agilicus_api/docs/UsersApi.md#delete_user) | **DELETE** /v1/orgs/{org_id}/users/{user_id} | Remove a user from an organisation
*UsersApi* | [**get_challenge_method**](agilicus_api/docs/UsersApi.md#get_challenge_method) | **GET** /users/{user_id}/mfa_challenge_methods/{challenge_method_id} | Get a single challenge method for the given user
*UsersApi* | [**get_upstream_user_identity**](agilicus_api/docs/UsersApi.md#get_upstream_user_identity) | **GET** /users/{user_id}/upstream_user_identities/{upstream_user_identity_id} | Get a single upstream user identity
*UsersApi* | [**get_user**](agilicus_api/docs/UsersApi.md#get_user) | **GET** /users/{user_id} | Get a single user
*UsersApi* | [**list_all_user_orgs**](agilicus_api/docs/UsersApi.md#list_all_user_orgs) | **GET** /users/{user_id}/orgs | Return all organisations a user has been assigned to
*UsersApi* | [**list_all_user_roles**](agilicus_api/docs/UsersApi.md#list_all_user_roles) | **GET** /users/{user_id}/render_roles | Return all roles for a user
*UsersApi* | [**list_challenge_methods**](agilicus_api/docs/UsersApi.md#list_challenge_methods) | **GET** /users/{user_id}/mfa_challenge_methods | Get all of a user&#39;s multi-factor authentication challenge method configuration
*UsersApi* | [**list_combined_user_details**](agilicus_api/docs/UsersApi.md#list_combined_user_details) | **GET** /v1/combined_user_details | Get all combined details about users
*UsersApi* | [**list_upstream_user_identities**](agilicus_api/docs/UsersApi.md#list_upstream_user_identities) | **GET** /users/{user_id}/upstream_user_identities | Get all of a user&#39;s upstream user identities
*UsersApi* | [**list_user_guids**](agilicus_api/docs/UsersApi.md#list_user_guids) | **GET** /users_ids | Get a list of all user GUIDs
*UsersApi* | [**list_user_permissions**](agilicus_api/docs/UsersApi.md#list_user_permissions) | **GET** /users/{user_id}/host_permissions | Return the user&#39;s host permissions
*UsersApi* | [**list_users**](agilicus_api/docs/UsersApi.md#list_users) | **GET** /users | Get all users
*UsersApi* | [**replace_challenge_method**](agilicus_api/docs/UsersApi.md#replace_challenge_method) | **PUT** /users/{user_id}/mfa_challenge_methods/{challenge_method_id} | Update a user&#39;s multi-factor authentication challenge method
*UsersApi* | [**replace_upstream_user_identity**](agilicus_api/docs/UsersApi.md#replace_upstream_user_identity) | **PUT** /users/{user_id}/upstream_user_identities/{upstream_user_identity_id} | Update an upstream user identity
*UsersApi* | [**replace_user**](agilicus_api/docs/UsersApi.md#replace_user) | **PUT** /users/{user_id} | Create or update a user
*UsersApi* | [**replace_user_role**](agilicus_api/docs/UsersApi.md#replace_user_role) | **PUT** /users/{user_id}/roles | Create or update a user role
*UsersApi* | [**reset_user_mfa_challenge_methods**](agilicus_api/docs/UsersApi.md#reset_user_mfa_challenge_methods) | **POST** /users/{user_id}/reset_mfa_challenge_methods | Resets a user&#39;s multi-factor authentication method
*WhoamiApi* | [**create_whoami**](agilicus_api/docs/WhoamiApi.md#create_whoami) | **POST** /v1/whoami | login through whoami


## Documentation For Models

 - [AddGroupMemberRequest](agilicus_api/docs/AddGroupMemberRequest.md)
 - [Application](agilicus_api/docs/Application.md)
 - [ApplicationAssignment](agilicus_api/docs/ApplicationAssignment.md)
 - [ApplicationService](agilicus_api/docs/ApplicationService.md)
 - [ApplicationServiceAssignment](agilicus_api/docs/ApplicationServiceAssignment.md)
 - [Audit](agilicus_api/docs/Audit.md)
 - [AuthAudits](agilicus_api/docs/AuthAudits.md)
 - [Catalogue](agilicus_api/docs/Catalogue.md)
 - [CatalogueEntry](agilicus_api/docs/CatalogueEntry.md)
 - [Challenge](agilicus_api/docs/Challenge.md)
 - [ChallengeAnswer](agilicus_api/docs/ChallengeAnswer.md)
 - [ChallengeAnswerSpec](agilicus_api/docs/ChallengeAnswerSpec.md)
 - [ChallengeEndpoint](agilicus_api/docs/ChallengeEndpoint.md)
 - [ChallengeSpec](agilicus_api/docs/ChallengeSpec.md)
 - [ChallengeStatus](agilicus_api/docs/ChallengeStatus.md)
 - [CombinedRules](agilicus_api/docs/CombinedRules.md)
 - [CombinedRulesStatus](agilicus_api/docs/CombinedRulesStatus.md)
 - [CombinedUserDetail](agilicus_api/docs/CombinedUserDetail.md)
 - [CombinedUserDetailStatus](agilicus_api/docs/CombinedUserDetailStatus.md)
 - [CommonMetadata](agilicus_api/docs/CommonMetadata.md)
 - [CreateTokenRequest](agilicus_api/docs/CreateTokenRequest.md)
 - [Definition](agilicus_api/docs/Definition.md)
 - [Environment](agilicus_api/docs/Environment.md)
 - [EnvironmentConfig](agilicus_api/docs/EnvironmentConfig.md)
 - [EnvironmentConfigVar](agilicus_api/docs/EnvironmentConfigVar.md)
 - [EnvironmentStatus](agilicus_api/docs/EnvironmentStatus.md)
 - [ErrorMessage](agilicus_api/docs/ErrorMessage.md)
 - [File](agilicus_api/docs/File.md)
 - [FileSummary](agilicus_api/docs/FileSummary.md)
 - [FileUpload](agilicus_api/docs/FileUpload.md)
 - [Group](agilicus_api/docs/Group.md)
 - [GroupData](agilicus_api/docs/GroupData.md)
 - [GroupMember](agilicus_api/docs/GroupMember.md)
 - [HostPermissions](agilicus_api/docs/HostPermissions.md)
 - [HttpRule](agilicus_api/docs/HttpRule.md)
 - [IncludedRole](agilicus_api/docs/IncludedRole.md)
 - [Issuer](agilicus_api/docs/Issuer.md)
 - [IssuerClient](agilicus_api/docs/IssuerClient.md)
 - [JSONBodyConstraint](agilicus_api/docs/JSONBodyConstraint.md)
 - [ListActiveUsersResponse](agilicus_api/docs/ListActiveUsersResponse.md)
 - [ListApplicationServicesResponse](agilicus_api/docs/ListApplicationServicesResponse.md)
 - [ListApplicationsResponse](agilicus_api/docs/ListApplicationsResponse.md)
 - [ListAuditsResponse](agilicus_api/docs/ListAuditsResponse.md)
 - [ListAuthAuditsResponse](agilicus_api/docs/ListAuthAuditsResponse.md)
 - [ListCatalogueEntriesResponse](agilicus_api/docs/ListCatalogueEntriesResponse.md)
 - [ListCataloguesResponse](agilicus_api/docs/ListCataloguesResponse.md)
 - [ListCombinedRulesResponse](agilicus_api/docs/ListCombinedRulesResponse.md)
 - [ListCombinedUserDetailsResponse](agilicus_api/docs/ListCombinedUserDetailsResponse.md)
 - [ListConfigsResponse](agilicus_api/docs/ListConfigsResponse.md)
 - [ListElevatedUserRoles](agilicus_api/docs/ListElevatedUserRoles.md)
 - [ListEnvironmentConfigsResponse](agilicus_api/docs/ListEnvironmentConfigsResponse.md)
 - [ListFilesResponse](agilicus_api/docs/ListFilesResponse.md)
 - [ListGroupsResponse](agilicus_api/docs/ListGroupsResponse.md)
 - [ListIssuerClientsResponse](agilicus_api/docs/ListIssuerClientsResponse.md)
 - [ListIssuerExtensionsResponse](agilicus_api/docs/ListIssuerExtensionsResponse.md)
 - [ListIssuerRootsResponse](agilicus_api/docs/ListIssuerRootsResponse.md)
 - [ListLogsResponse](agilicus_api/docs/ListLogsResponse.md)
 - [ListMFAChallengeMethods](agilicus_api/docs/ListMFAChallengeMethods.md)
 - [ListMessageEndpointsResponse](agilicus_api/docs/ListMessageEndpointsResponse.md)
 - [ListOrgsResponse](agilicus_api/docs/ListOrgsResponse.md)
 - [ListRoleToRuleEntries](agilicus_api/docs/ListRoleToRuleEntries.md)
 - [ListRoles](agilicus_api/docs/ListRoles.md)
 - [ListRules](agilicus_api/docs/ListRules.md)
 - [ListServicesResponse](agilicus_api/docs/ListServicesResponse.md)
 - [ListTOTPEnrollmentResponse](agilicus_api/docs/ListTOTPEnrollmentResponse.md)
 - [ListTokensResponse](agilicus_api/docs/ListTokensResponse.md)
 - [ListTopUsersResponse](agilicus_api/docs/ListTopUsersResponse.md)
 - [ListUpstreamUserIdentitiesResponse](agilicus_api/docs/ListUpstreamUserIdentitiesResponse.md)
 - [ListUserGuidsResponse](agilicus_api/docs/ListUserGuidsResponse.md)
 - [ListUsersResponse](agilicus_api/docs/ListUsersResponse.md)
 - [ListWebAuthNEnrollmentResponse](agilicus_api/docs/ListWebAuthNEnrollmentResponse.md)
 - [Log](agilicus_api/docs/Log.md)
 - [MFAChallengeMethod](agilicus_api/docs/MFAChallengeMethod.md)
 - [MFAChallengeMethodSpec](agilicus_api/docs/MFAChallengeMethodSpec.md)
 - [ManagedUpstreamIdentityProvider](agilicus_api/docs/ManagedUpstreamIdentityProvider.md)
 - [Message](agilicus_api/docs/Message.md)
 - [MessageAction](agilicus_api/docs/MessageAction.md)
 - [MessageEndpoint](agilicus_api/docs/MessageEndpoint.md)
 - [MessageEndpointMetadata](agilicus_api/docs/MessageEndpointMetadata.md)
 - [MessageEndpointSpec](agilicus_api/docs/MessageEndpointSpec.md)
 - [MessageEndpointType](agilicus_api/docs/MessageEndpointType.md)
 - [MessageEndpointTypeWebPush](agilicus_api/docs/MessageEndpointTypeWebPush.md)
 - [MessageEndpointsConfig](agilicus_api/docs/MessageEndpointsConfig.md)
 - [MetadataWithId](agilicus_api/docs/MetadataWithId.md)
 - [MetadataWithIdAllOf](agilicus_api/docs/MetadataWithIdAllOf.md)
 - [MetadataWithOnlyId](agilicus_api/docs/MetadataWithOnlyId.md)
 - [OIDCUpstreamIdentityProvider](agilicus_api/docs/OIDCUpstreamIdentityProvider.md)
 - [Organisation](agilicus_api/docs/Organisation.md)
 - [OrganisationAdmin](agilicus_api/docs/OrganisationAdmin.md)
 - [RawToken](agilicus_api/docs/RawToken.md)
 - [RenderedQueryParameter](agilicus_api/docs/RenderedQueryParameter.md)
 - [RenderedRule](agilicus_api/docs/RenderedRule.md)
 - [RenderedRuleBody](agilicus_api/docs/RenderedRuleBody.md)
 - [ReplaceUserRoleRequest](agilicus_api/docs/ReplaceUserRoleRequest.md)
 - [ResetMFAChallengeMethod](agilicus_api/docs/ResetMFAChallengeMethod.md)
 - [Role](agilicus_api/docs/Role.md)
 - [RoleList](agilicus_api/docs/RoleList.md)
 - [RoleSpec](agilicus_api/docs/RoleSpec.md)
 - [RoleToRuleEntry](agilicus_api/docs/RoleToRuleEntry.md)
 - [RoleToRuleEntrySpec](agilicus_api/docs/RoleToRuleEntrySpec.md)
 - [RoleV2](agilicus_api/docs/RoleV2.md)
 - [Roles](agilicus_api/docs/Roles.md)
 - [Rule](agilicus_api/docs/Rule.md)
 - [RuleQueryBody](agilicus_api/docs/RuleQueryBody.md)
 - [RuleQueryBodyJSON](agilicus_api/docs/RuleQueryBodyJSON.md)
 - [RuleQueryParameter](agilicus_api/docs/RuleQueryParameter.md)
 - [RuleScopeEnum](agilicus_api/docs/RuleScopeEnum.md)
 - [RuleSpec](agilicus_api/docs/RuleSpec.md)
 - [RuleV2](agilicus_api/docs/RuleV2.md)
 - [RuntimeStatus](agilicus_api/docs/RuntimeStatus.md)
 - [Service](agilicus_api/docs/Service.md)
 - [StorageRegion](agilicus_api/docs/StorageRegion.md)
 - [TOTPEnrollment](agilicus_api/docs/TOTPEnrollment.md)
 - [TOTPEnrollmentAnswer](agilicus_api/docs/TOTPEnrollmentAnswer.md)
 - [TOTPEnrollmentSpec](agilicus_api/docs/TOTPEnrollmentSpec.md)
 - [TOTPEnrollmentStatus](agilicus_api/docs/TOTPEnrollmentStatus.md)
 - [TimeIntervalMetrics](agilicus_api/docs/TimeIntervalMetrics.md)
 - [TimeValidity](agilicus_api/docs/TimeValidity.md)
 - [Token](agilicus_api/docs/Token.md)
 - [TokenIntrospect](agilicus_api/docs/TokenIntrospect.md)
 - [TokenIntrospectOptions](agilicus_api/docs/TokenIntrospectOptions.md)
 - [TokenReissueRequest](agilicus_api/docs/TokenReissueRequest.md)
 - [TokenRevoke](agilicus_api/docs/TokenRevoke.md)
 - [TokenValidity](agilicus_api/docs/TokenValidity.md)
 - [UpstreamUserIdentity](agilicus_api/docs/UpstreamUserIdentity.md)
 - [UpstreamUserIdentitySpec](agilicus_api/docs/UpstreamUserIdentitySpec.md)
 - [User](agilicus_api/docs/User.md)
 - [UserIdentity](agilicus_api/docs/UserIdentity.md)
 - [UserIdentityUpdate](agilicus_api/docs/UserIdentityUpdate.md)
 - [UserIdentityUpdateSpec](agilicus_api/docs/UserIdentityUpdateSpec.md)
 - [UserInfo](agilicus_api/docs/UserInfo.md)
 - [UserMemberOf](agilicus_api/docs/UserMemberOf.md)
 - [UserMetrics](agilicus_api/docs/UserMetrics.md)
 - [UserRoles](agilicus_api/docs/UserRoles.md)
 - [UserSummary](agilicus_api/docs/UserSummary.md)
 - [WebAuthNEnrollment](agilicus_api/docs/WebAuthNEnrollment.md)
 - [WebAuthNEnrollmentAnswer](agilicus_api/docs/WebAuthNEnrollmentAnswer.md)
 - [WebAuthNEnrollmentSpec](agilicus_api/docs/WebAuthNEnrollmentSpec.md)
 - [WebAuthNEnrollmentStatus](agilicus_api/docs/WebAuthNEnrollmentStatus.md)
 - [WhoamiRequest](agilicus_api/docs/WhoamiRequest.md)
 - [WhoamiResponse](agilicus_api/docs/WhoamiResponse.md)


## Documentation For Authorization


## token-valid

- **Type**: Bearer authentication (JWT)


## Author

dev@agilicus.com


