# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['agilicus',
 'agilicus.agilicus_api',
 'agilicus.agilicus_api.api',
 'agilicus.agilicus_api.models',
 'agilicus.agilicus_api.test',
 'agilicus.output']

package_data = \
{'': ['*'],
 'agilicus': ['.openapi-generator/*'],
 'agilicus.agilicus_api': ['docs/*']}

install_requires = \
['PyJWT>=1.7.0,<1.8.0',
 'certifi>=14.05.14',
 'click-shell>=2.0,<3.0',
 'oauth2client>=4.1.3,<4.2.0',
 'prettytable>=0.7.2,<0.8.0',
 'python_dateutil>2.5.3',
 'requests>=2.23.0,<2.24.0',
 'six>=1.14.0,<2.0.0']

entry_points = \
{'console_scripts': ['agilicus-cli = agilicus.main:main']}

setup_kwargs = {
    'name': 'agilicus',
    'version': '1.56.1',
    'description': 'Agilicus SDK',
    'long_description': '## Agilicus SDK (Python)\n\nThe Agilicus Platform API is defined using [OpenAPI 3.0](https://github.com/OAI/OpenAPI-Specification),\nand may be used from any language. You can see the API specification\n[online](https://www.agilicus.com/api).\n\nThis package provides a Python SDK, class library interfaces for use in\naccessing individual collections. In addition it provides a command-line-interface (CLI)\nfor interactive use.\n\nRead the class-library documentation [online](https://agilicus.storage.googleapis.com/sdk/py/README.html)\n\nA subset of this code (that which accesses the above API) is [generated](agilicus/agilicus_api_README.md)\n\nGenerally you may install this as:\n```\npip install --upgrade agilicus\n```\n\nYou may wish to add bash completion by adding this to your ~/.bashrc:\n```\neval "$(_AGILICUS_CLI_COMPLETE=source agilicus-cli)"\n```\n\n## Build\n\n(first generate the api access, \'cd ..; ./local-build\')\n\n```\npoetry install\npoetry run pre-commit install\npoetry run pytest\n```\n\nTo run the CLI from the development venv:\ngene\n\n`poetry run python -m agilicus.main`\n\nTo format & lint:\n\n```\npoetry run black .\npoetry run flake8\n```\n\n## CLI Usage\n\nCredentials are cached in ~/.config/agilicus, per issuer.\n\n```\nagilicus-cli --client_id admin-portal --issuer https://auth.cloud.egov.city list-applications\n```\n\n## Debugging with Codium\n\n```\n"python.venvPath": "~/.cache/pypoetry/virtualenvs"\n```\n',
    'author': 'Agilicus Devs',
    'author_email': 'dev@agilicus.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
