"""Prefect Tasks für MongoDB und Solr Operationen."""

from .mongodb import (
    check_indexes,
    fetch_documents_cursor,
    validate_and_filter_document,
    extract_ids_from_documents,
)
from .solr import (
    delete_by_query,
    upsert_batch,
    delete_by_ids,
)

__all__ = [
    "check_indexes",
    "fetch_documents_cursor",
    "validate_and_filter_document",
    "extract_ids_from_documents",
    "delete_by_query",
    "upsert_batch",
    "delete_by_ids",
]
