# !/usr/bin/python3
# -*- coding:utf-8 -*-
"""
@Author: xiaodong.li
@Time: 2024/09/06 14:40
@Description: Description
@File: auth_service.py
"""
from api_requester.core.admin.api.auth_api import AdminAuthApi
from api_requester.core.admin.dto.jwt_authentication_request import JwtAuthenticationRequest


class AdminAuthService(AdminAuthApi):
    """
    The AdminAuthService was generated by Generator from the AuthController.java file.
    """

    def __init__(self):
        AdminAuthApi.__init__(self)

    def create_authentication_token(self, authentication_request: JwtAuthenticationRequest = None):
        return self.create_authentication_token_api(json=authentication_request)

    def refresh_and_get_authentication_token(self):
        return self.refresh_and_get_authentication_token_api()

    def logout(self):
        return self.logout_api()

    def logout_all(self, login_name: str = None):
        return self.logout_all_api(params=dict(loginName=login_name))

    def me(self):
        return self.me_api()
