# !/usr/bin/python3
# -*- coding:utf-8 -*-
"""
@Author: xiaodong.li
@Time: 2024/09/06 14:41
@Description: Description
@File: subject_auth_service.py
"""
from api_requester.core.admin.api.subject_auth_api import AdminSubjectAuthApi
from api_requester.core.admin.dto.jwt_authentication_request import JwtAuthenticationRequest
from api_requester.core.admin.dto.subject_jwt_authentication_request import SubjectJwtAuthenticationRequest


class AdminSubjectAuthService(AdminSubjectAuthApi):
    """
    The AdminSubjectAuthService was generated by Generator from the SubjectAuthController.java file.
    """

    def __init__(self):
        AdminSubjectAuthApi.__init__(self)

    def auth_subject_login(self, authentication_request: SubjectJwtAuthenticationRequest = None):
        return self.auth_subject_login_api(json=authentication_request)

    def auth_subject_logout(self):
        return self.auth_subject_logout_api()

    def auth_subject_me(self):
        return self.auth_subject_me_api()

    def verify_organization_code(self, organization_code: str = None):
        return self.verify_organization_code_api(params=dict(organizationCode=organization_code))
