# !/usr/bin/python3
# -*- coding:utf-8 -*-
"""
@Author: xiaodong.li
@Time: 2024/11/22 10:32
@Description: Description
@File: ecoa_auth_service.py
"""
from typing import List

from api_requester.core.common.api.ecoa_auth_api import CommonEcoaAuthApi
from api_requester.core.common.dto.portal_login_t_ime import PortalLoginTIme


class CommonEcoaAuthService(CommonEcoaAuthApi):
    """
    The CommonEcoaAuthService was generated by Generator from the EcoaAuthController.java file.
    """

    def __init__(self):
        CommonEcoaAuthApi.__init__(self)

    def create_authentication_token(self, portal_login_time: PortalLoginTIme = None):
        return self.create_authentication_token_api(json=portal_login_time)

    def refresh_and_get_authentication_token(self):
        return self.refresh_and_get_authentication_token_api()

    def logout(self):
        return self.logout_api()

    def all_study_logout(self, tokens: List[str] = None):
        return self.all_study_logout_api(json=tokens)

    def me(self):
        return self.me_api()

    def ecoa_account(self):
        return self.ecoa_account_api()

    def change_password(self, ecoa_account_change_password_dto=None):
        return self.change_password_api(json=ecoa_account_change_password_dto)

    def change_study_language(self, language_id: int = None):
        return self.change_study_language_api(params=dict(languageId=language_id))
