---
name: Feature request
about: Suggest an idea for this project
title: '[FEATURE] '
labels: enhancement
assignees: ''

---

**Is your feature request related to a problem? Please describe.**
A clear and concise description of what the problem is. Ex. I'm always frustrated when [...]

**Describe the solution you'd like**
A clear and concise description of what you want to happen.

**Describe alternatives you've considered**
A clear and concise description of any alternative solutions or features you've considered.

**Use case**
Describe a specific use case for this feature. How would you use it?

**Example usage**
```python
# Please provide an example of how you would like to use this feature
from panparsex import parse

# Your example code here
```

**File type support**
If this is related to a new file type, please provide:
- File extension(s): [e.g. .xyz]
- MIME type(s): [e.g. application/xyz]
- Description: [Brief description of the file format]
- Sample file: [If possible, attach a small sample file]

**Additional context**
Add any other context or screenshots about the feature request here.

**Priority**
How important is this feature to you?
- [ ] Critical - I need this to use the library
- [ ] Important - This would significantly improve my workflow
- [ ] Nice to have - This would be a useful addition
- [ ] Low priority - Just an idea

**Implementation**
If you're willing to contribute, please indicate:
- [ ] I can implement this feature
- [ ] I can help with testing
- [ ] I can help with documentation
- [ ] I can provide sample files
- [ ] I can provide feedback during development
