## Description
Brief description of the changes in this PR.

## Type of Change
- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Performance improvement
- [ ] Code refactoring
- [ ] Test addition/update

## Related Issues
Fixes #(issue number)
Closes #(issue number)
Related to #(issue number)

## Changes Made
- [ ] Added new parser for [file type]
- [ ] Enhanced existing parser functionality
- [ ] Improved error handling
- [ ] Updated documentation
- [ ] Added tests
- [ ] Fixed bug in [component]
- [ ] Performance optimization
- [ ] Other: [describe]

## Testing
- [ ] All existing tests pass
- [ ] New tests added for new functionality
- [ ] Manual testing performed
- [ ] Tested on multiple Python versions (3.9, 3.10, 3.11, 3.12)
- [ ] Tested on multiple operating systems (Ubuntu, Windows, macOS)

## Code Quality
- [ ] Code follows project style guidelines
- [ ] Type hints added/updated
- [ ] Docstrings added/updated
- [ ] No linting errors
- [ ] No type checking errors
- [ ] Code is properly formatted with black

## Documentation
- [ ] README.md updated (if applicable)
- [ ] API documentation updated (if applicable)
- [ ] Examples added/updated (if applicable)
- [ ] Changelog updated (if applicable)

## Performance Impact
- [ ] No performance impact
- [ ] Performance improvement
- [ ] Performance regression (explain below)

## Breaking Changes
- [ ] No breaking changes
- [ ] Breaking changes (explain below)

## Additional Notes
Any additional information, context, or notes for reviewers.

## Checklist
- [ ] My code follows the project's style guidelines
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published

## Screenshots (if applicable)
Add screenshots to help explain your changes.

## Example Usage (if applicable)
```python
# Example of how to use the new functionality
from panparsex import parse

# Your example code here
```
