# 🌈 Harmony CLI

Beautiful command-line interface for **Harmony AI** - Advanced AI Assistant developed by **Mergen AI**.

![Harmony CLI](https://img.shields.io/badge/Harmony-CLI-E72166?style=for-the-badge&logo=python)
![Python](https://img.shields.io/badge/Python-3.8+-blue?style=for-the-badge&logo=python)
![License](https://img.shields.io/badge/License-MIT-green?style=for-the-badge)

## ✨ Features

- 🎨 **Beautiful Interface** - Rich, colorful terminal UI with rainbow text
- 🚀 **Streaming Responses** - Real-time AI responses with smooth animations
- 💬 **Conversation History** - Keep track of your chat sessions
- 📊 **Session Statistics** - Monitor your usage and performance
- 🔧 **Debug Mode** - Advanced debugging capabilities
- 🌐 **Cloud-Powered** - Uses HAL-Harmony-120B model via Mergen AI's infrastructure

## 🚀 Installation

Install Harmony CLI using pip:

```bash
pip install harmony-cli
```

## 🎯 Quick Start

After installation, simply run:

```bash
harmony
```

Or:

```bash
harmony-cli
```

## 🎮 Commands

- `/help` - Show available commands
- `/clear` - Clear conversation history
- `/history` - Show conversation history
- `/stats` - Show session statistics
- `/about` - About Harmony AI and Mergen AI
- `/apikey` - Change API key interactively ✨ NEW!
- `/debug` - Toggle debug mode
- `/quit` or `/exit` - Exit the application

## 🤖 About Harmony AI

**Harmony AI** is powered by the **HAL-Harmony-120B** model, an advanced AI assistant developed by **Mergen AI**. It's designed for real-world applications and communicates in a clear, intelligent, and highly informative way.

### Key Features:
- 🧠 **Advanced AI Model**: HAL-Harmony-120B
- 🌍 **Multilingual**: Trained primarily on Azerbaijani data, supports multiple languages
- 🏢 **Enterprise Ready**: Developed by Mergen AI for professional use
- ⚡ **High Performance**: Optimized for speed and accuracy

## 🏢 About Mergen AI

**Mergen AI** is a leading artificial intelligence company focused on developing cutting-edge AI solutions. We specialize in:

- 🤖 Advanced AI model development
- 🌐 AI infrastructure and APIs
- 💼 Enterprise AI solutions
- 🔬 AI research and innovation

Visit us at: [hal-x.ai](https://hal-x.ai)

## 📝 Usage Examples

### Basic Chat
```bash
$ harmony
🌈 Harmony > Hello! How are you today?
🤖 Hello! I'm doing great, thank you for asking! How can I assist you today?
```

### View Statistics
```bash
🌈 Harmony > /stats
📊 Session Statistics:
- Messages sent: 5
- Total tokens: 1,234
- Session duration: 5m 32s
```

### Get Help
```bash
🌈 Harmony > /help
🎮 Available Commands:
- /help - Show this help message
- /clear - Clear conversation history
- /history - Show conversation history
- /stats - Show session statistics
- /about - About Harmony AI and Mergen AI
- /debug - Toggle debug mode
- /quit - Exit the application
```

## 🔧 Configuration

### API Key Setup

Harmony CLI offers **two convenient ways** to set your API key:

#### Option 1: Interactive Input ✨ NEW!
Simply run `harmony` and the CLI will prompt you to enter your API key:

```bash
$ harmony
🔑 Welcome to Harmony CLI!
🔑 Please enter your API key: [hidden input]
✅ API Key Set Successfully!
```

#### Option 2: Environment Variable
Set the environment variable once and never worry about it again:

```bash
# Windows
set HARMONY_API_KEY=your-api-key-here

# Linux/Mac
export HARMONY_API_KEY=your-api-key-here
```

### Change API Key During Session
You can change your API key anytime during a chat session:

```bash
🌈 Harmony > /apikey
🔑 Change API Key
Current key: hm-w60NQiv...
🔑 New API key: [hidden input]
✅ API key updated successfully!
```

## 🐛 Troubleshooting

If you encounter any issues:

1. **Update to the latest version**:
   ```bash
   pip install --upgrade harmony-cli
   ```

2. **Enable debug mode**:
   ```bash
   🌈 Harmony > /debug
   ```

3. **Check your internet connection** - Harmony CLI requires internet access to communicate with our AI servers.

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🤝 Support

- 📧 **Email**: support@mergen.az
- 🌐 **Website**: [hal-x.ai](https://hal-x.ai)
- 📚 **Documentation**: [docs.mergen.az](https://docs.mergen.az)
- 🐛 **Issues**: [GitHub Issues](https://github.com/mergen-ai/harmony-cli/issues)

## 🎉 Contributing

We welcome contributions! Please feel free to submit a Pull Request.

---

**Made with ❤️ by Mergen AI**

*Intelligence with everyone. For everyone. For Azerbaijan.*
