# mypy-boto3-medialive

[![PyPI - mypy-boto3-medialive](https://img.shields.io/pypi/v/mypy-boto3-medialive.svg?color=blue)](https://pypi.org/project/mypy-boto3-medialive)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-medialive.svg?color=blue)](https://pypi.org/project/mypy-boto3-medialive)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MediaLive 1.14.5](https://boto3.amazonaws.com/v1/documentation/api/1.14.5/reference/services/medialive.html#MediaLive) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `MediaLive` service.

```bash
python -m pip install boto3-stubs[medialive]
```

## How to use

### Client annotations

`MediaLiveClient` provides annotations for `boto3.client("medialive")`.

```python
import boto3

from mypy_boto3_medialive import MediaLiveClient
from mypy_boto3_medialive.paginator import (
    DescribeSchedulePaginator,
    ListChannelsPaginator,
    ListInputDevicesPaginator,
    ListInputSecurityGroupsPaginator,
    ListInputsPaginator,
    ListMultiplexesPaginator,
    ListMultiplexProgramsPaginator,
    ListOfferingsPaginator,
    ListReservationsPaginator,
)
from mypy_boto3_medialive.type_defs import AacSettingsTypeDef, ...
from mypy_boto3_medialive.waiter import (
    ChannelCreatedWaiter,
    ChannelDeletedWaiter,
    ChannelRunningWaiter,
    ChannelStoppedWaiter,
    InputAttachedWaiter,
    InputDeletedWaiter,
    InputDetachedWaiter,
    MultiplexCreatedWaiter,
    MultiplexDeletedWaiter,
    MultiplexRunningWaiter,
    MultiplexStoppedWaiter,
)

client: MediaLiveClient = boto3.client("medialive")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MediaLiveClient = session.client("medialive")
```

### Paginators annotations

`mypy_boto3_medialive.paginator` module contains type annotations for all paginators.

```python

client: MediaLiveClient = boto3.client("medialive")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_schedule_paginator: DescribeSchedulePaginator = client.get_paginator("describe_schedule")
list_channels_paginator: ListChannelsPaginator = client.get_paginator("list_channels")
list_input_devices_paginator: ListInputDevicesPaginator = client.get_paginator("list_input_devices")
list_input_security_groups_paginator: ListInputSecurityGroupsPaginator = client.get_paginator("list_input_security_groups")
list_inputs_paginator: ListInputsPaginator = client.get_paginator("list_inputs")
list_multiplex_programs_paginator: ListMultiplexProgramsPaginator = client.get_paginator("list_multiplex_programs")
list_multiplexes_paginator: ListMultiplexesPaginator = client.get_paginator("list_multiplexes")
list_offerings_paginator: ListOfferingsPaginator = client.get_paginator("list_offerings")
list_reservations_paginator: ListReservationsPaginator = client.get_paginator("list_reservations")
```


### Waiters annotations

`mypy_boto3_medialive.waiter` module contains type annotations for all waiters.

```python

client: MediaLiveClient = boto3.client("medialive")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
channel_created_waiter: ChannelCreatedWaiter = client.get_waiter("channel_created")
channel_deleted_waiter: ChannelDeletedWaiter = client.get_waiter("channel_deleted")
channel_running_waiter: ChannelRunningWaiter = client.get_waiter("channel_running")
channel_stopped_waiter: ChannelStoppedWaiter = client.get_waiter("channel_stopped")
input_attached_waiter: InputAttachedWaiter = client.get_waiter("input_attached")
input_deleted_waiter: InputDeletedWaiter = client.get_waiter("input_deleted")
input_detached_waiter: InputDetachedWaiter = client.get_waiter("input_detached")
multiplex_created_waiter: MultiplexCreatedWaiter = client.get_waiter("multiplex_created")
multiplex_deleted_waiter: MultiplexDeletedWaiter = client.get_waiter("multiplex_deleted")
multiplex_running_waiter: MultiplexRunningWaiter = client.get_waiter("multiplex_running")
multiplex_stopped_waiter: MultiplexStoppedWaiter = client.get_waiter("multiplex_stopped")
```





### Typed dictionations

`mypy_boto3_medialive.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AacSettingsTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_medialive` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("medialive")

session_client = boto3.Session().client("medialive")
```
