from collections.abc import Sequence
from typing import Literal

from matplotlib._stubs_utils._typing import ArrayLike, Color

from .axes import Axes
from .colors import Colormap, Normalize

__all__ = ["streamplot"]

def streamplot(
    axes: Axes,
    x: ArrayLike,
    y: ArrayLike,
    u: ArrayLike,
    v: ArrayLike,
    density: float = ...,
    linewidth: float = ...,
    color: Color = ...,
    cmap: Colormap = ...,
    norm: Normalize = ...,
    arrowsize: float = ...,
    arrowstyle: str = ...,
    minlength: float = ...,
    transform=...,
    zorder: int = ...,
    start_points: ArrayLike = ...,
    maxlength: float = ...,
    integration_direction: Literal["forward", "backward", "both"] = ...,
    broken_streamlines: bool = ...,
) -> StreamplotSet: ...

class StreamplotSet:
    def __init__(self, lines, arrows) -> None: ...

class DomainMap:
    def __init__(self, grid: Grid, mask: StreamMask) -> None: ...
    def grid2mask(self, xi, yi): ...
    def mask2grid(self, xm, ym): ...
    def data2grid(self, xd, yd): ...
    def grid2data(self, xg, yg): ...
    def start_trajectory(self, xg, yg, broken_streamlines=...): ...
    def reset_start_point(self, xg, yg): ...
    def update_trajectory(self, xg, yg, broken_streamlines=...): ...
    def undo_trajectory(self) -> None: ...

class Grid:
    def __init__(self, x, y) -> None: ...
    @property
    def shape(self) -> tuple[int, int]: ...
    def within_grid(self, xi, yi): ...

class StreamMask:
    def __init__(self, density: float | Sequence[float]) -> None: ...
    def __getitem__(self, args): ...

class InvalidIndexError(Exception): ...
class TerminateTrajectory(Exception): ...

def get_integrator(u, v, dmap, minlength, maxlength, integration_direction): ...

class OutOfBounds(IndexError): ...

def interpgrid(a, xi, yi): ...
